<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\header\HeaderController;
use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Program;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Storage;
use PhpOffice\PhpSpreadsheet\IOFactory;

class ProgramController extends Controller
{
    //


    public function index(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();

        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            $idusertype = Auth::User()->usertype_id;

            if ($userTypeAccesocombo == "1" && ($idusertype == "1" || $idusertype == "4" || $idusertype == "5" || $idusertype == "7")) {
                $objetoarea = new HeaderController();
                $dataarea = $objetoarea->DataAreaAdm();
                $tipoacceso = 1;
                $dataAreaNombre = $dataarea[0]['NOMBRE'];;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.institucion.programas.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar)->with('dataarea', $dataAreaNombre);
            } else if ($userTypeAccesocombo == "2"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            }else if ($userTypeAccesocombo == "3"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }

    public function listproftec(Request $request)
    {
        if ($request->ajax()) {
            $data = Program::select('id', 'nombre','codprograma', 'nivel_formativo', 'created_at')
            ->where('nivel_formativo', 'Profesional Técnico')
            ->get();

            return \Yajra\DataTables\DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }

    public function listtec(Request $request)
    {
        if ($request->ajax()) {
            $data = Program::select('id', 'nombre','codprograma', 'nivel_formativo', 'created_at')
            ->where('nivel_formativo', 'Técnico')
            ->get();

            return \Yajra\DataTables\DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }

    public function store(Request $request)
    {

        $item = new Program();
        $item->codprograma = $request->input('codprograma');
        $item->nombre = $request->input('nombreprograma');
        $item->nivel_formativo = $request->input('nivelformativo');
        // Asigna otros campos según tus necesidades


        // $categoryData = [
        //     [
        //         'name' => $item->nombre, // Nombre de la categoría
        //         'parent' => 0, // ID de la categoría padre, 0 para raíz
        //         'descriptionformat' => 1, // 1 para formato HTML
        //     ]
        // ];

        // // Guardar los datos en el moodle
        // $moodleUrl = 'https://eva.casma.silferacademic.com/webservice/rest/server.php';
        // $token = '7dfe67aa33edc19f83b3454eae7b77b7';
        // $params = [
        //     'wstoken' => $token,
        //     'wsfunction' => 'core_course_create_categories',
        //     'moodlewsrestformat' => 'json',
        //     'categories' => $categoryData,
        // ];
        // $response = Http::asForm()->post($moodleUrl, $params);
        // $result = $response->json();

        // if (isset($result['exception'])) {
        //     return response()->json([
        //         "status" => false,
        //         "mensaje" => 'Errir: registros no guardado en Moodle'
        //     ]);
        // }

        // // Verificar si la categoría fue creada exitosamente y capturar el ID
        // if (isset($result[0]['id'])) {
        //     $moodleCategoryId = $result[0]['id'];
        //     $item->moodle_programa_id = $moodleCategoryId; // Suponiendo que tienes esta columna en tu tabla 'programs'
        // } else {
        //     return response()->json([
        //         "status" => false,
        //         "mensaje" => 'Error: no se pudo obtener el ID de la categoría en Moodle'
        //     ]);
        // }


        // Guarda el nuevo registro en la base de datos
        if ($item->save()) {
            // El guardado fue exitoso
            return response()->json([
                "status" => true,
                "mensaje" => 'Éxito: registros realizado'
            ]);
        } else {
            // El guardado falló
            return response()->json([
                "status" => false,
                "mensaje" => 'Error: registros no realizado'
            ]);
        }
    }


    public function destroy($id)
    {
        // Busca el registro por su ID
        $program = Program::find($id);

        // Verifica si el registro existe
        if (!$program) {
            return response()->json([
                "status" => false,
                "mensaje" => 'Error, el registro nos existe'
            ]);
        }

        $category_id =  $program->moodle_programa_id;


        // Configuración de la API de Moodle
        $moodleUrl = 'https://eva.casma.silferacademic.com/webservice/rest/server.php';
        $token = '7dfe67aa33edc19f83b3454eae7b77b7'; // Token de la API

        // Parámetros para eliminar la categoría
        $params = [
            'wstoken' => $token,
            'wsfunction' => 'core_course_delete_categories',
            'moodlewsrestformat' => 'json',
            'categories[0][id]' => $category_id, // ID de la categoría a eliminar
            'categories[0][recursive]' => 1, // 1 para eliminar contenido, 0 para categorías vacías
        ];

        // Realizar la solicitud POST a la API de Moodle
        $response = Http::asForm()->post($moodleUrl, $params);
        $result = $response->json();

        // Verifica si hubo un error en la API de Moodle
        if (isset($result['exception'])) {
            return response()->json([
                "status" => false,
                "mensaje" => 'Error: no se pudo eliminar la categoría en Moodle'
            ]);
        }

        // Elimina el registro de la base de datos
        if ($program->delete()) {
            return response()->json([
                "status" => true,
                "mensaje" => 'Éxito, el registro fue eliminado'
            ]);
        } else {
            return response()->json([
                "status" => false,
                "mensaje" => 'Error, al eliminar registro'
            ]);
        }
    }


    public function ajax_all(Request $request)
    {
        if ($request->ajax()) {
            // $data = Program::all();
            $data = Program::orderBy('nombre','asc')->get();
            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }



    public function cargarExcelproftec(Request $request)
    {
            $fileName = "public/Plantillaprogramas/CATALOGO_PROFESIONAL_TECNICO.xlsx";


        if (Storage::disk('local')->exists($fileName)) {
            // Obtener el archivo del storage
            $filePath = storage_path('app/'.$fileName); // Ruta al archivo Excel en el almacenamiento

            $spreadsheet = IOFactory::load($filePath);
            $data = $spreadsheet->getActiveSheet()->toArray();

            // Procesar los datos y devolver la respuesta en formato JSON
            return response()->json(['data' => $data]);

        } else {
            // Mostrar un error
            return abort(404);
        }

    }

    public function cargarExceltec(Request $request)
    {

        $fileName = "public/Plantillaprogramas/CATALOGO_TECNICO.xlsx";
        if (Storage::disk('local')->exists($fileName)) {
            // Obtener el archivo del storage
            $filePath = storage_path('app/'.$fileName); // Ruta al archivo Excel en el almacenamiento

            $spreadsheet = IOFactory::load($filePath);
            $data = $spreadsheet->getActiveSheet()->toArray();

            // Procesar los datos y devolver la respuesta en formato JSON
            return response()->json(['data' => $data]);

        } else {
            // Mostrar un error
            return abort(404);
        }

    }
}
