<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\header\HeaderController;
use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Applicant;
use App\Models\Admissionplan;
use App\Models\Student;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\Teacher;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;
use Carbon\Carbon;
use Exception;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use PhpOffice\PhpSpreadsheet\IOFactory;

class PostulantesController extends Controller
{

    public function index(Request $request)
    {
        $objeto = new SidebarController();
        $sidebar = $objeto->ListmodulosSidebar();

        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');
            $idusertype = Auth::User()->usertype_id;
            if ($userTypeAccesocombo == "1" && ($idusertype == "1" || $idusertype == "4" || $idusertype == "5" || $idusertype == "7")) {
                $objetoarea = new HeaderController();
                $dataarea = $objetoarea->DataAreaAdm();
                $tipoacceso = 1;
                $dataAreaNombre = $dataarea[0]['NOMBRE'];;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.admision.postulantes.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar)->with('dataarea', $dataAreaNombre);
            } else if ($userTypeAccesocombo == "2") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            } else if ($userTypeAccesocombo == "3") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function list_admisiones()
    {
        try {
            DB::statement("SET lc_time_names = 'es_ES'");
            $result = DB::table('admisiones as ad')
                ->select(
                    'ad.id as idadmission',
                    'ad.anho',
                    DB::raw('DATE_FORMAT(ad.fecinicio, "%d de %M") as fecinicio'),
                    DB::raw('DATE_FORMAT(ad.fecfin, "%d de %M") as fecfin'),
                    'ad.estado',
                )
                ->where('ad.estado', '=', 1)
                ->orderBy('ad.anho', 'desc')
                ->get();

            return response()->json($result);
        } catch (Exception $e) {

            return response()->json([
                'estado' => false,
                'type' => 'Catch',
                'mensaje' => $e
            ]);
        }
    }


    public function listadmissionplan(Request $request, $idadmission)
    {
        try {
            if ($request->ajax()) {
                $result = Admissionplan::select('p.id as idplan', 'admisiones_planes.id as idadmissionplan', 'admisiones_planes.admission_id as idadmision', 'pro.nombre as programa', 'p.nombre as plan', 'p.tipo', 'p.modalidad', 'p.enfoque')
                    ->join('admisiones as a', 'a.id', '=', 'admisiones_planes.admission_id')
                    ->join('planes as p', 'p.id', '=', 'admisiones_planes.plan_id')
                    ->join('programas as pro', 'pro.id', '=', 'p.program_id')
                    ->where('admisiones_planes.admission_id', '=', $idadmission)
                    ->distinct()
                    ->get();
                return response()->json($result);
            } else {
                return response()->json([
                    'estado' => false,
                    'mensaje' => "error de consulta"
                ]);
            }
        } catch (Exception $e) {

            return response()->json([
                'estado' => false,
                'type' => 'Catch',
                'mensaje' => $e
            ]);
        }
    }

    public function downloadExcelFile(Request $request)
    {
        $fileName = 'public/Plantillapostulantes/Plantilla_postulantes.xlsx';
        // Verificar si el archivo existe
        if (Storage::disk('local')->exists($fileName)) {
            // Obtener el archivo del storage
            $file = storage_path('app/' . $fileName);
            $plantilla = IOFactory::load($file);
            $programa =  $request->input('txt_name_programa_title');
            $plan =  $request->input('txt_name_plan_title');
            $sheet = $plantilla->getActiveSheet();
            $sheet->setCellValue('B2', $programa)
                ->setCellValue('J2', $plan);
            // Establecer encabezados para forzar la descarga
            header("Content-Disposition: attachment; filename=" . $file);
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Cache-Control: max-age=0');
            // header("Content-Length: " . filesize($carpeta . $archivo));
            // Crear un escritor y enviar el archivo al flujo de salida
            $writer = IOFactory::createWriter($plantilla, 'Xlsx');
            $writer->save('php://output');
        } else {
            // Mostrar un error
            return abort(404);
        }
    }


    public function store_plantilla(Request $request)
    {
        $datos = $request->input('datajsondos');
        $idadmissionplan = $request->input('idadmissionplan');
        $estado_admision = $request->input('estado_admision');
        $countApplicants = 0;
        $countrepetido = 0;
        $miArraynroidentiRepet = [];

        foreach ($datos as $dato) {
            $user = Applicant::where('nroidenti', $dato[1])->first(); // Buscar el usuario por su correo electrónico

            if ($user) {
                $countrepetido++;
                array_push($miArraynroidentiRepet, $dato[1]);
            } else {
                $item = new Applicant();

                // TIPO IDENTI
                if ($dato[0] == 'DNI') {
                    $idtype = 1;
                } else if ($dato[0] == 'Carnét de Extranjería') {
                    $idtype = 2;
                }
                $item->identificationtype_id = $idtype;


                $item->nroidenti = $dato[1];
                $item->nombres = $dato[2];

                $item->apellido_pa = $dato[3];
                $item->apellido_ma = $dato[4];
                // Convertir el número de Excel a una fecha legible con Carbon
                $baseDate = Carbon::createFromDate(1900, 1, 1);
                $date = $baseDate->addDays($dato[5] - 2); // Restamos 2 días ya que Excel considera el 1 de enero de 1900 como el día 1

                // Formatear la fecha a tu preferencia antes de insertarla en la base de datos
                $item->fecnac = $date->toDateString();
                $item->correo = $dato[6];
                $item->tlf = $dato[7];
                $item->celular = $dato[8];
                $item->lugarnac = $dato[9];
                $item->direccion = $dato[10];
                $item->docdni = "";
                $item->doccertif = "";
                $item->docboucher = "";
                $item->docdatosper = "";
                $item->nota = $dato[11];

                // ESTADO
                if ($dato[11] == "" || $dato[11] == "0.00" || $dato[11] == "undefined") {
                    $nroestado = "5";    // inscripcion aprobada
                } else {
                    $nroestado = "7";    // nota ingresada
                }
                $item->estado = $nroestado;

                // GENERO
                if ($dato[12] === 'Masculino') {
                    $idgenre = '1';
                } else if ($dato[12] === 'Femenino') {
                    $idgenre = '2';
                } else if ($dato[12] === 'Otros') {
                    $idgenre = '3';
                }

                $item->genre_id = $idgenre;

                $item->modalidad = $dato[13];
                $item->tipomod = $dato[14];
                $item->comentario = $dato[15];
                $item->estado_admision = $estado_admision;
                $item->ubigeo_id = "090101";


                $item->admissionplan_id = $idadmissionplan;
                // validar guardado
                if ($item->save()) {
                    $countApplicants++;
                }
            }
        }

        if (($countApplicants == count($datos))) {
            $result = ["status" => true, "mensaje" => 'Postulantes insertados correctamente: ' . $countApplicants];
        } else if (($countrepetido > 1)) {
            $result = ["status" => true, "mensaje" => 'Postulantes insertados: ' . $countApplicants . ' - Postulantes no insertados: ' . $countrepetido, "Repet" => $miArraynroidentiRepet];
        } else {
            $result = ["status" => false, "mensaje" => 'Error al cargar postulantes'];
        }
        return response()->json($result);

        // Comprobar si todos los datos se insertaron

    }


    public function destroyaplicants($id)
    {
        $item = Applicant::find($id);

        // validar existencia del registro
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        $ruta = $item->docdni;
        $file = storage_path('app/') . $ruta;
        if (File::exists($file)) {
            File::delete($file);
        }

        $ruta = $item->doccertif;
        $file = storage_path('app/') . $ruta;
        if (File::exists($file)) {
            File::delete($file);
        }

        $ruta = $item->docboucher;
        $file = storage_path('app/') . $ruta;
        if (File::exists($file)) {
            File::delete($file);
        }

        $ruta = $item->docdatosper;
        $file = storage_path('app/') . $ruta;
        if (File::exists($file)) {
            File::delete($file);
        }

        // validar eliminación
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }


    public function store(Request $request)
    {
        $rules = [
            'txt-docdni' => 'required|file|mimes:pdf,jpg,png|max:5000',
            'txt-doccertif' => 'required|file|mimes:pdf,jpg,png|max:5000',
            'txt-docboucher' => 'required|file|mimes:pdf,jpg,png|max:5000',
            'txt-docdatosper' => 'required|file|mimes:pdf,jpg,png|max:5000',
        ];

        $messages = [
            // archivo requerido
            'txt-docdni.required' => 'El archivo PDF, JPG o PNG es requerido.',
            'txt-doccertif.required' => 'El archivo PDF, JPG o PNG es requerido.',
            'txt-docboucher.required' => 'El archivo PDF, JPG o PNG es requerido.',
            'txt-docdatosper.required' => 'El archivo PDF, JPG o PNG es requerido.',
            // Agrega mensajes para otros archivos si es necesario

            // tipo de archivo
            'txt-docdni.mimes' => 'El DNI debe ser un PDF, JPG o PNG.',
            'txt-doccertif.mimes' => 'El Certificado de Estudios debe ser un PDF, JPG o PNG.',
            'txt-docboucher.mimes' => 'El Boucher debe ser un PDF, JPG o PNG.',
            'txt-docdatosper.mimes' => 'La partida de nacimiento debe ser un PDF, JPG o PNG.',

            // tamaño del archivo
            'txt-docdni.max' => 'El tamaño del DNI no debe superar los 5000 KB.',
            'txt-doccertif.max' => 'El tamaño del Certificado de Estudios no debe superar los 5000 KB.',
            'txt-docboucher.max' => 'El tamaño del Boucher no debe superar los 5000 KB.',
            'txt-docdatosper.max' => 'El tamaño de la partida de nacimiento no debe superar los 5000 KB.',
        ];

        $validator = Validator::make($request->all(), $rules, $messages);

        if ($validator->fails()) {
            return response()->json([
                "status" => 'validators', "mensaje" => $validator->errors(),
            ]);
        } else {
            $nroidenti = $request->input('txt_nroidenti');

            $user = Applicant::where('nroidenti', $nroidenti)->first(); // Buscar el usuario por su correo electrónico
    
            if ($user) {
                $result = ["status" => false, "mensaje" => 'Postulante ya esta registrado en Base de datos'];
            } else {
                $item = new Applicant();
                $item->identificationtype_id = $request->input('txt-identificationtype_aplicants');
                $item->nroidenti = $request->input('txt_nroidenti');
                $item->nombres = $request->input('txt_nombres');
    
                $item->apellido_pa = $request->input('txt_apellido_pa');
                $item->apellido_ma = $request->input('txt_apellido_ma');
    
                $item->fecnac = $request->input('txt_fecnac');
                $item->correo = $request->input('txt_correo');
                $item->tlf = $request->input('txt_telefono');
                $item->celular = $request->input('txt_celular');
                $item->lugarnac = $request->input('txt_lugar_nac');
                $item->direccion = $request->input('txt_direccion');
                $item->docdni = "";
                $item->doccertif = "";
                $item->docboucher = "";
                $item->docdatosper = "";
                $item->nota = $request->input('txt_nota');
                
                // ESTADO
                if ($request->input('txt_nota') == "" || $request->input('txt_nota') == "0.00" || $request->input('txt_nota') == "undefined") {
                    $nroestado = "5";    // inscripcion aprobada
                } else {
                    $nroestado = "7";    // nota ingresada
                }
                $item->estado = $nroestado;
                $item->genre_id = $request->input('txt_genre_id');
                $item->modalidad = $request->input('txt_modalidad_aplicants');
                $item->tipomod = $request->input('txt_tipomodalidad');
                $item->comentario = $request->input('txt_comentario');
                $item->estado_admision = "1";
                $idubigeo = $request->input('txt_departamento') . $request->input('txt_provincia') . $request->input('txt_distrito');
                $item->ubigeo_id = $idubigeo;
                
                
                $item->admissionplan_id = $request->input('txt-idaddmisionplans');;
                // validar guardado
                // validar guardado
                if ($item->save()) {

                    // last insert id applicant
                    $lastInsertIdApplicant = $item->id;  // recoger id insertado

                    $folderName = $lastInsertIdApplicant;
                    Storage::disk('local')->makeDirectory('public/applicants/' . $folderName);   // creamos la carpeta en el disco local

                    // guardar dni
                    $archivo = $request->file('txt-docdni');   // obtenemos el archivo
                    $extension = $archivo->getClientOriginalExtension();
                    $archivo_nombre = 'dni.' . $extension;

                    $archivo->storeAs('public/applicants/' . $folderName, $archivo_nombre);  // guardado (ruta,nombre del archivo)
                    $filePath = 'public/applicants/' . $folderName . '/' . $archivo_nombre;  // ruta del archivo
                    $item->docdni = $filePath;

                    // guardar certif
                    $archivo = $request->file('txt-doccertif');   // obtenemos el archivo
                    $extension = $archivo->getClientOriginalExtension();
                    $archivo_nombre = 'certificado_estudios.' . $extension;

                    $archivo->storeAs('public/applicants/' . $folderName, $archivo_nombre);  // guardado (ruta,nombre del archivo)
                    $filePath = 'public/applicants/' . $folderName . '/' . $archivo_nombre;  // ruta del archivo
                    $item->doccertif = $filePath;

                    // guardar boucher
                    $archivo = $request->file('txt-docboucher');   // obtenemos el archivo
                    $extension = $archivo->getClientOriginalExtension();
                    $archivo_nombre = 'boucher.' . $extension;

                    $archivo->storeAs('public/applicants/' . $folderName, $archivo_nombre);  // guardado (ruta,nombre del archivo)
                    $filePath = 'public/applicants/' . $folderName . '/' . $archivo_nombre;  // ruta del archivo
                    $item->docboucher = $filePath;

                    // guardar datosper
                    $archivo = $request->file('txt-docdatosper');   // obtenemos el archivo
                    $archivo->storeAs('public/applicants/' . $folderName, 'datos_personales.pdf');  // guardado (ruta,nombre del archivo)
                    $filePath = 'public/applicants/' . $folderName . '/' . 'datos_personales.pdf';  // ruta del archivo
                    $item->docdatosper = $filePath;

                    if ($item->save()) {
                        $result = ["status" => true, "mensaje" => 'Postulante registrado correctamente'];
                    } else {
                        $result = ["status" => false, "mensaje" => 'Error al registrar postulante'];
                    }
                } else {
                    $result = ["status" => false, "mensaje" => 'Error al registrar postulante'];
                }
            }
            
            return response()->json($result);
        }
        
    }


    public function updateNota(Request $request, $id)
    {
        $item = Applicant::find($id);

        // validar existencia del registro
        if (!$item) {
            abort(404);
        } else {
            // recoger datos
            $item->estado = '7';
            $item->nota = $request->input('txt-nota');
            // validar guardado
            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function liststapplicants(Request $request)
    {
        if ($request->ajax()) {

            $idplan = $request->input('idplan');

            $postulantes = DB::table('postulantes AS a')
            ->select(
                'a.id AS ranked_id',
                'a.id AS idapplicant',
                'a.id',
                DB::raw("CONCAT(it.tipo, ' - ', a.nroidenti) AS identificacion"),
                'it.id AS ididentificationtype',
                'it.tipo AS tipoidenti',
                'a.nroidenti',
                'a.nombres',
                'a.apellido_ma',
                'a.apellido_pa',
                DB::raw("CONCAT(a.apellido_pa, ' ', a.apellido_ma, ', ', a.nombres) AS postulante"),
                'a.fecnac',
                'a.correo',
                'a.tlf',
                'a.celular',
                'a.lugarnac',
                'a.direccion',
                DB::raw("COALESCE(a.nota, '--') AS nota"),
                'a.comentario',
                'a.modalidad',
                'a.tipomod',
                'a.estado_admision',
                'a.docdni',
                'a.doccertif',
                'a.docboucher',
                'a.docdatosper',
                'g.id AS idgenre',
                'g.nombre AS genero',
                'ubi.id AS idubigeo',
                'a.estado',
                DB::raw("CASE
                            WHEN a.nota >= 12.5 AND 
                                (RANK() OVER (PARTITION BY a.modalidad ORDER BY a.nota DESC, a.created_at ASC)) <= 
                                CASE
                                    WHEN a.modalidad = 'ordinario' THEN ap.vacantes_ordinario
                                    WHEN a.modalidad = 'exonerado' THEN ap.vacantes_exoneracion
                                END THEN 'Admitido'
                            ELSE 'No Admitido'
                        END AS estado_postulante")
            )
            ->join('tipos_identificaciones AS it', 'it.id', '=', 'a.identificationtype_id')
            ->join('generos AS g', 'g.id', '=', 'a.genre_id')
            ->join('ubigeos AS ubi', 'ubi.id', '=', 'a.ubigeo_id')
            ->join('admisiones_planes AS ap', 'ap.id', '=', 'a.admissionplan_id')
            ->join('planes AS p', 'p.id', '=', 'ap.plan_id')
            ->where('p.id', $idplan)
            ->where(function ($query) {
                $query->where(function ($query) {
                    $query->where('a.modalidad', 'ordinario')
                        ->where('ap.vacantes_ordinario', '>', 0);
                })->orWhere(function ($query) {
                    $query->where('a.modalidad', 'exonerado')
                        ->where('ap.vacantes_exoneracion', '>', 0);
                });
            })
            ->orderBy('a.modalidad')
            ->orderByDesc('a.nota')
            ->get();
            

            // datatable
            return DataTables::of($postulantes)
                ->addIndexColumn()
                ->make(true);
        }

        return response()->json(["status" => false, "mensaje" => 'Error: no se pueden cargar los archivos']);
    }


    public function transformApplicantToStudent(Request $request)
    {
        $data = json_decode($request->getContent(), true);

        $user = User::where('nroidenti', $data['nroidenti'])->first(); // Buscar el usuario por su correo electrónico

        if ($user) {
            return response()->json(["status" => false, "mensaje" => 'Postulante ya registrado como estudiante']);
        } else {
            $item = new User();

            $item->identificationtype_id = $data['identificationtype_id'];
            $item->nroidenti = $data['nroidenti'];
            $item->password = $data['nroidenti'];

            $item->nombres = $data['nombres'];
            $item->apellido_ma = $data['apellido_ma'];
            $item->apellido_pa = $data['apellido_pa'];

            if ($data['fecnac'] != '0000-00-00') {
                $item->fecnac = $data['fecnac'];
            }

            $item->telefono = $data['tlf'];
            $item->correo = $data['correo'];
            $item->celular = $data['celular'];
            $item->direccion = $data['direccion'];
            $item->estado = 1;


            $item->ubigeo_id = $data['idubigeo'];
            $item->genre_id = $data['idgenre'];
            $item->usertype_id = 3;

            // validar guardado
            if ($item->save()) {
                //recoger id insertado
                $newUserId = $item->id;
                // nuevo objeto
                $item2 = new Student();

                // recoger datos
                $item2->plan_id = $data['idplan'];
                $item2->estado = '1';
                $item2->anho_ingreso = $data['anho'];
                $item2->user_id = $newUserId;
                // validar guardado
                if ($item2->save()) {
                    $item3 = Applicant::find($data['idapplicant']);
                    $item3->estado = '9';
                    $item3->save();


                    return response()->json(["status" => true, "mensaje" => 'Postulante -> Estudiante']);
                } else {
                    return response()->json(["status" => false, "mensaje" => 'Registro no modificado']);
                }
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
            }
        }
    }


    public function open_store(Request $request)
    {

        $rules = [
            'txt-docdni' => 'required|file|mimes:pdf,jpg,png|max:5000',
            'txt-doccertif' => 'required|file|mimes:pdf,jpg,png|max:5000',
            'txt-docboucher' => 'required|file|mimes:pdf,jpg,png|max:5000',
            'txt-docdatosper' => 'required|file|mimes:pdf,jpg,png|max:5000',
        ];

        $messages = [
            // archivo requerido
            'txt-docdni.required' => 'El archivo PDF, JPG o PNG es requerido.',
            'txt-doccertif.required' => 'El archivo PDF, JPG o PNG es requerido.',
            'txt-docboucher.required' => 'El archivo PDF, JPG o PNG es requerido.',
            'txt-docdatosper.required' => 'El archivo PDF, JPG o PNG es requerido.',
            // Agrega mensajes para otros archivos si es necesario

            // tipo de archivo
            'txt-docdni.mimes' => 'El DNI debe ser un PDF, JPG o PNG.',
            'txt-doccertif.mimes' => 'El Certificado de Estudios debe ser un PDF, JPG o PNG.',
            'txt-docboucher.mimes' => 'El Boucher debe ser un PDF, JPG o PNG.',
            'txt-docdatosper.mimes' => 'La partida de nacimiento debe ser un PDF, JPG o PNG.',

            // tamaño del archivo
            'txt-docdni.max' => 'El tamaño del DNI no debe superar los 5000 KB.',
            'txt-doccertif.max' => 'El tamaño del Certificado de Estudios no debe superar los 5000 KB.',
            'txt-docboucher.max' => 'El tamaño del Boucher no debe superar los 5000 KB.',
            'txt-docdatosper.max' => 'El tamaño de la partida de nacimiento no debe superar los 5000 KB.',

        ];

        $validator = Validator::make($request->all(), $rules, $messages);

        if ($validator->fails()) {
            return response()->json([
                "status" => 'validators', "mensaje" => $validator->errors(),
            ]);
        } else {

            // recoger id admission plan
            $idadmissionplan = $request->input('txt-idadmissionplan');

            // obtener id admission
            $admission = DB::table('admisiones as ad')
                ->join('admisiones_planes as adpl', 'ad.id', '=', 'adpl.admission_id')
                ->select('ad.id as idadmission')
                ->where('adpl.id', '=', $idadmissionplan)
                ->first();

            $idadmission = $admission->idadmission;

            // return  response()->json(["status" => false, "mensaje" => 'TEST: ' . $idadmission]);


            // obtener numero de identificacion
            $nroidenti = $request->input('txt-nroidenti');

            // verificar si el postulante ya está registrado en el proceso de admisión
            $applicantadmission = DB::table('postulantes as po')
                ->join('admisiones_planes as adpl', 'po.admissionplan_id', '=', 'adpl.id')
                ->join('admisiones as ad', 'adpl.admission_id', '=', 'ad.id')
                ->select('po.id as idapplicant', 'adpl.id as idadmissionplan', 'ad.id as idadmission')
                ->where('po.nroidenti', '=', $nroidenti)
                ->where('ad.id', '=', $idadmission)
                ->first();

            if ($applicantadmission) {

                return  response()->json(["status" => false, "mensaje" => 'Error: El postulante ya se ha registrado al proceso de admisión']);
            } else {
                $item = new Applicant();
                $item->identificationtype_id = $request->input('txt-identificationtype_aplicants');
                $item->nroidenti = $request->input('txt-nroidenti');
                $item->nombres = $request->input('txt-nombres');

                $item->apellido_pa = $request->input('txt-apellido_pa');
                $item->apellido_ma = $request->input('txt-apellido_ma');

                $item->fecnac = $request->input('txt-fecnac');
                $item->correo = $request->input('txt-correo');
                $item->tlf = $request->input('txt-telefono');
                $item->celular = $request->input('txt-celular');
                $item->lugarnac = $request->input('txt-lugar_nac');
                $item->direccion = $request->input('txt-direccion');
                $item->docdni = '';
                $item->doccertif = '';
                $item->docboucher = '';
                $item->docdatosper = '';
                $idubigeo = $request->input('txt-departamento') . $request->input('txt-provincia') . $request->input('txt-distrito');
                $item->ubigeo_id = $idubigeo;

                // estado postulación
                $nroestado = "4";  // inscripcion (documentos)
                $item->estado = $nroestado;
                $item->genre_id = $request->input('txt-genre_id');
                $item->modalidad = $request->input('txt-modalidad_aplicants');
                $item->tipomod = $request->input('txt-tipomodalidad');
                $item->comentario = '';
                // estado admision debe ser dinamico
                $item->estado_admision = "1";

                // idadmissionplan
                $item->admissionplan_id = $request->input('txt-idadmissionplan');


                // validar guardado
                if ($item->save()) {

                    // last insert id applicant
                    $lastInsertIdApplicant = $item->id;  // recoger id insertado

                    $folderName = $lastInsertIdApplicant;
                    Storage::disk('local')->makeDirectory('public/applicants/' . $folderName);   // creamos la carpeta en el disco local

                    // guardar dni
                    $archivo = $request->file('txt-docdni');   // obtenemos el archivo
                    $extension = $archivo->getClientOriginalExtension();
                    $archivo_nombre = 'dni.' . $extension;

                    $archivo->storeAs('public/applicants/' . $folderName, $archivo_nombre);  // guardado (ruta,nombre del archivo)
                    $filePath = 'public/applicants/' . $folderName . '/' . $archivo_nombre;  // ruta del archivo
                    $item->docdni = $filePath;

                    // guardar certif
                    $archivo = $request->file('txt-doccertif');   // obtenemos el archivo
                    $extension = $archivo->getClientOriginalExtension();
                    $archivo_nombre = 'certificado_estudios.' . $extension;

                    $archivo->storeAs('public/applicants/' . $folderName, $archivo_nombre);  // guardado (ruta,nombre del archivo)
                    $filePath = 'public/applicants/' . $folderName . '/' . $archivo_nombre;  // ruta del archivo
                    $item->doccertif = $filePath;

                    // guardar boucher
                    $archivo = $request->file('txt-docboucher');   // obtenemos el archivo
                    $extension = $archivo->getClientOriginalExtension();
                    $archivo_nombre = 'boucher.' . $extension;

                    $archivo->storeAs('public/applicants/' . $folderName, $archivo_nombre);  // guardado (ruta,nombre del archivo)
                    $filePath = 'public/applicants/' . $folderName . '/' . $archivo_nombre;  // ruta del archivo
                    $item->docboucher = $filePath;

                    // guardar datosper
                    $archivo = $request->file('txt-docdatosper');   // obtenemos el archivo
                    $archivo->storeAs('public/applicants/' . $folderName, 'datos_personales.pdf');  // guardado (ruta,nombre del archivo)
                    $filePath = 'public/applicants/' . $folderName . '/' . 'datos_personales.pdf';  // ruta del archivo
                    $item->docdatosper = $filePath;

                    if ($item->save()) {
                        $result = ["status" => true, "mensaje" => 'Postulante registrado correctamente'];
                    } else {
                        $result = ["status" => false, "mensaje" => 'Error al registrar postulante'];
                    }
                } else {
                    $result = ["status" => false, "mensaje" => 'Error al registrar postulante'];
                }
            }

            return response()->json($result);
        }
    }


    public function aprobarInscripcion(Request $request, $idapplicant)
    {
        $item = Applicant::find($idapplicant);
        $item->estado = '5'; // inscripcion aprobada
        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Inscripción aprobada correctamente']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Error al actualizar']);
        }
    }

    public function rechazarInscripcion(Request $request, $idapplicant)
    {
        $item = Applicant::find($idapplicant);
        $item->estado = '6'; // inscripcion aprobada
        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Inscripción desaprobada correctamente']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Error al actualizar']);
        }
    }
}
