<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\header\HeaderController;
use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Plan;
use App\Models\Planequivalence;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;

class PlanequivalenceController extends Controller
{
    //
    public function index(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();

        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            $idusertype = Auth::User()->usertype_id;

            if ($userTypeAccesocombo == "1" && ($idusertype == "1" || $idusertype == "4" || $idusertype == "5" || $idusertype == "7")) {
                $objetoarea = new HeaderController();
                $dataarea = $objetoarea->DataAreaAdm();
                $tipoacceso = 1;
                $dataAreaNombre = $dataarea[0]['NOMBRE'];;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.planes_estudio.equivalencias.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar)->with('dataarea', $dataAreaNombre);
            } else if ($userTypeAccesocombo == "2") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            } else if ($userTypeAccesocombo == "3") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }

    public function list(Request $request)
    {
        if ($request->ajax()) {
            // query
            $data = DB::table('equivalencias_planes as pleq')
                ->select(
                    'pleq.id as idplanequivalence',
                    'pleq.plan_id1',
                    'pleq.plan_id2',
                    'pleq.documento',
                    'pr.id as idprogram',
                    'pr.codprograma',
                    'pr.nombre as nombreprograma',
                    'pr.nivel_formativo',
                    'pl1.id as idplan1',
                    'pl1.nombre as nombreplan1',
                    'pl1.tipo as tipoplan1',
                    'pl1.modalidad as modalidadplan1',
                    'pl1.enfoque as enfoqueplan1',
                    'pl2.id as idplan2',
                    'pl2.nombre as nombreplan2',
                    'pl2.tipo as tipoplan2',
                    'pl2.modalidad as modalidadplan2',
                    'pl2.enfoque as enfoqueplan2'
                )
                ->join('planes as pl1', 'pleq.plan_id1', '=', 'pl1.id')
                ->join('planes as pl2', 'pleq.plan_id2', '=', 'pl2.id')
                ->join('programas as pr', 'pl1.program_id', '=', 'pr.id')
                ->get();
            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json(["status" => false, "mensaje" => 'Error: no se pueden cargar los archivos']);
    }


    public function store(Request $request)
    {
        $idprogram = $request->input('txt-programs');

        $item = new Planequivalence();
        $item->plan_id1 = $request->input('txt-plans1');
        $item->plan_id2 = $request->input('txt-plans2');
        $item->documento = "--";

        if ($item->save()) {
            $lastInsertIdplanequivalence = $item->id;  // recoger id insertado
            // guardar documento si existe
            if ($request->hasFile('txt-document')) {
                // validar documento
                $validator = Validator::make($request->all(), [
                    'txt-document' => 'required|file|mimes:pdf|max:500', // Valida PDF y tamaño máximo de 2MB
                ], [
                    'txt-document.file' => 'El archivo PDF es requerido.',
                    'txt-document.mimes' => 'El archivo debe ser un PDF.',
                    'txt-document.max' => 'El tamaño del archivo no debe superar los 500 KB.',
                ]);
                // documento inválido
                if ($validator->fails()) {
                    return response()->json([
                        "status" => false,
                        "mensaje" => $validator->errors()->first(),
                    ]);
                }
                // documento válido
                else {
                    $folderName = $idprogram . '/' . 'equivalencias';
                    Storage::disk('local')->makeDirectory('public/programs/' . $folderName);   // creamos la carpeta en el disco local
                    $archivo = $request->file('txt-document');   // obtenemos el archivo
                    $archivo->storeAs('public/programs/' . $folderName, $lastInsertIdplanequivalence . '.pdf');  // guardado (ruta,nombre del archivo)
                    $filePath = 'public/programs/' . $folderName . '/' . $lastInsertIdplanequivalence . '.pdf';  // ruta del archivo
                    $item->documento = $filePath;
                    // guardar
                    if ($item->save()) {
                        return response()->json(["status" => true, "mensaje" => 'Registro insertado con documento']);
                    } else {
                        return response()->json(["status" => false, "mensaje" => 'Ruta no insertada correctamente']);
                    }
                }
            }
            return response()->json(["status" => true, "mensaje" => 'Registro insertado sin documento']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
        }
    }


    public function update(Request $request, $idplanequivalence)
    {

        $item = Planequivalence::find($idplanequivalence);

        // validar existencia del registro
        if (!$item) {
            abort(404);
        } else {
            // recoger datos
            $idplan = $item->plan_id1;
            $item2 = Plan::find($idplan);
            $idprogram = $item2->program_id;
            // guardar documento si existe
            if ($request->hasFile('txt-document')) {
                // Validador
                $validator = Validator::make($request->all(), [
                    'txt-document' => 'required|file|mimes:pdf|max:500', // Valida PDF y tamaño máximo de 2MB
                ], [
                    'txt-document.file' => 'El archivo PDF es requerido.',
                    'txt-document.mimes' => 'El archivo debe ser un PDF.',
                    'txt-document.max' => 'El tamaño del archivo no debe superar los 500 KB.',
                ]);

                if ($validator->fails()) {
                    return response()->json([
                        "status" => false,
                        "mensaje" => $validator->errors()->first(),
                    ]);
                } else {
                    $folderName = $idprogram . '/' . 'equivalencias';
                    Storage::disk('local')->makeDirectory('programs/' . $folderName);   // creamos la carpeta en el disco local
                    $archivo = $request->file('txt-document');   // obtenemos el archivo
                    $archivo->storeAs('programs/' . $folderName, $idplanequivalence . '.pdf');  // guardado (ruta,nombre del archivo)
                    $filePath = 'programs/' . $folderName . '/' . $idplanequivalence . '.pdf';  // ruta del archivo
                    $item->documento = $filePath;
                    // guardar
                    if ($item->save()) {
                        return response()->json(["status" => true, "mensaje" => 'Registro insertado con documento']);
                    } else {
                        return response()->json(["status" => false, "mensaje" => 'Ruta no insertada correctamente']);
                    }
                }
            }
            // validar guardado
            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function destroy($idplanequivalence)
    {
        // Busca el registro por su id
        $item = Planequivalence::find($idplanequivalence);

        // recuperar data
        $ruta = $item->documento;

        // Verifica si el registro existe
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }


        // Verifica si hay relaciones antes de intentar eliminar
        if ($item->courseequivalences()->exists()) {
            return response()->json(["status" => false, "mensaje" => 'Existen registros de cursos equivalentes']);
        }


        // $file = storage_path('app/programs/' . $idstudent . '/equivalencias/') . $idplanequivalence . '.pdf';
        $file = storage_path('app/') . $ruta;
        if (File::exists($file)) {
            File::delete($file);
        }

        // Elimina el registro de la base de datos
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }


    public function ajax_all_by_idprogram(Request $request, $idprogram)
    {
        if ($request->ajax()) {

            $data = DB::table('equivalencias_planes as pe')
                ->select(
                    'pe.id as idplanequivalence',
                    'pe.documento',
                    'pl1.id as idplan1',
                    'pl1.nombre as nombreplan1',
                    'pl1.tipo as tipoplan1',
                    'pl1.modalidad as modalidadplan1',
                    'pl1.enfoque as enfoqueplan1',
                    'pl2.id as idplan2',
                    'pl2.nombre as nombreplan2',
                    'pl2.tipo as tipoplan2',
                    'pl2.modalidad as modalidadplan2',
                    'pl2.enfoque as enfoqueplan2',
                    'pr.id as idprogram',
                    'pr.codprograma',
                    'pr.nombre as nombreprograma1',
                    'pr.nivel_formativo'
                )
                ->join('planes as pl1', 'pe.plan_id1', '=', 'pl1.id')
                ->join('planes as pl2', 'pe.plan_id2', '=', 'pl2.id')
                ->join('programas as pr', 'pl1.program_id', '=', 'pr.id')
                ->where('pr.id', $idprogram)
                ->get();
            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }
}
