<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Period;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;

class PeriodController extends Controller
{


    public function ajax_all_by_idplan(Request $request, $idsemester, $idplan)
    {
        if ($request->ajax()) {
            // $data = Period::all();
            $data = DB::table('periodos')
            ->select('periodos.id', 'periodos.numero', 'periodos.plan_id')
            ->join('periodos_semestres', 'periodos_semestres.period_id', '=', 'periodos.id')
            ->where('periodos.plan_id', '=', $idplan)
            ->where('periodos_semestres.semester_id', '=', $idsemester)
            ->get();
            
            // Period::where('plan_id', $idplan)
            //     ->orderBy('numero', 'asc')
            //     ->get();

            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }

    public function store(Request $request, $id)
    {
        $nivel_formativo = $request->input('nivel_formativo');
        $nuevosIDs = []; // Array para almacenar los IDs generados


        // PLAN TIPO TRANSVERSAL
        if ($request->input('cb_tipoplan_name') === "Transversal") {
            // Nivel Formatio Profesional Técnico
            if ($nivel_formativo === "Profesional Técnico") {
                for ($i = 1; $i <= 6; $i++) {
                    $periodo = new Period();
                    $periodo->numero = $i;
                    $periodo->plan_id = $id;
                    $periodo->save();
                    // Almacena los IDs generados en el array
                    $nuevosIDs[] = $periodo->id;
                }
            }
            // Nivel Formativo Técnico
            else {
                for ($i = 1; $i <= 4; $i++) {
                    $periodo = new Period();
                    $periodo->numero = $i;
                    $periodo->plan_id = $id;
                    $periodo->save();
                    // Almacena los IDs generados en el array
                    $nuevosIDs[] = $periodo->id;
                }
            }
            // SI SE INSERTARON LOS PERIODOS
            if (count($nuevosIDs) > 0) {
                // Devuelve los IDs generados como respuesta JSON
                return response()->json([
                    "status" => true,
                    "mensaje" => "Periodos guardados",
                    "nuevosIDs" => $nuevosIDs // Envía los IDs generados
                ]);
            }
            // SI NO SE INSERTARON LOS PERIODOS
            else {
                return response()->json([
                    "status" => false,
                    "mensaje" => "Periodos no guardados"
                ]);
            }
        }



        // PLAN TIPO MODULAR
        else {
            // Nivel Formativo Profesional Técnico
            if ($nivel_formativo === "Profesional Técnico") {
                for ($i = 1; $i <= 6; $i++) {
                    $periodo = new Period();
                    $periodo->numero = $i;
                    $periodo->plan_id = $id;
                    $periodo->save();

                    // Almacena los IDs generados en el array
                    $nuevosIDs[] = $periodo->id;
                }
            }
            // Nivel Formativo Técnico
            else {
                for ($i = 1; $i <= 4; $i++) {
                    $periodo = new Period();
                    $periodo->numero = $i;
                    $periodo->plan_id = $id;
                    $periodo->save();

                    // Almacena los IDs generados en el array
                    $nuevosIDs[] = $periodo->id;
                }
            }
            // SI SE INSERTARON LOS PERIODOS
            if (count($nuevosIDs) > 0) {
                // Devuelve los IDs generados como respuesta JSON
                return response()->json([
                    "status" => true,
                    "mensaje" => 'Periodos guardados',

                    "nuevosIDs" => $nuevosIDs // Envía los IDs generados
                ]);
            }
            // SI NO SE INSERTARON LOS PERIODOS
            else {
                return response()->json([
                    "status" => false,
                    "mensaje" => 'Periodos no guardados'
                ]);
            }
        }
    }
}
