<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\header\HeaderController;
use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Grade;
use Illuminate\Http\Request;
use App\Models\Course;
use App\Models\Studentgrade;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;

class GradeController extends Controller
{
    //
    public function store(Request $request)
    {
        $item = new Grade();
        $item->nombre = $request->input('txt-g_nombre');
        $item->porcentaje = $request->input('txt-g_porcentaje');
        $item->activity_id = $request->input('txt-g_idactivity');
        
        // Guarda el nuevo registro en la base de datos
        if ($item->save()) {
            // El guardado fue exitoso
            return response()->json([
                "status" => true,
                "mensaje" => 'Grade guardado'
            ]);
        } else {
            // El guardado falló
            return response()->json([
                "status" => false,
                "mensaje" => 'Grade no guardado'
            ]);
        }
    }

    public function update(Request $request, $id)
    {
        $item = Grade::find($id);

        if (!$item) {
            abort(404); // Manejo de error si no se encuentra el registro
        } else {

            $item->nombre = $request->input('txt-g_nombre');
            $item->porcentaje = $request->input('txt-g_porcentaje');

            if ($item->save()) {
                // El guardado fue exitoso
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                // El guardado falló
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function destroy($id)
    {
        // Busca el registro por su ID
        $item = Grade::find($id);

        $notas_estudiantes = Studentgrade::where('grade_id', $id);
        $notas_estudiantes->delete();

        // Verifica si el registro existe
        if (!$item) {
            return response()->json([
                "status" => false,
                "mensaje" => 'El registro no existe'
            ]);
        }

        // Elimina el registro de la base de datos
        if ($item->delete()) {
            return response()->json([
                "status" => true,
                "mensaje" => 'El registro fue eliminado'
            ]);
        } else {
            return response()->json([
                "status" => false,
                "mensaje" => 'No se puede eliminar porque ya cuenta con registros asociados'
            ]);
        }
    }

}
