<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\header\HeaderController;
use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Courseequivalence;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;

class CourseequivalenceController extends Controller
{

    public function list_by_idplanequivalence(Request $request)
    {
        $idplanequivalence = $request->input('idplanequivalence');
        if ($request->ajax()) {
            // query
            $data = DB::table('equivalencias_cursos as coeq')
                ->select(
                    'coeq.id as idcourseequivalence',
                    'coeq.documento',
                    'coeq.planequivalence_id as idplanequivalence',
                    'co1.id as idcourse1',
                    'co1.tipo as tipocurso1',
                    'co1.codcurso as codcurso1',
                    'co1.nombre as nombrecurso1',
                    'co1.codpredecesor as codpredecesorcurso1',
                    'co1.horas as horascurso1',
                    'co1.creditos as creditoscurso1',
                    'pe1.id as idperiod1',
                    'pe1.numero as numeroperiodo1',
                    'co2.id as idcourse2',
                    'co2.tipo as tipocurso2',
                    'co2.codcurso as codcurso2',
                    'co2.nombre as nombrecurso2',
                    'co2.codpredecesor as codpredecesorcurso2',
                    'co2.horas as horascurso2',
                    'co2.creditos as creditoscurso2',
                    'pe2.id as idperiod2',
                    'pe2.numero as numeroperiodo2'
                )
                ->join('cursos as co1', 'coeq.course_id1', '=', 'co1.id')
                ->join('periodos as pe1', 'co1.period_id', '=', 'pe1.id')
                ->join('cursos as co2', 'coeq.course_id2', '=', 'co2.id')
                ->join('periodos as pe2', 'co2.period_id', '=', 'pe2.id')
                ->where('coeq.planequivalence_id', $idplanequivalence)
                ->get();
            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json(["status" => false, "mensaje" => 'Error: no se pueden cargar los archivos']);
    }

    public function store(Request $request)
    {

        $idplanequivalence = $request->input('txt-idplanequivalence2');
        $idcourse1 = $request->input('txt-course1');
        $idcourse2 = $request->input('txt-course2');

        $existingEquivalence = Courseequivalence::where('course_id1', $idcourse1)
            ->where('course_id2', $idcourse2)
            ->first();

        if ($existingEquivalence) {
            return response()->json(["status" => false, "mensaje" => 'Ya existe una equivalencia para los cursos seleccionados']);
        }

        $item = new Courseequivalence();
        $item->course_id1 = $idcourse1;
        $item->course_id2 = $idcourse2;
        $item->planequivalence_id = $idplanequivalence;
        $item->documento = '--';

        // validar guardado
        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
        }
    }


    public function destroy($idcourseequivalence)
    {
        // Busca el registro por su id
        $item = Courseequivalence::find($idcourseequivalence);

        // Verifica si el registro existe
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        // Elimina el registro de la base de datos
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }


    public function ajax_all_by_idplanequivalence_for_student(Request $request, $idplanequivalence, $idstudent)
    {
        if ($request->ajax()) {

            $data = DB::table('equivalencias_cursos as coeq')
                ->select(
                    'coeq.id as idcourseequivalence',
                    'coeq.documento as documentocourseequivalence',
                    'co1.id as idcourse1',
                    'co1.tipo as tipocurso1',
                    'co1.codcurso as codcurso1',
                    'co1.nombre as nombrecurso1',
                    'co1.codpredecesor as codpredecesorcurso1',
                    'co1.horas as horascurso1',
                    'co1.creditos as creditoscurso1',
                    'pe1.id as idperiod1',
                    'pe1.numero as numeroperiodo1',
                    'co2.id as idcourse2',
                    'co2.tipo as tipocurso2',
                    'co2.codcurso as codcurso2',
                    'co2.nombre as nombrecurso2',
                    'co2.codpredecesor as codpredecesorcurso2',
                    'co2.horas as horascurso2',
                    'co2.creditos as creditoscurso2',
                    'pe2.id as idperiod2',
                    'pe2.numero as numeroperiodo2',
                    'stva.id as idstudentvalidation',
                    'stva.fecha'
                )
                ->join('cursos as co1', 'coeq.course_id1', '=', 'co1.id')
                ->join('periodos as pe1', 'co1.period_id', '=', 'pe1.id')
                ->join('cursos as co2', 'coeq.course_id2', '=', 'co2.id')
                ->join('periodos as pe2', 'co2.period_id', '=', 'pe2.id')
                ->leftJoin('convalidaciones_estudiantes as stva', function ($join) use ($idstudent) {
                    $join->on('stva.courseequivalence_id', '=', 'coeq.id')
                        ->where('stva.student_id', '=', $idstudent);
                })
                ->where('coeq.planequivalence_id', '=', $idplanequivalence)
                ->whereNull('stva.id')
                ->get();
            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }
}
