<!DOCTYPE html>
<html lang="es">

<head>

    <?php echo $__env->make('include.meta-favicon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.plugins-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Page Title Here -->
    <title>Ofertas Laborales</title>

    <?php echo $__env->make('include.datatable-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="<?php echo e(asset('/css/style.css')); ?>" rel="stylesheet">
    

</head>

<body>

    <?php echo $__env->make('include.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        

        
        <nav class="navbar navbar-expand p-4">
            <div class="collapse navbar-collapse justify-content-between">
                <div class="header-left">
                    <h3>Ofertas Laborales</h3>
                </div>
                <ul class="navbar-nav header-right">
                    <!-- Dark Mode -->
                    <li class="nav-item dropdown notification_dropdown">
                        <a class="nav-link bell dz-theme-mode" href="javascript:void(0);">
                            <svg id="icon-light" xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1"
                                stroke-linecap="round" stroke-linejoin="round" class="feather feather-sun">
                                <circle cx="12" cy="12" r="5"></circle>
                                <line x1="12" y1="1" x2="12" y2="3"></line>
                                <line x1="12" y1="21" x2="12" y2="23"></line>
                                <line x1="4.22" y1="4.22" x2="5.64" y2="5.64"></line>
                                <line x1="18.36" y1="18.36" x2="19.78" y2="19.78"></line>
                                <line x1="1" y1="12" x2="3" y2="12"></line>
                                <line x1="21" y1="12" x2="23" y2="12"></line>
                                <line x1="4.22" y1="19.78" x2="5.64" y2="18.36"></line>
                                <line x1="18.36" y1="5.64" x2="19.78" y2="4.22"></line>
                            </svg>
                            <svg id="icon-dark" xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1"
                                stroke-linecap="round" stroke-linejoin="round" class="feather feather-moon">
                                <path d="M21 12.79A9 9 0 1 1 11.21 3 7 7 0 0 0 21 12.79z"></path>
                            </svg>
                        </a>
                    </li>
                    <!-- Full Screen -->
                    <li class="nav-item dropdown notification_dropdown">
                        <a class="nav-link bell dz-fullscreen" href="javascript:void(0);">
                            <svg id="icon-full-1" viewBox="0 0 24 24" width="20" height="20"
                                stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round"
                                stroke-linejoin="round" class="css-i6dzq1">
                                <path
                                    d="M8 3H5a2 2 0 0 0-2 2v3m18 0V5a2 2 0 0 0-2-2h-3m0 18h3a2 2 0 0 0 2-2v-3M3 16v3a2 2 0 0 0 2 2h3"
                                    style="stroke-dasharray: 37, 57; stroke-dashoffset: 0;"></path>
                            </svg>
                            <svg id="icon-minimize-1" width="20" height="20" viewBox="0 0 24 24" fill="none"
                                stroke="A098AE" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                class="feather feather-minimize">
                                <path
                                    d="M8 3v3a2 2 0 0 1-2 2H3m18 0h-3a2 2 0 0 1-2-2V3m0 18v-3a2 2 0 0 1 2-2h3M3 16h3a2 2 0 0 1 2 2v3"
                                    style="stroke-dasharray: 37, 57; stroke-dashoffset: 0;"></path>
                            </svg>
                        </a>
                    </li>
                    <!-- Profile -->
                    <li class="nav-item">
                        <div class="dropdown header-profile2">
                            <a class="nav-link ms-0" href="javascript:void(0);" role="button" data-bs-toggle="dropdown"
                                aria-expanded="false">
                                <div class="header-info2 d-flex align-items-center">
                                    <div class="d-flex align-items-center sidebar-info">
                                    </div>
                                    
                                    <?php if(Auth::User()->genre_id == 1): ?>
                                        <img class="img_user" src="<?php echo e(asset('/images/avatar/male.jpg')); ?>"
                                            alt="">
                                    <?php elseif(Auth::User()->genre_id == 2): ?>
                                        <img class="img_user" src="<?php echo e(asset('/images/avatar/female.jpg')); ?>"
                                            alt="">
                                    <?php else: ?>
                                        <img class="img_user" src="<?php echo e(asset('/images/avatar/other.jpg')); ?>"
                                            alt="">
                                    <?php endif; ?>
                                </div>
                            </a>
                            <div class="dropdown-menu dropdown-menu-end pb-0" style="">
                                <div class="card mb-0">
                                    <div class="card-header p-3">
                                        <ul class="d-flex align-items-center">
                                            <li>
                                                <?php if(Auth::User()->genre_id == 1): ?>
                                                    <img src="<?php echo e(asset('/images/avatar/male.jpg')); ?>"
                                                        class="img_user ms-0" alt="">
                                                <?php elseif(Auth::User()->genre_id == 2): ?>
                                                    <img src="<?php echo e(asset('/images/avatar/female.jpg')); ?>"
                                                        class="img_user ms-0" alt="">
                                                <?php else: ?>
                                                    <img src="<?php echo e(asset('/images/avatar/other.jpg')); ?>"
                                                        class="img_user ms-0" alt="">
                                                <?php endif; ?>
                                            </li>
                                            <li class="ms-2">
                                                <h4 class="mb-0"><?php echo e(Auth::User()->nombres); ?></h4>
                                                <?php if(Auth::User()->usertype_id == 1): ?>
                                                    <span>Admin</span><br>
                                                    <span>Área: <?php echo e($dataarea); ?></span>
                                                <?php elseif(Auth::User()->usertype_id == 2): ?>
                                                    <span>Docente</span>
                                                <?php elseif(Auth::User()->usertype_id == 3): ?>
                                                    <span>Alumno</span>
                                                <?php endif; ?>
                                            </li>
                                        </ul>

                                    </div>
                                    <div class="card-body p-3">
                                        <?php if(
                                            $datatipoacceso == 1 &&
                                                (Auth::User()->usertype_id == 1 ||
                                                    Auth::User()->usertype_id == 4 ||
                                                    Auth::User()->usertype_id == 5 ||
                                                    Auth::User()->usertype_id == 7)): ?>
                                            <a href="<?php echo e(route('admin.profile')); ?>"
                                                class="dropdown-item ai-icon  btn btn-primary light">
                                            <?php elseif(
                                                $datatipoacceso == 2 &&
                                                    (Auth::User()->usertype_id == 2 ||
                                                        Auth::User()->usertype_id == 4 ||
                                                        Auth::User()->usertype_id == 6 ||
                                                        Auth::User()->usertype_id == 7)): ?>
                                                <a href="<?php echo e(route('teacher.profile')); ?>"
                                                    class="dropdown-item ai-icon  btn btn-primary light">
                                                <?php elseif(
                                                    $datatipoacceso == 3 &&
                                                        (Auth::User()->usertype_id == 3 ||
                                                            Auth::User()->usertype_id == 5 ||
                                                            Auth::User()->usertype_id == 6 ||
                                                            Auth::User()->usertype_id == 7)): ?>
                                                    <a href="<?php echo e(route('student.profile')); ?>"
                                                        class="dropdown-item ai-icon  btn btn-primary light">
                                        <?php endif; ?>
                                        <svg xmlns="http://www.w3.org/2000/svg"
                                            xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px"
                                            viewBox="0 0 24 24" version="1.1" class="svg-main-icon">
                                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                <polygon points="0 0 24 0 24 24 0 24" />
                                                <path
                                                    d="M12,11 C9.790861,11 8,9.209139 8,7 C8,4.790861 9.790861,3 12,3 C14.209139,3 16,4.790861 16,7 C16,9.209139 14.209139,11 12,11 Z"
                                                    fill="#000000" fill-rule="nonzero" opacity="0.3" />
                                                <path
                                                    d="M3.00065168,20.1992055 C3.38825852,15.4265159 7.26191235,13 11.9833413,13 C16.7712164,13 20.7048837,15.2931929 20.9979143,20.2 C21.0095879,20.3954741 20.9979143,21 20.2466999,21 C16.541124,21 11.0347247,21 3.72750223,21 C3.47671215,21 2.97953825,20.45918 3.00065168,20.1992055 Z"
                                                    fill="var(--primary)" fill-rule="nonzero" />
                                            </g>
                                        </svg>
                                        <span class="ms-2">Perfil </span>
                                        </a>
                                    </div>
                                    <div class="card-footer text-center p-3">
                                        <a href="javascript:void(0);"
                                            class="dropdown-item ai-icon btn btn-primary light" id="btn_logout">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                                viewBox="0 0 24 24" fill="none" stroke="var(--primary)"
                                                stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                                <path d="M9 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h4"></path>
                                                <polyline points="16 17 21 12 16 7"></polyline>
                                                <line x1="21" y1="12" x2="9" y2="12">
                                                </line>
                                            </svg>
                                            <span class="ms-2">Cerrar Sesión </span>
                                        </a>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </li>
                </ul>
            </div>
        </nav>


        

        


        <!--**********************************
            Content body start
        ***********************************-->
        
        <!-- row -->
        <div class="container-fluid">
            <!-- BARRA DE BUSQUEDA -->
            <div class="card mb-0">
                <div class="card-body pb-xl-4 pb-sm-3 pb-0">
                    <div class="row">
                        
                        <div class="row col-xl-12">
                            <!-- FILTRO -->
                            <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                <div class="input-group d-flex align-items-center">
                                    <a href="javascript:void(0);"
                                        class="btn btn-primary shadow btn-sm sharp me-1 rounded-circle mb-1"
                                        data-bs-placement="top">
                                        <i class="fas fa-city fa-lg"></i>
                                    </a>
                                    <label class="form-label mb-0"><b>Seleccione una ciudad</b></label>
                                </div>
                                <select id="txt-departamentos"
                                    class="form-control form-control-sm border-0 default-select dashboard-select-1 wide h-auto"
                                    data-live-search="true" data-size="8">
                                    <option value="all" namedepartamento="all">Todas las ciudades</option>
                                    <option value="01" namedepartamento="Amazonas"> Amazonas</option>
                                    <option value="02" namedepartamento="Ancash"> Ancash</option>
                                    <option value="03" namedepartamento="Apurimac"> Apurimac</option>
                                    <option value="04" namedepartamento="Arequipa"> Arequipa</option>
                                    <option value="05" namedepartamento="Ayacucho"> Ayacucho</option>
                                    <option value="06" namedepartamento="Cajamarca"> Cajamarca</option>
                                    <option value="24" namedepartamento="Callao"> Callao</option>
                                    <option value="07" namedepartamento="Cusco"> Cusco</option>
                                    <option value="08" namedepartamento="Huancavelica"> Huancavelica</option>
                                    <option value="09" namedepartamento="Huanuco"> Huanuco</option>
                                    <option value="10" namedepartamento="Ica"> Ica</option>
                                    <option value="11" namedepartamento="Junin"> Junin</option>
                                    <option value="12" namedepartamento="La Libertad"> La Libertad</option>
                                    <option value="13" namedepartamento="Lambayeque"> Lambayeque</option>
                                    <option value="14" namedepartamento="Lima"> Lima</option>
                                    <option value="15" namedepartamento="Loreto"> Loreto</option>
                                    <option value="16" namedepartamento="Madre de Dios"> Madre de Dios</option>
                                    <option value="17" namedepartamento="Moquegua"> Moquegua</option>
                                    <option value="18" namedepartamento="Pasco"> Pasco</option>
                                    <option value="19" namedepartamento="Piura"> Piura</option>
                                    <option value="20" namedepartamento="Puno"> Puno</option>
                                    <option value="21" namedepartamento="San Martin"> San Martin</option>
                                    <option value="22" namedepartamento="Tacna"> Tacna</option>
                                    <option value="23" namedepartamento="Tumbes"> Tumbes</option>
                                    <option value="25" namedepartamento="Ucayali"> Ucayali</option>
                                </select>
                            </div>
                            <!-- FILTRO -->
                            <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                <div class="input-group d-flex align-items-center">
                                    <a href="javascript:void(0);"
                                        class="btn btn-primary shadow btn-sm sharp me-1 rounded-circle mb-1"
                                        data-bs-placement="top">
                                        <i class="fas fa-bars-staggered fa-lg"></i>
                                    </a>
                                    <label class="form-label mb-0"><b>Seleccione una Categoría</b></label>
                                </div>
                                <select id="txt-categorias"
                                    class="form-control form-control-sm border-0 default-select dashboard-select-1 wide h-auto"
                                    data-live-search="true" data-size="8">
                                    <option>Todas las categorías</option>
                                </select>
                            </div>
                            <!-- FILTRO -->
                            <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                <div class="input-group d-flex align-items-center">
                                    <a href="javascript:void(0);"
                                        class="btn btn-primary shadow btn-sm sharp me-1 rounded-circle mb-1"
                                        data-bs-placement="top">
                                        <i class="fas fa-building fa-lg"></i>
                                    </a>
                                    <label class="form-label mb-0"><b>Seleccione una Empresa</b></label>
                                </div>
                                <select id="txt-empresas"
                                    class="form-control form-control-sm border-0 default-select dashboard-select-1 wide h-auto"
                                    data-live-search="true" data-size="8">
                                    <option>Todas las empresas</option>
                                </select>
                            </div>
                            <!-- BUSCAR POR TEXTO -->
                            <div class="col-xl-3 col-md-6 col-sm-6 col-12 my-2">
                                <label class="form-label mb-2 mt-1"><b>Busque aquí su puesto</b></label>
                                <div class="input-group">
                                    <input type="search" name="txt-buscartexto" id="txt-buscartexto"
                                        class="form-control form-control-sm">
                                    <a id="btnBuscarTexto" href="javascript:void(0);"
                                        class="input-group-text btn-primary rounded text-light"
                                        data-bs-placement="top" title="Buscar"><i
                                            class="fa-solid fa-magnifying-glass"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- VISTA DE TRABAJOS -->
            <div class="row">
                <div class="col-xl-9">
                    <div class="mt-4 d-flex justify-content-between align-items-center flex-wrap">
                        <div class="mb-2">
                            <p class="mb-1 fs-16" id="info-filtros">Sin filtros aplicados</p>
                        </div>
                        <div class="d-flex align-items-center mb-4">
                            <div class="default-tab job-tabs">
                                <ul class="nav nav-tabs" role="tablist">
                                    
                                    <li id="modo-vista-1" class="nav-item">
                                        <a class="nav-link active" data-bs-toggle="tab" href="#Boxed">
                                            <i class="fas fa-th-large"></i>
                                        </a>
                                    </li>
                                    
                                    <li id="modo-vista-2" class="nav-item">
                                        <a class="nav-link" data-bs-toggle="tab" href="#List1">
                                            <i class="fas fa-list"></i>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                            <div>
                                <select class="default-select dashboard-select border-0" id="orden_ofertas">
                                    <option value="desc" data-display="Reciente">Más Reciente</option>
                                    <option value="asc">Más Antiguo</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="tab-content">
                        <!-- VISUALIZACIÓN EN GRILLA -->
                        <div class="tab-pane fade show active" id="Boxed" role="tabpanel">
                            <!-- CARDS -->
                            <div class="row" id="lista_ofertas_laborales">
                            </div>
                        </div>
                        <!-- VISUALIZACIÓN EN LISTA -->
                        <div class="tab-pane fade" id="List1">
                            <div class="row">
                                <!-- CARDS -->
                                <div class="col-xl-12" id="lista2_ofertas_laborales">
                                </div>
                            </div>
                        </div>
                        <!-- NAVEGACIÓN - INICIO -->
                        <div class="d-flex align-items-center justify-content-between flex-wrap">
                            <div class="mb-sm-0 mb-3">
                                <p class="mb-1" id="info_cantidad_bot">--</p>
                                <p class="mb-1" id="info_total_bot">--</p>
                            </div>
                            <nav>
                                <ul id="nro_pagina" class="pagination pagination-circle">
                                    <li class="page-item page-indicator">
                                        <a class="page-link" href="javascript:void(0)">
                                            <i class="la la-angle-left"></i></a>
                                    </li>
                                    <li class="page-item active"><a class="page-link" href="javascript:void(0)">1</a>
                                    </li>
                                    <li class="page-item"><a class="page-link" href="javascript:void(0)">2</a>
                                    </li>
                                    </li>
                                    <li class="page-item page-indicator">
                                        <a class="page-link" href="javascript:void(0)">
                                            <i class="la la-angle-right"></i></a>
                                    </li>
                                </ul>
                            </nav>
                        </div>
                        <!-- NAVEGACIÓN - FIN -->
                    </div>
                </div>
                <!-- VISTA PREVIA DE OFERTA LABORAL -->
                <div class="col-xl-3 mt-4">
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <h4 class="mb-0">Vista Previa</h4>
                    </div>
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="card">
                                <div class="card-header bg-blue">
                                    <div class="researcher">
                                    </div>
                                </div>
                                <div class="card-body">
                                    <span class="text-center d-block block">
                                        <span class="mb-2">
                                            <img src="../storage/companies/default/logo.png" width="141"
                                                height="141" class="rounded-pill">
                                        </span>
                                    </span>
                                    <h4 class="fs-20 mb-0 text-center" id="preview-puesto">Puesto</h4>
                                    <span class="fw-bold mb-3 d-block text-center"
                                        id="preview-nombrecompany">Empresa</span>
                                    <p class="fs-14" id="preview-descripcion">Descripción de la oferta laboral</p>
                                    <div>
                                        <span class="mb-2 d-flex"><i
                                                class="fas fa-star orange me-2 mt-1"></i>Vacantes: <span
                                                class="ms-1" id="preview-vacantes"> ?</span></span>
                                        <span class="mb-2 d-flex"><i class="fas fa-star orange me-2 mt-1"></i>Tipo:
                                            <span class="ms-1" id="preview-tipo"> ?</span></span>
                                        <span class="mb-2 d-flex"><i
                                                class="fas fa-star orange me-2 mt-1"></i>Modalidad: <span
                                                class="ms-1" id="preview-modalidad"> ?</span></span>
                                        <span class="mb-2 d-flex"><i
                                                class="fas fa-star orange me-2 mt-1"></i>Experiencia: <span
                                                class="ms-1" id="preview-experiencia"> ?</span></span>
                                        <span class="mb-2 d-flex"><i class="fas fa-star orange me-2 mt-1"></i>Fecha de
                                            publicación: <span class="ms-1" id="preview-fecpublicacion">
                                                ?</span></span>
                                        <span class="mb-2 d-flex"><i class="fas fa-star orange me-2 mt-1"></i>Fecha de
                                            cierre: <span class="ms-1" id="preview-feccierre"> ?</span></span>
                                        <span class="mb-2 d-flex"><i class="fas fa-star orange me-2 mt-1"></i>Rango
                                            salarial: <span class="ms-1" id="preview-rangosalarial"> ?</span></span>
                                        <span class="mb-2 d-flex"><i class="fas fa-star orange me-2 mt-1"></i>Nivel
                                            educativo: <span class="ms-1" id="preview-nivel_educativo">
                                                ?</span></span>
                                        <span class="mb-2 d-flex"><i
                                                class="fas fa-star orange me-2 mt-1"></i>Categoría: <span
                                                class="ms-1" id="preview-nombrecategory"> ?</span></span>
                                        <span class="mb-2 d-flex"><i
                                                class="fas fa-star orange me-2 mt-1"></i>Ubicación: <span
                                                class="ms-1" id="preview-ubicacion"> ?</span></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!--**********************************
            Content body end
        ***********************************-->
        <div class="footer">
            <div class="copyright">
                <p>Copyright © Diseñado &amp; Desarrollado por <a class="link" href="https://silfersystem.com/"
                        target="_blank">Silfersystem</a> 2023</p>
            </div>
        </div>

    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->

    <!-- Modal -->
    <form id="formModal" novalidate>
        <?php echo csrf_field(); ?>
        <div id="modalPostular" class="modal fade" tabindex="-1" aria-labelledby="modalPostularLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-ls">
                <div class="modal-content">
                    <!-- header -->
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalPostularLabel">Enviar CV para postular</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <!-- body -->
                    <div class="modal-body py-3">
                        <div class="row">
                            <div class="row col-xl-12">
                                <!-- data -->
                                <input type="hidden" id="txt-idjob" name="txt-idjob">
                                <input type="hidden" id="txt-idcompany" name="txt-idcompany">
                                <!-- data -->
                                <div id="div-txt-documento" class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-documento" class="form-label text-primary"><b>Sube tu Curriculum
                                            Vitae</b> (Debe pesar maximo 2 MB y estar en formato PDF, PNG o JPG)</label>
                                    <input id="txt-documento" name="txt-documento" type="file"
                                        class="form-control form-control-sm" required>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button id="btnCloseModal" type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnPostular" type="button" class="btn btn-primary btn-sm ">Confirmar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>




    <!--**********************************
        Scripts
    ***********************************-->

    <?php echo $__env->make('include.plugins-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.datatable-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template JS -->
    <script src="<?php echo e(asset('/js/custom.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/js/dlabnav-init.js')); ?>"></script>


    <!-- Logout JS -->
    <script>
        var logoutRoute = '<?php echo e(route('logout')); ?>';
    </script>
    <script src="<?php echo e(asset('/js_Ajax_login/js_Script_Ajax_logout.js')); ?>"></script>


    <!--  Page JS -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/alumno/ofertas_laborales.js']); ?>;
    

</body>

</html>
<?php /**PATH C:\Users\USER\OneDrive\Documentos\GitHub\bolsa-laboral-ica\resources\views/docente/ofertas_laborales/index.blade.php ENDPATH**/ ?>