<!DOCTYPE html>
<html lang="en" class="h-100">

<head>
    <?php echo $__env->make('include.meta-favicon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
    <?php echo $__env->make('include.plugins-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
    <!-- Page Title Here -->
    <title>BOLSA LABORAL</title>
    
    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="<?php echo e(asset('/css/style.css')); ?>" rel="stylesheet">
    
    <style>
        .img-fit-contain { object-fit: contain; object-position: center; background:#fff; }
    </style>
</head>

<body>
    <!-- Navbar moderno con iconos, mejor diseño y estructura mejorada -->
    <nav class="navbar navbar-expand-lg shadow-sm" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); padding: 1.2rem 0;">
        <div class="container-fluid px-4">
            <div class="d-flex align-items-center justify-content-between w-100">
                <!-- Logo y título principal -->
                <div class="d-flex align-items-center">
                    <div class="bg-white rounded-circle p-2 shadow-sm me-3" style="width: 88px; height: 88px; display: flex; align-items: center; justify-content: center;">
                        <img src="../../images/institucion/logo.png" alt="Logo" class="w-100 h-100" style="object-fit: contain; border-radius: 50%;">
                    </div>
                    <div>
                        <h2 class="text-white mb-0 fw-bold" style="font-size: 1.5rem; letter-spacing: -0.5px;">BOLSA LABORAL</h2>
                        <h3 class="text-white mb-0 fw-bold"><?php echo e($info->nombre ?? '-'); ?></h3>
                    </div>
                </div>
                
                <!-- Información adicional -->
                <div class="d-none d-md-flex align-items-center gap-4">
                    <div class="d-flex align-items-center text-white">
                        <i class="fa-solid fa-users fa-lg me-2"></i>
                        <div>
                            <small class="d-block opacity-75" style="font-size: 0.75rem;">Portal de</small>
                            <span class="fw-semibold" style="font-size: 0.9rem;">Empleo Institucional</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </nav>
    <!-- row -->
    <div class="container-fluid" style="background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%); min-height: calc(100vh - 56px); padding: 30px 20px;">

        <!-- TÍTULO NUEVO -->
        <div class="row">
            <div class="col-12">
                <h3 class="text-center text-primary fw-bold mb-4" 
                    style="letter-spacing: .5px; font-size: 2rem; text-transform: uppercase;">
                    ACCESOS BOLSA LABORAL INSTITUCIONAL
                </h3>
            </div>
        </div>

        <div class="row justify-content-center align-items-stretch g-4">
            <div class="col-xl-3 col-lg-6 col-md-6 col-sm-12">
                <div class="card border-0 shadow-lg h-100" style="border-radius: 20px; overflow: hidden; transition: all 0.3s ease;">
                    <div class="card-header p-0 border-0 position-relative" style="height: 240px; overflow: hidden;">
                        <div class="position-absolute w-100 h-100" style="background: linear-gradient(180deg, rgba(0,0,0,0) 0%, rgba(0,0,0,0.4) 100%); z-index: 1;"></div>
                        <img src="<?php echo e(asset('images/institucion/bt_students.png')); ?>" alt="Estudiante/Egresado" class="img-fluid w-100 h-100 img-fit-contain" style="transition: transform 0.3s ease;">
                    </div>
                    <div class="card-body p-4 bg-white">
                        <h4 class="text-center mb-3 fw-bold text-primary" style="font-size: 1.3rem;">Estudiante/Egresado</h4>
                        <p class="text-center text-muted mb-4" style="font-size: 0.9rem; line-height: 1.6;">Accede a oportunidades laborales y gestiona tu perfil profesional</p>
                        <button id="bt-student" class="btn btn-primary w-100 py-3 fw-semibold shadow-sm" style="border-radius: 12px; font-size: 1rem; transition: all 0.3s ease;">
                            <i class="fa-solid fa-graduation-cap fa-lg me-2"></i>Ingresar
                        </button>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-lg-6 col-md-6 col-sm-12">
                <div class="card border-0 shadow-lg h-100" style="border-radius: 20px; overflow: hidden; transition: all 0.3s ease;">
                    <div class="card-header p-0 border-0 position-relative" style="height: 240px; overflow: hidden;">
                        <div class="position-absolute w-100 h-100" style="background: linear-gradient(180deg, rgba(0,0,0,0) 0%, rgba(0,0,0,0.4) 100%); z-index: 1;"></div>
                        <img src="<?php echo e(asset('images/institucion/bt_teacher.png')); ?>" alt="Docente" class="img-fluid w-100 h-100 img-fit-contain" style="transition: transform 0.3s ease;">
                    </div>
                    <div class="card-body p-4 bg-white">
                        <h4 class="text-center mb-3 fw-bold text-primary" style="font-size: 1.3rem;">Docente</h4>
                        <p class="text-center text-muted mb-4" style="font-size: 0.9rem; line-height: 1.6;">Supervisa y apoya el desarrollo profesional de tus estudiantes</p>
                        <button id="bt-teacher" class="btn btn-primary w-100 py-3 fw-semibold shadow-sm" style="border-radius: 12px; font-size: 1rem; transition: all 0.3s ease;">
                            <i class="fa-solid fa-chalkboard-user fa-lg me-2"></i>Ingresar
                        </button>
                    </div>
                </div>
            </div>
        
            <div class="col-xl-3 col-lg-6 col-md-6 col-sm-12">
                <div class="card border-0 shadow-lg h-100" style="border-radius: 20px; overflow: hidden; transition: all 0.3s ease;">
                    <div class="card-header p-0 border-0 position-relative" style="height: 240px; overflow: hidden;">
                        <div class="position-absolute w-100 h-100" style="background: linear-gradient(180deg, rgba(0,0,0,0) 0%, rgba(0,0,0,0.4) 100%); z-index: 1;"></div>
                        <img src="<?php echo e(asset('images/institucion/bt_admin.png')); ?>" alt="Administrador" class="img-fluid w-100 h-100 img-fit-contain" style="transition: transform 0.3s ease;">
                    </div>
                    <div class="card-body p-4 bg-white">
                        <h4 class="text-center mb-3 fw-bold text-primary" style="font-size: 1.3rem;">Administrador</h4>
                        <p class="text-center text-muted mb-4" style="font-size: 0.9rem; line-height: 1.6;">Gestiona el sistema y administra usuarios y configuraciones</p>
                        <button id="bt-admin" class="btn btn-primary w-100 py-3 fw-semibold shadow-sm" style="border-radius: 12px; font-size: 1rem; transition: all 0.3s ease;">
                            <i class="fa-solid fa-user-shield fa-lg me-2"></i>Ingresar
                        </button>
                    </div>
                </div>
            </div>
        
            <div class="col-xl-3 col-lg-6 col-md-6 col-sm-12">
                <div class="card border-0 shadow-lg h-100" style="border-radius: 20px; overflow: hidden; transition: all 0.3s ease;">
                    <div class="card-header p-0 border-0 position-relative" style="height: 240px; overflow: hidden;">
                        <div class="position-absolute w-100 h-100" style="background: linear-gradient(180deg, rgba(0,0,0,0) 0%, rgba(0,0,0,0.4) 100%); z-index: 1;"></div>
                        <img src="<?php echo e(asset('images/institucion/bt_empresa.jpg')); ?>" alt="Empresa" class="img-fluid w-100 h-100 img-fit-contain" style="transition: transform 0.3s ease;">
                    </div>
                    <div class="card-body p-4 bg-white">
                        <h4 class="text-center mb-3 fw-bold text-primary" style="font-size: 1.3rem;">Empresa</h4>
                        <p class="text-center text-muted mb-4" style="font-size: 0.9rem; line-height: 1.6;">Publica ofertas laborales y encuentra talento calificado</p>
                        <button id="bt-company" class="btn btn-primary w-100 py-3 fw-semibold shadow-sm" style="border-radius: 12px; font-size: 1.3rem; transition: all 0.3s ease;">
                            <i class="fa-solid fa-building fa-lg me-2"></i>Ingresar
                        </button>
                    </div>
                </div>
            </div>
        </div>

        
        
        
        <!-- === NUEVA FILA: 4 DIVS INFORMATIVOS (debajo de los 4 perfiles) === -->
        <div class="row g-3 mt-4 justify-content-center">
            <div class="col-xl-3 col-lg-6 col-md-6 col-sm-12">
                <div class="h-100 p-3 bg-white shadow-sm border rounded-4 text-center">
                    <i class="fa-solid fa-headset fa-2x mb-2 text-primary"></i>
                    <h6 class="fw-bold mb-1">Soporte Técnico</h6>
                    <p class="text-muted mb-0" style="font-size: .9rem;">Ayuda para acceso y uso de la Bolsa Laboral.</p>
                </div>
            </div>
            <div class="col-xl-3 col-lg-6 col-md-6 col-sm-12">
                <div class="h-100 p-3 bg-white shadow-sm border rounded-4 text-center">
                    <i class="fa-solid fa-file-lines fa-2x mb-2 text-primary"></i>
                    <h6 class="fw-bold mb-1">Guía de Postulación</h6>
                    <p class="text-muted mb-0" style="font-size: .9rem;">Pasos para crear CV y postular a ofertas.</p>
                </div>
            </div>
            <div class="col-xl-3 col-lg-6 col-md-6 col-sm-12">
                <div class="h-100 p-3 bg-white shadow-sm border rounded-4 text-center">
                    <i class="fa-solid fa-handshake fa-2x mb-2 text-primary"></i>
                    <h6 class="fw-bold mb-1">Empresas Aliadas</h6>
                    <p class="text-muted mb-0" style="font-size: .9rem;">Conexión con empleadores y convenios.</p>
                </div>
            </div>
            <div class="col-xl-3 col-lg-6 col-md-6 col-sm-12">
                <div class="h-100 p-3 bg-white shadow-sm border rounded-4 text-center">
                    <i class="fa fa-shield-alt fa-2x mb-2 text-primary" aria-hidden="true"></i>
                    <h6 class="fw-bold mb-1">Políticas y Términos</h6>
                    <p class="text-muted mb-0" style="font-size: .9rem;">Uso responsable y tratamiento de datos.</p>
                </div>
            </div>
        </div>
        <!-- === /FIN NUEVA FILA === -->
        
        
    </div>

    <?php echo $__env->make('include.plugins-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- MODAL -->
    <form class="needs-validation" id="form" name="form" novalidate>
        <?php echo csrf_field(); ?>
        <div class="modal fade show" id="loginModal" tabindex="-1" aria-labelledby="loginModalLabel" aria-modal="true" role="dialog">
            <div class="modal-dialog modal-dialog-center modal-md">
                <div class="modal-content border-0 shadow">
                    <!-- header -->
                    <div class="modal-header bg-primary">
                        <h5 class="modal-title text-white" id="loginModalLabel">Inciar sesión como</h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <!-- body -->
                    <div class="modal-body">
                        <input type="hidden" id="op" name="op" value="1">
                        <input type="hidden" id="op_tipo_user" name="op_tipo_user" value="0001">
                        <input type="hidden" id="txt-usertype" name="txt-usertype">

                        <div class="text-center mb-4">
                            <img class="img1 move-1" 
                                 src="<?php echo e(asset('images/institucion/logo-login.png')); ?>" 
                                 alt="Logo" 
                                 style="width: 140px; height: 100px; object-fit: contain;">
                            <h3 class="text-center mb-2 text-primary mt-2" style="font-size: 1.6rem;">INICIAR SESIÓN</h3>
                        </div>


                        <!-- Agregado -->
                        <div class="mb-3" id="div-identificationtype">
                            <label for="txt-identificationtype" class="form-label mb-2 fs-13 label-color font-w500">Tipo de documento</label>
                            <select class="default-select  form-control wide" id="txt-identificationtype" name="txt-identificationtype" required>
                                <!-- combobox -->
                                <option selected disabled value="">Seleccione opción</option>
                            </select>
                        </div>

                        <div class="mb-3">
                            <label for="text_input_codigo" class="form-label mb-2 fs-13 label-color font-w500" id="titulo_tipo">Código</label>
                            <div class="input-group">
                                <span class="input-group-text"> <i class="fa fa-user"></i> </span>
                                <input type="text" class="form-control" id="text_input_codigo" name="text_input_codigo_name" autocomplete="off" placeholder="Ingrese su nombre de usuario" required="">
                                <div class="invalid-feedback">
                                    Ingrese un código.
                                </div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="text_input_codigo" class="form-label mb-2 fs-13 label-color font-w500" id="titulo_tipo">Contraseña</label>
                            <div class="input-group transparent-append">
                                <span class="input-group-text"> <i class="fa fa-lock"></i> </span>
                                <input type="password" class="form-control" id="dlab-password" name="text_input_passn_name" autocomplete="off" placeholder="Ingrese su contraseña" required="">
                                <span class="input-group-text show-pass active">
                                    <i class="fa fa-eye-slash"></i>
                                    <i class="fa fa-eye"></i>
                                </span>
                                <div class="invalid-feedback">
                                    Ingrese contraseña
                                </div>
                            </div>

                        </div>
                        <button class="btn btn-block btn-secondary" id="btn_button_login">Iniciar Sesión</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <!-- MODAL -->
    <form class="needs-validation" id="form2" name="form2" novalidate>
        
        <div class="modal fade show" id="loginModal2" tabindex="-1" aria-labelledby="loginModal2Label" aria-modal="true" role="dialog">
            <div class="modal-dialog modal-dialog-center modal-md">
                <div class="modal-content border-0 shadow">
                    <!-- header -->
                    <div class="modal-header bg-primary">
                        <h5 class="modal-title text-white" id="loginModal2Label">Inciar sesión como empresa</h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <!-- body -->
                    <div class="modal-body">
                        <input type="hidden" id="txt-usertype2" name="txt-usertype2">

                        <div class="text-center mb-4">
                            <img class="img1 move-1" src="<?php echo e(asset('images/institucion/logo-login.png')); ?>" alt="" width="100px">
                            <h3 class="text-center mb-2 text-primary">INICIAR SESIÓN</h3>
                        </div>

                        <div class="mb-3">
                            <label for="txt-ruc_name" class="form-label mb-2 fs-13 label-color font-w500" id="titulo_tipo">RUC</label>
                            <div class="input-group">
                                <span class="input-group-text"> <i class="fa fa-user"></i> </span>
                                <input type="text" class="form-control" id="txt-ruc_name" name="txt-ruc_name" autocomplete="off" placeholder="Ingrese su nombre de usuario" required="">
                                <div class="invalid-feedback">
                                    Ingrese un código.
                                </div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="txt-password" class="form-label mb-2 fs-13 label-color font-w500" id="titulo_tipo">Contraseña</label>
                            <div class="input-group transparent-append">
                                <span class="input-group-text"> <i class="fa fa-lock"></i> </span>
                                <input type="password" class="form-control" id="txt-password" name="txt-password" autocomplete="off" placeholder="Ingrese su contraseña" required="">
                                <div class="invalid-feedback">
                                    Ingrese contraseña
                                </div>
                            </div>
                        </div>

                        <div class="text-center mb-3">
                            <a id="registro-empresa" href="javascript:void(0);" class="my-2">Aun no tienes una cuenta? Solicitalo aquí</a>
                        </div>

                        <button class="btn btn-block btn-secondary" id="btn_button_loginCompany">Iniciar Sesión</button>
                    </div>
                </div>
            </div>
        </div>
    </form>


    <form class="needs-validation" id="formModal3" name="formModal3" novalidate>
        <?php echo csrf_field(); ?>
        <div class="modal fade show" id="modalRegistro" tabindex="-1" aria-labelledby="modalRegistroLabel" aria-modal="true" role="dialog">
            <div class="modal-dialog modal-dialog-center modal-md">
                <div class="modal-content border-0 shadow">
                    <!-- header -->
                    <div class="modal-header bg-primary">
                        <h5 class="modal-title text-white" id="modalRegistroLabel">Solicita tu registro de cuenta</h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <!-- body -->
                    <div class="modal-body">
                        <div class="row">
                            <div class="row col-xl-12">
                                <!-- data -->
                                <input id="txt-idcompany" name="txt-idcompany" type="hidden">
                                <!-- data -->
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt-ruc" class="form-label text-primary">RUC</label>
                                    <div class="input-group">
                                        <input class="form-control form-control-sm" id="txt-ruc" name="txt-ruc" placeholder="Ingrese RUC" autocomplete="off" maxlength="20" type="number" required>
                                        
                                        <button class="btn btn-primary btn-sm" type="button" id="btn-querydata"><i class="fa-solid fa-magnifying-glass fa-beat-fade"></i>
                                            Validar
                                        </button>
                                        <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-nombre" class="form-label text-primary">Nombre</label>
                                    <input id="txt-nombre" name="txt-nombre" type="text"
                                        class="form-control form-control-sm" placeholder="Ingrese nombre"
                                        required>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-direccion" class="form-label text-primary">Dirección</label>
                                    <input id="txt-direccion" name="txt-direccion" type="text"
                                        class="form-control form-control-sm"
                                        placeholder="Ingrese direccion" required>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-nrocontacto" class="form-label text-primary">Nro. de Contacto</label>
                                    <input id="txt-nrocontacto" name="txt-nrocontacto" type="text"
                                        class="form-control form-control-sm"  autocomplete="off"
                                        onkeypress='return event.charCode >= 48 && event.charCode <= 57' maxlength="9"
                                        placeholder="Ingrese celular o teléfono" required>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-correo" class="form-label text-primary">Correo</label>
                                    <input id="txt-correo" name="txt-correo" type="text"
                                        class="form-control form-control-sm"
                                        placeholder="Ingrese correo" required>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-12 col-12 mb-3">
                                    <label for="txt-user" class="form-label text-primary">Nombre de usuario</label>
                                    <input id="txt-user" name="txt-user" type="text"
                                        class="form-control form-control-sm"
                                        placeholder="Ingrese nombre de usuario" required>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                                </div>
                                <!-- data -->
                                <div id="div-txt-password" class="col-xl-6 col-md-6 col-sm-12 col-12 mb-3">
                                    <label for="txt-password" class="form-label text-primary">Contraseña</label>
                                    <input id="txt-password" name="txt-password" type="password"
                                        class="form-control form-control-sm" placeholder="********" required>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                                </div>
                            </div> 
                            <!-- footer -->
                            <div class="modal-footer">
                                <button id="btnSolicitud" type="button" class="btn btn-primary btn-sm ">Solicitar Registro</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>


    <!-- Template JS -->
    <script src="<?php echo e(asset('js/custom.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/dlabnav-init.js')); ?>"></script>

    

    <script>
        var authenticateRoute = "<?php echo e(route('login.authenticate')); ?>";
        var authenticateRouteCompany = "<?php echo e(route('loginCompany.authenticate')); ?>";
    </script>
    <script src="<?php echo e(asset('js_Ajax_login/js_Script_Ajax_login.js')); ?>" type="module"></script>
    <script src="<?php echo e(asset('js_combobox/identificationtypes.js')); ?>"></script>
</body>

</html>
<?php /**PATH C:\Users\USER\OneDrive\Documentos\GitHub\bolsa-laboral-ica\resources\views/welcome.blade.php ENDPATH**/ ?>