<!DOCTYPE html>
<html lang="es">

<head>

    <?php echo $__env->make('include.meta-favicon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.plugins-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Page Title Here -->
    <title>Gestionar Ofertas Laborales</title>

    <?php echo $__env->make('include.datatable-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="<?php echo e(asset('/css/style.css')); ?>" rel="stylesheet">
    

</head>

<body>

    <?php echo $__env->make('include.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        <?php echo $__env->make('include.nav_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        
        <?php $__env->startSection('titlenavbar'); ?>
            Gestionar Ofertas Laborales
        <?php $__env->stopSection(); ?>

        <?php echo $__env->make('include.sidebarCompany', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">
                            <!-- Column starts -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <div class="card-header flex-wrap px-3">
                                        <div>
                                            <h4 class="card-title">Registro de información sobre ofertas laborales</h4>
                                        </div>
                                        <button id="btnUpdateView" type="button" class="btn btn-secondary btn-sm mr-1">
                                            <i class="fa-solid fa-rotate-right fa-fade"></i> Actualizar
                                        </button>
                                        <button id="btnCreateModal" type="button" class="btn btn-primary btn-xl" data-bs-toggle="modal" data-bs-target="#modalCreateUpdate">
                                            + Nueva Oferta Laboral
                                        </button>
                                    </div>
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral"
                                                        class="table table-hover table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">#</th>
                                                                <th class="text-center">Categoría</th>
                                                                <th class="text-center">Puesto</th>
                                                                <th class="text-center">Vacantes</th>
                                                                <th class="text-center">Documento</th>
                                                                <th class="text-center">Fecha inicio - fin</th>
                                                                <th class="text-center">Rango Salarial</th>
                                                                <th class="text-center">Estado</th>
                                                                <th class="text-center">Acciones</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--**********************************
            Content body end
        ***********************************-->
        <?php echo $__env->make('include.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->

    <!-- Modal -->
    <form id="formModal" novalidate>
        <?php echo csrf_field(); ?>
        <div id="modalCreateUpdate" class="modal fade" tabindex="-1" aria-labelledby="modalCreateUpdateLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-xl">
                <div class="modal-content">
                    <!-- header -->
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalCreateUpdateLabel">Registrar nueva oferta laboral</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <!-- body -->
                    <div class="modal-body">
                        <div class="row">
                            <div class="row col-xl-12">
                                <!-- data -->
                                <input id="txt-idjob" name="txt-idjob" type="hidden">
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-categories" class="form-label text-primary">Categoria</label>
                                    <select id="txt-categories" name="txt-categories"
                                        class="form-control form-control-sm" data-live-search="true" required>
                                        <!-- combobox -->
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-puesto" class="form-label text-primary">Puesto</label>
                                    <input id="txt-puesto" name="txt-puesto" type="text"
                                        class="form-control form-control-sm" placeholder="Ingrese puesto" required>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-vacantes" class="form-label text-primary">Vacantes</label>
                                    <input id="txt-vacantes" name="txt-vacantes" type="text" onkeypress='return event.charCode >= 48 && event.charCode <= 57' autocomplete="off" maxlength="5"
                                        class="form-control form-control-sm" placeholder="Ingrese vacantes" required>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-documento" class="form-label text-primary">Documento</label>
                                    <input id="txt-documento" name="txt-documento" type="file"
                                        class="form-control form-control-sm">
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-tipo" class="form-label text-primary">Tipo</label>
                                    <select id="txt-tipo" name="txt-tipo"
                                        class="default-select  form-control form-control-sm" required>
                                        <!-- combobox -->
                                        <option selected value="Tiempo Completo">Tiempo Completo</option>
                                        <option value="Tiempo Parcial">Tiempo Parcial</option>
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-modalidad" class="form-label text-primary">Modalidad</label>
                                    <select id="txt-modalidad" name="txt-modalidad"
                                        class="default-select  form-control form-control-sm" required>
                                        <!-- combobox -->
                                        <option selected value="Presencial">Presencial</option>
                                        <option value="Remoto">Remoto</option>
                                        <option value="Híbrido">Híbrido</option>
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-experiencia" class="form-label text-primary">Experiencia</label>
                                    <select id="txt-experiencia" name="txt-experiencia"
                                        class="default-select  form-control form-control-sm" required>
                                        <!-- combobox -->
                                        <option value="No requerida">No requerida</option>
                                        <option value="1 mes">1 mes</option>
                                        <option value="3 meses">3 meses</option>
                                        <option value="6 meses">6 meses</option>
                                        <option value="9 meses">9 meses</option>
                                        <option selected value="1 año">1 año</option>
                                        <option value="2 años">2 años</option>
                                        <option value="3 años">3 años</option>
                                        <option value="4 años">4 años</option>
                                        <option value="5 años">5 años</option>
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-nivel_educativo" class="form-label text-primary">Nivel educativo</label>
                                    <select id="txt-nivel_educativo" name="txt-nivel_educativo"
                                        class="default-select  form-control form-control-sm" required>
                                        <!-- combobox -->
                                        <option selected value="Profesional Técnico">Profesional Técnico</option>
                                        <option value="Técnico">Técnico</option>
                                        <option value="Estudiante">Estudiante</option>
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-fecpublicacion" class="form-label text-primary">Fecha de Publicación</label>
                                    <div class="input-group">
                                        <div class="input-group-text"><i class="far fa-calendar"></i></div>
                                        <input id="txt-fecpublicacion" name="txt-fecpublicacion" type="date"
                                            class="form-control form-control-sm" placeholder="" required>
                                        <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                                    </div>
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-feccierre" class="form-label text-primary">Fecha de Cierre</label>
                                    <div class="input-group">
                                        <div class="input-group-text"><i class="far fa-calendar"></i></div>
                                        <input id="txt-feccierre" name="txt-feccierre" type="date"
                                            class="form-control form-control-sm" placeholder="" required>
                                        <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                                    </div>
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-salariomin" class="form-label text-primary">Salario Minímo (Hasta 6 digitos)</label>
                                    <input id="txt-salariomin" name="txt-salariomin" type="text" autocomplete="off" onkeypress="return (event.charCode >= 48 && event.charCode <= 57) || event.charCode === 46"
                                        class="form-control form-control-sm" placeholder="Ingrese salario minímo"
                                        required>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-salariomax" class="form-label text-primary">Salario Máximo (Hasta 6 digitos)</label>
                                    <input id="txt-salariomax" name="txt-salariomax" type="text" autocomplete="off" onkeypress="return (event.charCode >= 48 && event.charCode <= 57) || event.charCode === 46"
                                        class="form-control form-control-sm" placeholder="Ingrese salario máximo" required>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3" style="display: none;">
                                    <label for="txt-estado" class="form-label text-primary">Estado</label>
                                    <select id="txt-estado" name="txt-estado"
                                        class="form-control form-control-sm" data-live-search="true" required>
                                        <!-- combobox -->
                                        <option selected value="1">Publicado</option>
                                        <option value="0">No Publicado</option>
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_departamento" class="form-label text-primary">Departamento</label>
                                    <select id="txt_departamento" name="txt_departamento"
                                        class="form-control form-control-sm" data-live-search="true" required>
                                        <!-- combobox -->
                                        <?php echo $__env->make('include.combobox.departamento', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_provincia" class="form-label text-primary">Provincia</label>
                                    <select id="txt_provincia" name="txt_provincia"
                                        class="form-control form-control-sm" data-live-search="true" required>
                                        <!-- combobox dinamico -->
                                        <option selected disabled value="">Seleccione opción</option>
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_distrito" class="form-label text-primary">Distrito</label>
                                    <select id="txt_distrito" name="txt_distrito"
                                        class="form-control form-control-sm" data-live-search="true" required>
                                        <!-- combobox dinamico -->
                                        <option selected disabled value="">Seleccione opción</option>
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-link" class="form-label text-primary">Link (URL de la Empresa)</label>
                                    <input id="txt-link" name="txt-link" type="text"
                                        class="form-control form-control-sm" placeholder="Ingrese URL">
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-descripcion" class="form-label text-primary">Descripción</label>
                                    <textarea id="txt-descripcion" name="txt-descripcion"
                                        class="form-control form-control-sm" placeholder="Ingrese descripción">
                                    </textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnCreateUpdate" type="button" class="btn btn-primary btn-sm ">Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <!--**********************************
        Scripts
    ***********************************-->

    <?php echo $__env->make('include.plugins-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.datatable-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template JS -->
    <script src="<?php echo e(asset('/js/custom.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/js/dlabnav-init.js')); ?>"></script>
    <script>
        tinymce.init({
            selector: '#txt-descripcion',
        });
    </script>

    <!-- Logout JS -->
    <script>
        var logoutRoute = '<?php echo e(route('logout')); ?>';
    </script>
    <script src="<?php echo e(asset('/js_Ajax_login/js_Script_Ajax_logout.js')); ?>"></script>


    <!--  Page JS -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/empresas/ofertas_laborales.js']); ?>;
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/common/combobox/roles.js']); ?>;
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/common/combobox/ubigeo.js']); ?>;

</body>

</html>

<?php echo $__env->make('include.headerCompany', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\USER\OneDrive\Documentos\GitHub\bolsa-laboral-ica\resources\views/empresa/ofertas_laborales/index.blade.php ENDPATH**/ ?>