<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\empresa\JpcategoryController;
use App\Http\Controllers\empresa\JpcompanyController;
use App\Http\Controllers\FileController;
use App\Http\Controllers\empresa\JpjobController as CompanyJpjobController;
use App\Http\Controllers\empresa\JpjobapplicationController as CompanyJpjobapplicationController;

// RUTAS PARA ALUMNOS


/* --------------------------
    INICIO - BOLSA LABORAL
    --------------------------*/
    Route::group(['middleware' => ['checksessioncompany', 'checkestadocompany']], function () {
        
        // OFERTAS LABORALES - INICIO
        Route::get('/empresa/ofertas_laborales', [CompanyJpjobController::class, 'index'])->name('empresa.ofertas_laborales');        
        Route::post('/empresa/ofertas_laborales/list', [CompanyJpjobController::class, 'list']);
        Route::post('/empresa/ofertas_laborales/store', [CompanyJpjobController::class, 'store']);
        Route::put('/empresa/ofertas_laborales/update/{id}', [CompanyJpjobController::class, 'update']);
        Route::delete('/empresa/ofertas_laborales/destroy/{id}', [CompanyJpjobController::class, 'destroy']);
        // Route::get('/verTrabajoDocumento/{idjob}', [CompanyJpjobController::class, 'verTrabajoDocumento']);
        // OFERTAS LABORALES - FIN
        
        // POSTULACIONES - INICIO
        Route::get('/empresa/postulaciones', [CompanyJpjobapplicationController::class, 'index'])->name('empresa.postulaciones');        
        Route::post('/empresa/postulaciones/list', [CompanyJpjobapplicationController::class, 'list']);
        Route::put('/empresa/postulaciones/aprobar/{id}', [CompanyJpjobapplicationController::class, 'aprobar']);
        Route::put('/empresa/postulaciones/rechazar/{id}', [CompanyJpjobapplicationController::class, 'rechazar']);
        Route::delete('/empresa/postulaciones/destroy/{id}', [CompanyJpjobapplicationController::class, 'destroy']);
        Route::get('/verCurriculumVitae/{idjobapplication}', [FileController::class, 'verCurriculumVitae']);
        // POSTULACIONES - FIN
        
    });
    /* --------------------------
        FIN - BOLSA LABORAL
        --------------------------*/


// FIN RUTAS PARA ALUMNOS
