<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Historial de Postulaciones</title>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">
    {{--     --}}

</head>

<body>

    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')
        @section('titlenavbar')
            Historial de Postulaciones
        @endsection

        @include('include.sidebar')


        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">
                            <!-- Column starts -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral"
                                                        class="table table-hover table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">#</th>
                                                                <th class="text-center">Empresa</th>
                                                                <th class="text-center">Puesto</th>
                                                                <th class="text-center">Rango Salarial</th>
                                                                <th class="text-center">Fecha Postulación</th>
                                                                <th class="text-center">Ver CV</th>
                                                                <th class="text-center">Estado</th>
                                                                <th class="text-center">Link</th>
                                                                <th class="text-center">Datos Externos</th>
                                                                <th class="text-center">Comentario</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--**********************************
            Content body end
        ***********************************-->
        @include('include.footer')

    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->
    <!-- Modal -->
    <form id="formModal" novalidate>
        @csrf
        <div id="modalDescripcion" class="modal fade" tabindex="-1" aria-labelledby="modalDescripcionLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-ls">
                <div class="modal-content">
                    <!-- header -->
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalDescripcionLabel">Datos Externos</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <!-- body -->
                    <div class="modal-body">
                        <div class="row">
                            <div class="row col-xl-12">
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3" style="display: none;">
                                    <textarea id="txt-descripcion" name="txt-descripcion"
                                        class="form-control form-control-sm" placeholder="Ingrese descripción">
                                    </textarea>
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <div id="txt-descripcion2" name="txt-descripcion2"
                                        >
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

        <!-- Modal -->
        <form id="formModal2" novalidate>
            @csrf
            <div id="modalComentario" class="modal fade" tabindex="-1" aria-labelledby="modalComentarioLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-center modal-ls">
                    <div class="modal-content">
                        <!-- header -->
                        <div class="modal-header">
                            <h1 class="modal-title fs-5" id="modalComentarioLabel">Comentarios</h1>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <!-- body -->
                        <div class="modal-body">
                            <div class="row">
                                <div class="row col-xl-12">
                                    <!-- data -->
                                    <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3" style="display: none;">
                                        <input id="txt-fecfeedback" name="txt-fecfeedback" type="text"
                                            class="form-control form-control-sm" placeholder="Ingrese descripción">
                                    </div>
                                    <!-- data -->
                                    <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                        <textarea id="txt-feedback" name="txt-feedback"
                                            class="form-control form-control-sm" readonly>
                                        </textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- footer -->
                        <div class="modal-footer">
                            <button type="button" class="btn btn-danger  btn-sm light"
                                data-bs-dismiss="modal">Cerrar</button>
                        </div>
                    </div>
                </div>
            </div>
        </form>

    <!--**********************************
        Scripts
    ***********************************-->

    @include('include.plugins-scripts')

    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>
    <script>
        tinymce.init({
            selector: '#txt-descripcion',
            // apiKey: '4sh9d8nudkauw4719swn2o8026yhuxdscvzznkyvp2o0wjzg',
            plugins: "advcode advtable autocorrect autolink checklist codesample editimage emoticons image link linkchecker lists media mediaembed powerpaste table tinymcespellchecker",
            toolbar: "bold italic forecolor backcolor | numlist bullist | link image emoticons codesample blockquote ",
            placeholder: "Add a comment...",
        });
    </script>

    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>
    @vite(['resources/js/login/logout.js']);

    <!--  Page JS -->
    @vite(['resources/js/alumno/postulaciones.js']);
    {{-- <script src="{{ asset('js_Ajax_alumnos/postulaciones.js') }}" type="module"></script> --}}

</body>

</html>
