<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Gestionar Planes</title>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">
    <link href="{{ asset('/css/preloader.css') }}" rel="stylesheet">
</head>

<body>
    <div id="progressSection" style="display: none;"> <!-- Contenedor de la barra de progreso, inicialmente oculto -->
        <div id="porcentaje">0</div>
        <div class="barra_progreso">
            <div class="progreso" id="progreso"></div>
        </div>
    </div>

    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')
        @section('titlenavbar')
            {{ __('Gestionar Planes') }}
        @endsection

        @include('include.sidebar')

        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12 col-lg-12 col-md-12 col-12">
                        <meta name="csrf-token" content="{{ csrf_token() }}">
                        <div class="row">
                            <!-- Column starts -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <div class="card-header flex-wrap px-3">
                                        <div>
                                            <h4 class="card-title">Registro de información sobre los planes</h4>
                                        </div>
                                        <button id="btnCreateModal" type="button" class="btn btn-primary btn-sm"
                                            data-bs-toggle="modal" data-bs-target="#modalCreateUpdate">
                                            + Nuevo Plan
                                        </button>
                                    </div>
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <div class="table-responsive" id="cotainer_inner_dataExcel">
                                                    <table id="datatableGeneral"
                                                        class="table-stripe table-bordered table-sm display table table-hover"
                                                        style="min-width:100%">
                                                        <input type="file" id="archivo" name="archivo"
                                                            style="display: none;" accept=".xlsx, .csv">
                                                        <thead class="thead-primary thead-rounded-top">
                                                            <tr>
                                                                <th class="text-start">Programa</th>
                                                                <th class="text-center">Plan</th>
                                                                {{-- <th class="text-center">Tipos</th>
                                                                <th class="text-center">Modalidad</th>
                                                                <th class="text-center">Enfoque</th> --}}
                                                                <th class="text-center">Resolucion</th>
                                                                <th class="text-center">Fecha <br> Aprobación</th>
                                                                <th class="text-center">Acciones</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal -->
        <form class="needs-validation" id="formModal">
            @csrf
            <div id="modalCreateUpdate" class="modal fade" tabindex="-1" aria-labelledby="modalCreateUpdateLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-center modal-ls">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h1 class="modal-title fs-5" id="modalCreateUpdateLabel">Actualizar datos del Plan de
                                estudios</h1>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                        </div>
                        <div class="modal-body px-1 py-1">
                            <div class="row">
                                <div class="row col-xl-12 m-0">
                                    <!-- data -->
                                    <input type="hidden" id="txt-idplan" name="txt-idplan">
                                    <!-- data -->
                                    <div class="col-xl-12 col-lg-6 col-md-6 col-12 mb-3">
                                        <label class="col-sm-12 col-form-label text-primary">Programa</label>
                                        <select for="txt-program_id"
                                            class="default-select  form-control form-control-sm wide"
                                            id="txt-program_id" name="txt-program_id" required>
                                        </select>
                                    </div>
                                    <!-- data -->
                                    <input id="txt-id" name="txt-id" type="hidden">
                                    <!-- data -->
                                    <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                        <label for="txt-nombre" class="form-label text-primary">Nombre</label>
                                        <input id="txt-nombre" name="txt-nombre" type="number"
                                            class="form-control form-control-sm" required>
                                    </div>
                                    <!-- data -->
                                    <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                        <label for="txt-tipo" class="form-label text-primary">Tipo</label>
                                        <select class="default-select  form-control form-control-sm wide" id="txt-tipo"
                                            name="txt-tipo" required>
                                            <option value="" disabled selected>Seleccione opcion</option>
                                            <option value="Modular">Modular</option>
                                            <option value="Transversal">Transversal</option>
                                        </select>
                                    </div>
                                    <!-- data -->
                                    <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                        <label for="txt-modalidad" class="form-label text-primary">Modalidad</label>
                                        <select class="default-select  form-control form-control-sm wide"
                                            id="txt-modalidad" name="txt-modalidad" required>
                                            <option value="" disabled selected>Seleccione opcion</option>
                                            <option value="Presencial">Presencial</option>
                                            <option value="Semipresencial">Semipresencial</option>
                                        </select>
                                    </div>
                                    <!-- data -->
                                    <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                        <label for="txt-enfoque" class="form-label text-primary">Enfoque</label>
                                        <select class="default-select  form-control form-control-sm wide"
                                            id="txt-enfoque" name="txt-enfoque" required>
                                            <option selected value="" disabled>Seleccione opción</option>
                                            <option value="Presencial">Presencial</option>
                                            <option value="Dual">Dual</option>
                                            <option value="Alternancia">Alternancia</option>
                                        </select>
                                    </div>
                                    <!-- data -->
                                    <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                        <label for="txt-fecha" class="form-label text-primary">Fecha de
                                            Aprobación</label>
                                        <input id="txt-fecha" name="txt-fecha" type="date"
                                            class="form-control form-control-sm" required>
                                        @include('include.div.invalid-feedback')
                                    </div>
                                    <!-- data -->
                                    <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                        <label for="txt-documento" class="form-label text-primary">Documento de
                                            Resolución</label>
                                        <input id="txt-documento" name="txt-documento" type="file"
                                            class="form-control form-control-sm">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button id="btnCloseModal" type="button" class="btn btn-danger  btn-sm light"
                                data-bs-dismiss="modal">Cerrar</button>
                            <button id="btnCreateUpdate" type="button"
                                class="btn btn-primary btn-sm ">Guardar</button>
                        </div>
                    </div>
                </div>
            </div>
        </form>

        <!-- Modal -->
        <form id="formModal2" novalidate>
            @csrf
            <div id="modalDetalleCursos" class="modal fade" tabindex="-1" aria-labelledby="modalDetalleCursosLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-center modal-xl"> <!-- Cambiado de modal-lg a modal-xl -->
                    <div class="modal-content">
                        <div class="modal-header">
                            <h1 class="modal-title fs-5" id="modalDetalleCursosLabel">Detalle del Plan</h1>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                        </div>
                        <div class="modal-body pb-0">
                            <div class="row">
                                <!-- column datatable -->
                                <div class="col-xl-12">
                                    <div class="card mb-0" id="accordion-three">
                                        <!-- /tab-content -->
                                        <div class="tab-content" id="myTabContent-2">
                                            <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                                aria-labelledby="home-tab-2">
                                                <div class="card-body p-1">
                                                    <div class="table-responsive">
                                                        <table id="datatableGeneral2"
                                                            class="table table-hover table-bordered table-sm display rounded-3"
                                                            style="min-width:100%">
                                                            <thead class="thead-primary">
                                                                <tr>
                                                                    {{-- <th class="text-center">#</th> --}}
                                                                    <th class="text-center">Modulo Formativo</th>
                                                                    <th class="text-center">Periodo</th>
                                                                    <th class="text-center">curso</th>
                                                                    <th class="text-center">Tipo</th>
                                                                    <th class="text-center">créditos</th>
                                                                    <th class="text-center">Horas</th>
                                                                    <th class="text-center">Acción</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <!--  -->
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- /tab-content -->
                                    </div>
                                </div>
                                <!-- Column ends -->
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-danger btn-sm light"
                                data-bs-dismiss="modal">Cerrar</button>
                        </div>
                    </div>
                </div>
            </div>
        </form>

        <form id="formModal3" novalidate>
            @csrf
            <div id="modalEdithCourse" class="modal fade" tabindex="-1" aria-labelledby="modalEdithCourseLabel"
                aria-hidden="true" style="background: rgba(0, 0, 123, 0.523)">
                <div class="modal-dialog modal-dialog-center modal-md"> <!-- Cambiado de modal-lg a modal-xl -->
                    <div class="modal-content">
                        <div class="modal-header">
                            <h1 class="modal-title fs-5" id="modalEdithCourseLabel">Editar Datos del curso</h1>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                        </div>
                        <div class="modal-body pb-0">
                            <div class="row">
                                <input type="hidden" id="txt_idcourse" name="txt_idcourse" value="">
                                <!-- column datatable -->
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt_curso" class="form-label text-primary">
                                        Curso</label>
                                    <input id="txt_curso" name="txt_curso" type="text"
                                        class="form-control form-control-sm" autocomplete="off" required>
                                    @include('include.div.invalid-feedback')
                                </div>
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt_tipo_curso" class="form-label text-primary">
                                        Tipo Curso</label>
                                    <input id="txt_tipo_curso" name="txt_tipo_curso" type="text"
                                        class="form-control form-control-sm" autocomplete="off" required>
                                    @include('include.div.invalid-feedback')
                                </div>
                                <div class="col-xl-6 col-md-6 col-sm-12 col-12 mb-3">
                                    <label for="txt_creditos" class="form-label text-primary">N°
                                        Créditos</label>
                                    <input id="txt_creditos" name="txt_creditos" type="text"
                                        class="form-control form-control-sm" autocomplete="off" required>
                                    @include('include.div.invalid-feedback')
                                </div>
                                <div class="col-xl-6 col-md-6 col-sm-12 col-12 mb-3">
                                    <label for="txt_horas" class="form-label text-primary">N°
                                        Horas</label>
                                    <input id="txt_horas" name="txt_horas" type="text"
                                        class="form-control form-control-sm" autocomplete="off" required>
                                    @include('include.div.invalid-feedback')
                                </div>
                                <!-- Column ends -->
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-danger btn-sm light"
                                data-bs-dismiss="modal">Cerrar</button>
                            <button id="btnUpdateCurse" type="button"
                                class="btn btn-primary btn-sm ">Actualizar</button>
                        </div>
                    </div>
                </div>
            </div>
        </form>

        @include('include.footer')

    </div>

    @include('include.plugins-scripts')

    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>


    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>
    @vite(['resources/js/login/logout.js']);


    {{-- rowgroup --}}
    <script src="//cdn.rawgit.com/ashl1/datatables-rowsgroup/v1.0.0/dataTables.rowsGroup.js"></script>
    <script>
        function mostrarOcultarCombobox() {
            var tipoPlan = document.getElementById('txt-tipo').value;
            var modalidad = document.getElementById('txt-modalidad');
            var enfoque = document.getElementById('txt-enfoque');

            if (tipoPlan === 'Transversal') {
                modalidad.style.display = 'none'; // Ocultar el combobox de modalidad
                enfoque.style.display = 'none'; // Ocultar el combobox de enfoque
            } else {
                modalidad.style.display = 'block'; // Mostrar el combobox de modalidad
                enfoque.style.display = 'block'; // Mostrar el combobox de enfoque
            }
        }

        // Llama a esta función al cargar la página para establecer el estado inicial
        mostrarOcultarCombobox();
    </script>

    <!--  Page JS -->
    <script>
        var routeList = "{{ route('admin.planes_estudio.planes.list') }}";
        var route_ajax_cb_programas = "{{ route('ajax_all.programs') }}";
    </script>
    @vite(['resources/js/admin/planes_de_estudio/planes.js']);
    @vite(['resources/js/admin/planes_de_estudio/download_plantilla.js']);
    @vite(['resources/js/admin/planes_de_estudio/upload_plantilla.js']);

</body>

</html>
