<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Situación del Estudiante</title>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">
    {{--     --}}

</head>

<body>

    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')
        @section('titlenavbar')
            Situación del Estudiante
        @endsection

        @include('include.sidebar')


        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">

                            <!-- card -->
                            <div class="col-xl-3 col-lg-6 col-sm-6 col-12">
                                <div class="card">
                                    <div class="card-header border-1 bg-warning pb-2 pt-2 justify-content-center">
                                        <h2 class="card-title">Programas</h2>
                                    </div>
                                    <div class="card-body p-0">
                                        <div id="DZ_W_TimeLine" class="widget-timeline dlab-scroll height200 my-2 px-2">
                                            <ul id="tlprogram" class="timeline">
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- card -->
                            <div class="col-xl-3 col-lg-6 col-sm-6 col-12">
                                <div class="card border border-warning">
                                    <div
                                        class="card-header border-1 border-light bg-warning pt-2 pb-2 justify-content-center">
                                        <h2 class="card-title"><i class="fas fa-map"></i> Info. Programa</h2>
                                    </div>
                                    <div class="card-body pb-0 pt-3">
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item d-flex px-0 justify-content-between">
                                                <strong>Código</strong>
                                                <span id="txt-codprograma" class="mb-0">--</span>
                                            </li>
                                            <li class="list-group-item d-flex px-0 justify-content-between">
                                                <strong>Nombre</strong>
                                                <span id="txt-nombre" class="mb-0">--</span>
                                            </li>
                                            <li class="list-group-item d-flex px-0 justify-content-between">
                                                <strong>Nivel Formativo</strong>
                                                <span id="txt-nivel_formativo" class="mb-0">--</span>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>

                            <!-- card -->
                            <div class="col-xl-3 col-lg-6 col-sm-6 col-12">
                                <div class="card">
                                    <div class="card-header border-1 bg-info pb-2 pt-2 justify-content-center">
                                        <h2 class="card-title text-light">Planes</h2>
                                    </div>
                                    <div class="card-body p-0">
                                        <div id="DZ_W_TimeLine" class="widget-timeline dlab-scroll height200 my-2 px-2">
                                            <ul id="tlplan" class="timeline">
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- card -->
                            <div class="col-xl-3 col-lg-6 col-sm-6 col-12">
                                <div class="card border border-info">
                                    <div
                                        class="card-header border-1 border-light bg-info pt-2 pb-2 justify-content-center">
                                        <h2 class="card-title text-light"><i class="fas fa-folder"></i> Info. Plan</h2>
                                    </div>
                                    <div class="card-body pb-0 pt-3">
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item d-flex px-0 justify-content-between">
                                                <strong>Tipo: </strong>
                                                <span id="txt-tipo" class="mb-0">--</span>
                                            </li>
                                            <li class="list-group-item d-flex px-0 justify-content-between">
                                                <strong>Modalidad: </strong>
                                                <span id="txt-modalidad" class="mb-0">--</span>
                                            </li>
                                            <li class="list-group-item d-flex px-0 justify-content-between">
                                                <strong>Enfoque: </strong>
                                                <span id="txt-enfoque" class="mb-0">--</span>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>

                            <!-- Column starts -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <div class="card-header flex-wrap px-3">
                                        <div>
                                            <h4 class="card-title">Editar la situacion actual del estudiante</h4>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                    <div class="card-body p-0">
                                        <div role="toolbar" class="toolbar  bg">
                                            <div class="saprat">
                                                <div class="d-flex align-items-center">
                                                    <ul class="nav nav-pills  " id="pills-tab" role="tablist">
                                                        <!-- VISTA 1 -->
                                                        <li class="nav-item btn-group" role="presentation">
                                                            <button class="btn effect mx-2 nav-link active"
                                                                id="dt-estudiantes-tab" data-bs-toggle="pill"
                                                                data-bs-target="#dt-estudiantes" type="button"
                                                                role="tab" aria-controls="dt-estudiantes"
                                                                aria-selected="true">
                                                                <i class="fas fa-list-ul me-1"></i>
                                                                Estudiantes
                                                            </button>
                                                        </li>
                                                        <!-- VISTA 2 -->
                                                        <li class="nav-item btn-group" role="presentation"
                                                            id="modulemasive">
                                                            <button class="btn  mx-2 effect nav-link"
                                                                id="dt-egresados-tab" data-bs-toggle="pill"
                                                                data-bs-target="#dt-egresados" type="button"
                                                                role="tab" aria-controls="dt-egresados"
                                                                aria-selected="false">
                                                                <i class="fas fa-tags me-1"></i>
                                                                Egresados
                                                            </button>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="tab-content my-3" id="pills-tabContent">
                                            <!-- VISTA 1 -->
                                            <div class="tab-pane fade  show active px-3 mt-3" id="dt-estudiantes"
                                                role="tabpanel" aria-labelledby="dt-estudiantes-tab">
                                                <!-- /tab-content -->
                                                <div class="tab-content" id="myTabContent-2">
                                                    <div class="tab-pane fade show active" id="withoutSpace"
                                                        Aulae="tabpanel" aria-labelledby="home-tab-2">
                                                        <div class="table-responsive">
                                                            <table id="datatableGeneral_estudiantes"
                                                                class="table table-bordered table-sm display rounded-3"
                                                                style="min-width:100%">
                                                                <thead class="thead-primary">
                                                                    <tr>
                                                                        <th class="text-center">#</th>
                                                                        <th class="text-center">Identificación</th>
                                                                        <th class="text-center">Nombres y apellidos</th>
                                                                        <th class="text-center">Año ingreso</th>
                                                                        <th class="text-center">Estado Matricula</th>
                                                                        <th class="text-center">Acción</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <!--  -->
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- /tab-content -->
                                            </div>
                                            <!-- VISTA 2 -->
                                            <div class="tab-pane fade" id="dt-egresados" role="tabpanel"
                                                aria-labelledby="dt-egresados-tab">
                                                <!-- /tab-content -->
                                                <div class="tab-content" id="myTabContent-2">
                                                    <div class="tab-pane fade show active" id="withoutSpace"
                                                        Aulae="tabpanel" aria-labelledby="home-tab-2">
                                                        <div class="d-flex justify-content-center">
                                                            <button id="btnReporteEgresados" class="btn btn-primary" data-bs-placement="top" title="Ver Reporte">
                                                                Reporte de Egresados
                                                            </button>
                                                        </div>
                                                        <div class="table-responsive">
                                                            <table id="datatableGeneral_egresados"
                                                                class="table table-bordered table-sm display rounded-3"
                                                                style="min-width:100%">
                                                                <thead class="thead-primary">
                                                                    <tr>
                                                                        <th class="text-center">#</th>
                                                                        <th class="text-center">Identificación</th>
                                                                        <th class="text-center">Nombres y apellidos</th>
                                                                        <th class="text-center">Año ingreso</th>
                                                                        <th class="text-center">Estado Matricula</th>
                                                                        <th class="text-center">Acción</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <!--  -->
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- /tab-content -->
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="form-validation">
            <form id="formModal" novalidate>
                @csrf
                <div id="modalCreateUpdate" class="modal fade" tabindex="-1" aria-labelledby="modalCreateUpdateLabel" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-center modal-xl">
                        <div class="modal-content">
                            <!-- header -->
                            <div class="modal-header">
                                <h1 class="modal-title fs-5" id="modalCreateUpdateLabel">Registrar situación laboral actual
                                </h1>
                                <input type="hidden" id="name_plan_title" name="txt_name_plan_title" value"">
                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-label="Close"></button>
                            </div>
                            <!-- body -->
                            <div class="modal-body">
                                <div class="row">
                                    <div class="row col-xl-12">
                                        <!-- data -->
                                        <input id="txt_idstudent" name="txt_idstudent" type="hidden">
                                        <!-- data -->
                                        <div class="col-xl-4 col-md-6 col-sm-6 col-12 mb-3">
                                            <label for="txt_estadocivil"
                                                class="form-label text-primary">Estado civil</label>
                                            <select id="txt_estadocivil" name="txt_estadocivil"
                                                class="default-select form-control form-control-sm" required>
                                                <!-- combobox -->
                                                <option selected disabled value="">Seleccione opción</option>
                                                <option value="Soltero"> Soltero</option>
                                                <option value="Casado"> Casado</option>
                                                <option value="Viudo"> Viudo</option>
                                                <option value="Divorciado"> Divorciado</option>
                                            </select>
                                        </div>
                                        <div class="col-xl-4 col-md-6 col-sm-6 col-12 mb-3">
                                            <label for="txt_nrohijos" class="form-label text-primary">Número de hijos</label>
                                            <input id="txt_nrohijos" name="txt_nrohijos" type="number"
                                                class="form-control form-control-sm text-uppercase"
                                                placeholder="Número de hijos" required>
                                            @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                        </div>
                                        <!-- data -->
                                        <div class="col-xl-4 col-md-6 col-sm-6 col-12 mb-3">
                                            <label for="txt_ingresomensual" class="form-label text-primary">Ingreso mensual</label>
                                            <input id="txt_ingresomensual" name="txt_ingresomensual" type="number"
                                                placeholder="IngreseSO mensual"
                                                class="form-control form-control-sm text-uppercase" required>
                                            @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                        </div>
                                        <div class="col-xl-4 col-md-6 col-sm-6 col-12 mb-3">
                                            <label for="txt_ocupacion" class="form-label text-primary">Ocupación</label>
                                            <input id="txt_ocupacion" name="txt_ocupacion" type="text"
                                                placeholder="Ingrese ocupación"
                                                class="form-control form-control-sm text-uppercase" required>
                                            @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                        </div>

                                        <!-- data -->
                                        <div class="col-xl-4 col-md-6 col-sm-6 col-12 mb-3">
                                            <label for="txt_emopresas" class="form-label text-primary">Empresa</label>
                                            <input id="txt_emopresas" name="txt_emopresas" type="text"
                                                class="form-control form-control-sm text-uppercase"
                                                placeholder="Ingrese una empresa" required>
                                            @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                        </div>
                                        <!-- data -->
                                        <div class="col-xl-4 col-md-6 col-sm-6 col-12 mb-3">
                                            <label for="txt_tipovivienda" class="form-label text-primary">Tipo de vivienda</label>
                                            <input id="txt_tipovivienda" name="txt_tipovivienda" type="text"
                                                class="form-control form-control-sm text-uppercase"
                                                placeholder="Ingrese tipo de vivienda" required>
                                            @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                        </div>
                                        <!-- data -->
                                        <div class="col-xl-4 col-md-6 col-sm-6 col-12 mb-3">
                                            <label for="txt_gastosmensuales" class="form-label text-primary">Gastos mensuales</label>
                                            <input id="txt_gastosmensuales" name="txt_gastosmensuales" type="number"
                                                class="form-control form-control-sm text-uppercase"
                                                placeholder="Ingrese los gastos mensuales" required>
                                            @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                        </div>
                                        <!-- data -->
                                    </div>
                                </div>
                            </div>
                            <!-- footer -->
                            <div class="modal-footer">
                                <button type="button" class="btn btn-danger  btn-sm light"
                                    data-bs-dismiss="modal">Cerrar</button>
                                <button id="btnCreateUpdate" type="button"
                                    class="btn btn-primary btn-sm ">Guardar</button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
            <form id="formModal2" novalidate>
                @csrf
                <div id="modalUpdatePassword" class="modal fade" tabindex="-1"
                    aria-labelledby="modalUpdatePasswordLabel" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-center modal-xs">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h1 class="modal-title fs-5" id="modalUpdatePasswordLabel">Actualizar Contraseña</h1>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <div class="row">
                                    <div class="row col-xl-12">
                                        <!-- data -->
                                        <input id="txt_iduser2" name="txt_iduser2" type="hidden">
                                        <!-- data -->
                                        <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                            <label for="txt_nroidenti2" class="form-label text-primary">#
                                                Identificación</label>
                                            <input id="txt_nroidenti2" name="txt_nroidenti2" type="text"
                                                class="form-control form-control-sm" required>
                                            <div class="invalid-feedback">
                                                Requiere un numero de identificación
                                            </div>
                                        </div>
                                        <!-- data -->
                                        <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                            <label for="txt_apenom" class="form-label text-primary">Apellidos y
                                                Nombres</label>
                                            <input id="txt_apenom" name="txt_apenom" type="text"
                                                class="form-control form-control-sm" required>
                                            <div class="invalid-feedback">
                                                Requiere Ingresa un nombre.
                                            </div>
                                        </div>
                                        <!-- data -->
                                        <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                            <label for="txt_password2"
                                                class="form-label text-primary">Contraseña</label>
                                            <input id="txt_password2" name="txt_password2" type="password"
                                                class="form-control form-control-sm" placeholder="********" required>
                                            <div class="invalid-feedback">
                                                Ingrese una contraseña
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-danger  btn-sm light"
                                    data-bs-dismiss="modal">Cerrar</button>
                                <button id="btnUpdatePassword" type="button"
                                    class="btn btn-primary btn-sm ">Guardar</button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
            <div id="modalCargandoExcel" class="modal fade" tabindex="-1" aria-labelledby="modalCargandoExcel" aria-hidden="true" style="background: rgba(0,0,123,0.4)">
                <div class="modal-dialog modal-dialog-center modal-xl">
                    <div class="modal-content">
                        <!-- body -->
                        <div class="modal-body">
                            <div class="row">
                                <input type="hidden" value="0" id="hiddenswitch">
                                <div class="col-xl-12 text-primary mx-2">
                                    <h1 class="modal-title fs-5" id="id_preload_excel"></h1>
                                </div>
                                <div class="col-xl-12" id="div_progressbar_modal_preload">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div id="modalpreload" class="modal fade" tabindex="-1" aria-labelledby="modalCargandoExcel" aria-hidden="true" style="background: rgba(0,0,123,0.4)">
            <div class="modal-dialog modal-dialog-center modal-xl">
                <div class="modal-content">
                    <!-- body -->
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-xl-12 text-primary mx-2">
                                <h1 class="modal-title fs-5">GENERANDO REPORTE!<h1>
                            </div>
                            <div class="col-xl-12" id="div_progressbar_modal_preload">

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--**********************************
            Content body end
        ***********************************-->
        @include('include.footer')

    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->
    <!-- Modal -->
    <form id="formModal" novalidate>
        @csrf
    </form>

    <!--**********************************
        Scripts
    ***********************************-->

    @include('include.plugins-scripts')

    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>


    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>
    <script src="{{ asset('/js_Ajax_login/js_Script_Ajax_logout.js') }}"></script>


    <!--  Page JS -->
    <script src="{{ asset('js_Ajax_admin/situacion_estudiante.js') }}" type="module"></script>

</body>

</html>
