<!DOCTYPE html>
<html lang="en" class="h-100">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Mision, Vision, Valores</title>
    <link rel="icon" href="{{ asset('/images/institucion/logo-iestp.png') }} " type="image/x-icon">

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">
    <link href="{{ asset('/css/estilos.css') }}" rel="stylesheet">
    <script src="{{ asset('functions.js') }}" type="module"></script>

    <style>
        .boxvalores {
            background-color: white;
            box-shadow: 0 2px 10px rgba(128, 128, 128, 0.5);
            transition: background 0.3s ease, box-shadow 0.3s ease;
        }

        .boxvalores:hover {
            background: linear-gradient(135deg, #07105b 0%, #0d23ecd2 100%);
            box-shadow: 0 6px 20px #0d23ecd2;
        }



        .botonvalores {

            font-weight: 700;
        }

        .botonvalores:hover {
            background: linear-gradient(135deg, #e2e2e2 0%, #ffffff 100%);
            font-weight: 700;
        }






        .sidebar .nav-link {
            font-weight: 500;
            color: #000da0;
            padding: 10px;
            border: 1.5px solid rgba(128, 128, 128, 0.5);
            background-color: transparent;
            transition: background-color 0.3s ease-in-out, color 0.3s ease-in-out;
        }

        .sidebar .nav-link:hover {
            background: linear-gradient(135deg, #07105b 0%, #0d23ecd2 100%);
            /* Blue background on hover */
            color: white;
            /* White text on hover */
        }

        /* Estilos para las secciones */
        .shadow-none {
            border: 2px solid #a6a6a6;
        }

        /* Estilos para los valores */
        .card-title {
            font-size: 1.5rem;
            color: #06A3DA;
        }

        .modal-header {
            background-color: #ffffffe4;
        }

        .modal-body {
            background-color: transparent;
        }

        .seccimv {
            background: linear-gradient(135deg, #07105b 0%, #0d23ecd2 100%);
        }

        /* Ajustes de animación */
        .wow {
            visibility: visible;
            animation: fadeInUp 1s ease-in-out;
        }

        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }




        /*BENEFICIOS*/
        .card-circle {
            text-align: center;
            margin-top: 10px;
            background: white;
            border: 10px solid transparent;
            /* Eliminar el borde visible */
            color: #fff;
            font-family: Montserrat;
            padding: 15px;
            border-radius: 50%;
            transition: box-shadow 0.1s ease-in-out;
            /* Velocidad rápida para el box-shadow */
            /* Añadir transición para el efecto de hover */
        }

        .card-circle:hover {
            box-shadow: 0 0 0 5px #f57e57;
            /* Crear un borde interno con box-shadow */
        }

        .card-circle img {
            max-width: 100%;
            border-radius: 50%;
        }


        .texto-ventaja {
            color: white;
        }

        .ventajas {
            color: #EEF9FF;
        }

        h1,
        h2,
        .font-weight-bold {
            font-weight: 700 !important;
        }

        .section-title h5::before {
            position: absolute;
            content: "";
            width: 45px;
            height: 3px;
            right: -55px;
            bottom: 11px;
            background: #06A3DA !important;
        }

        .section-title h5::after {
            position: absolute;
            content: "";
            width: 15px;
            height: 3px;
            right: -75px;
            bottom: 11px;
            background: #f57e57;
        }

        /*FIN BENEFICIOS*/
    </style>
</head>

<body style="background-color: #ffffff">

    @include('navbar')

    <div class="container-fluid mt-5 mb-0">
        <div class="row">
            <div class="col-12 mx-0 px-0">
                <div style="height: 450px; overflow: hidden;">
                    <img src="../images/institucion/Nosotros2.jpg" alt="Acerca de Nosotros" class="img-fluid"
                        style="height: 100%; width: 100%; object-fit: cover;">
                </div>
                <h1 class="text-white text-center"
                    style="font-family: Arial, Helvetica, sans-serif; font-size: 49px; font-weight: 800; text-shadow: 1px 1px 13px rgb(0, 0, 0); position: relative; top: -240px;">
                    IDENTIDAD INSTITUCIONAL
                </h1>
            </div>
        </div>
    </div>


    <!-- Contenedor Principal -->
    <div class="container-fluid py-3 wow fadeInUp" data-wow-delay="0.1s">
        <div class="container py-5">

            <div class="row g-5">

                <!-- Barra lateral -->
                <div class="col-lg-3 col-md-3 wow slideInUp mt-4" data-wow-delay="0.9s">
                    <nav class="sidebar horacio">
                        <ul class="nav flex-column">
                            <li class="nav-item">
                                <a class="nav-link" href="#mision"><i class="fa-solid fa-angles-right"></i>
                                    Misión</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#vision"><i class="fa-solid fa-angles-right"></i>
                                    Visión</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#valores"><i class="fa-solid fa-angles-right"></i>
                                    Valores</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#benificios"><i class="fa-solid fa-angles-right"></i>
                                    Beneficios</a>
                            </li>
                        </ul>
                    </nav>
                </div>

                <!-- Contenido principal -->
                <div class="col-lg-9 col-md-9 wow slideInUp m-0" data-wow-delay="0.9s">

                    <br>

                    <!-- Sección Misión -->
                    <section id="mision">
                        <div class="shadow-none p-3 mb-3 rounded seccimv" style="border: 2px solid #a6a6a6;">
                            <h1 class="display-5 mb-0 text-white">
                                <i class="fa-solid fa-graduation-cap fa-fade"></i> Misión
                            </h1>
                            <p class="text-white">Somos un IEST, que contribuye con la formación de profesionales
                                técnicos...</p>
                        </div>
                    </section>

                    <!-- Sección Visión -->
                    <section id="vision">
                        <div class="shadow-none p-3 mb-3 rounded seccimv" style="border: 2px solid #a6a6a6;">
                            <h1 class="display-5 mb-0 text-white">
                                <i class="fa-solid fa-graduation-cap fa-fade"></i> Visión
                            </h1>
                            <p class="text-white">Ser una institución líder a nivel regional al 2025...</p>
                        </div>
                    </section>

                    <!-- Sección Valores -->
                    <section id="valores" class="my-5">
                        <h1 class="display-5 mb-4">Valores y Actitudes</h1>

                        <div class="container">
                            <div class="row justify-content-center">
                                <!-- Responsabilidad -->
                                <div class="col-sm-5 p-3 mb-5 mx-2 boxvalores">
                                    <div class="card rounded-3 text-center mb-0">
                                        <h5 class="card-title" style="color: #06A3DA;">Responsabilidad</h5>
                                        <p class="card-text">Asumir deberes y compromisos.</p>
                                        <img src="../../images/institucion/iconoResponsabilidad.png"
                                            alt="Icono de valores" class="img-fluid mb-2"
                                            style="width: 70px; height: 70px; margin-right: 6.9rem !important;
                                        margin-left: 6.9rem !important;">
                                        <button class="btn botonvalores" data-bs-toggle="modal"
                                            data-bs-target="#responsabilidadModal">Ver más</button>
                                    </div>
                                </div>

                                <!-- Integridad -->
                                <div class="col-sm-5 p-3 mb-5 boxvalores">
                                    <div class="card rounded-3 text-center mb-0">
                                        <h5 class="card-title" style="color: #06A3DA;">Integridad</h5>
                                        <p class="card-text">Actuar con rectitud y honestidad.</p>
                                        <img src="../../images/institucion/iconoIntegridad.png" alt="Icono de valores"
                                            class="img-fluid mb-2"
                                            style="width: 70px; height: 70px; margin-right: 6.9rem !important;
                                        margin-left: 6.9rem !important;">
                                        <button class="btn botonvalores" data-bs-toggle="modal"
                                            data-bs-target="#integridadModal">Ver
                                            más</button>
                                    </div>
                                </div>

                                <!-- Honestidad -->
                                <div class="col-sm-5 p-3 mb-5 mx-2 boxvalores">
                                    <div class="card rounded-3 text-center mb-0">
                                        <h5 class="card-title" style="color: #06A3DA;">Honestidad</h5>
                                        <p class="card-text">Ser sincero y transparente.</p>
                                        <img src="../../images/institucion/iconoHonestidad.png" alt="Icono de valores"
                                            class="img-fluid mb-2"
                                            style="width: 70px; height: 70px; margin-right: 6.9rem !important;
                                        margin-left: 6.9rem !important;">
                                        <button class="btn botonvalores" data-bs-toggle="modal"
                                            data-bs-target="#honestidadModal">Ver
                                            más</button>
                                    </div>
                                </div>

                                <!-- Emprendimiento -->
                                <div class="col-sm-5 p-3 mb-5 boxvalores">
                                    <div class="card rounded-3 text-center mb-0">
                                        <h5 class="card-title" style="color: #06A3DA;">Emprendimiento</h5>
                                        <p class="card-text">Iniciar proyectos con entusiasmo.</p>
                                        <img src="../../images/institucion/iconoEmprendimiento.png"
                                            alt="Icono de valores" class="img-fluid mb-2"
                                            style="width: 70px; height: 70px; margin-right: 6.9rem !important;
                                        margin-left: 6.9rem !important;">
                                        <button class="btn botonvalores" data-bs-toggle="modal"
                                            data-bs-target="#emprendimientoModal">Ver más</button>
                                    </div>
                                </div>

                                <!-- Respeto -->
                                <div class="col-sm-5 p-3 mb-5 mx-2 boxvalores">
                                    <div class="card rounded-3 text-center mb-0">
                                        <h5 class="card-title" style="color: #06A3DA;">Respeto</h5>
                                        <p class="card-text">Tratar a los demás con dignidad.</p>
                                        <img src="../../images/institucion/iconoRespeto.png" alt="Icono de valores"
                                            class="img-fluid mb-2"
                                            style="width: 70px; height: 70px; margin-right: 6.9rem !important;
                                        margin-left: 6.9rem !important;">
                                        <button class="btn botonvalores" data-bs-toggle="modal"
                                            data-bs-target="#respetoModal">Ver
                                            más</button>
                                    </div>
                                </div>

                                <!-- Confianza -->
                                <div class="col-sm-5 p-3 mb-5 boxvalores">
                                    <div class="card rounded-3 text-center mb-0">
                                        <h5 class="card-title" style="color: #06A3DA;">Confianza</h5>
                                        <p class="card-text">Generar seguridad en los demás.</p>
                                        <img src="../../images/institucion/iconoConfianza.png" alt="Icono de valores"
                                            class="img-fluid mb-2"
                                            style="width: 70px; height: 70px; margin-right: 6.9rem !important;
                                        margin-left: 6.9rem !important;">
                                        <button class="btn botonvalores" data-bs-toggle="modal"
                                            data-bs-target="#confianzaModal">Ver más</button>
                                    </div>
                                </div>

                                <!-- Puntualidad -->
                                <div class="col-sm-5 p-3 mb-5 mx-2 boxvalores">
                                    <div class="card rounded-3 text-center mb-0">
                                        <h5 class="card-title" style="color: #06A3DA;">Puntualidad</h5>
                                        <p class="card-text">Cumplir con el tiempo establecido.</p>
                                        <img src="../../images/institucion/iconoPuntualidad.png"
                                            alt="Icono de valores" class="img-fluid mb-2"
                                            style="width: 70px; height: 70px; margin-right: 6.9rem !important;
                                        margin-left: 6.9rem !important;">
                                        <button class="btn botonvalores" data-bs-toggle="modal"
                                            data-bs-target="#puntualidadModal">Ver más</button>
                                    </div>
                                </div>

                                <!-- Solidaridad -->
                                <div class="col-sm-5 p-3 mb-5 boxvalores">
                                    <div class="card rounded-3 text-center mb-0">
                                        <h5 class="card-title" style="color: #06A3DA;">Solidaridad</h5>
                                        <p class="card-text">Apoyar al prójimo sin condición.</p>
                                        <img src="../../images/institucion/iconoSolidaridad.png"
                                            alt="Icono de valores" class="img-fluid mb-2"
                                            style="width: 70px; height: 70px; margin-right: 6.9rem !important;
                                        margin-left: 6.9rem !important;">
                                        <button class="btn botonvalores" data-bs-toggle="modal"
                                            data-bs-target="#solidaridadModal">Ver más</button>
                                    </div>
                                </div>



                            </div>
                        </div>

                    </section>


                </div>
            </div>
        </div>
    </div>

    <!-- Modales -->
    <!-- Responsabilidad Modal -->
    <div class="modal fade" id="responsabilidadModal" tabindex="-1" aria-labelledby="responsabilidadLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="responsabilidadLabel">
                        <i class="fa-solid fa-check-circle" style="margin-right: 5px;"></i>
                        Responsabilidad
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    Asumir deberes, compromisos y reconocer las consecuencias de sus actos.
                </div>
            </div>
        </div>
    </div>

    <!-- Integridad Modal -->
    <div class="modal fade" id="integridadModal" tabindex="-1" aria-labelledby="integridadLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="integridadLabel">
                        <i class="fa-solid fa-shield-alt" style="margin-right: 5px;"></i>
                        Integridad
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    Actuar con rectitud, ética y honestidad en todo momento.
                </div>
            </div>
        </div>
    </div>

    <!-- Honestidad Modal -->
    <div class="modal fade" id="honestidadModal" tabindex="-1" aria-labelledby="honestidadLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="honestidadLabel">
                        <i class="fa-solid fa-user-check" style="margin-right: 5px;"></i>
                        Honestidad
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    Ser sincero y transparente en todas las acciones.
                </div>
            </div>
        </div>
    </div>

    <!-- Emprendimiento Modal -->
    <div class="modal fade" id="emprendimientoModal" tabindex="-1" aria-labelledby="emprendimientoLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="emprendimientoLabel">
                        <i class="fa-solid fa-lightbulb" style="margin-right: 5px;"></i>
                        Emprendimiento
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    Iniciar y desarrollar proyectos innovadores con entusiasmo.
                </div>
            </div>
        </div>
    </div>

    <!-- Respeto Modal -->
    <div class="modal fade" id="respetoModal" tabindex="-1" aria-labelledby="respetoLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="respetoLabel">
                        <i class="fa-solid fa-hands" style="margin-right: 5px;"></i>
                        Respeto
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    Tratar a los demás con dignidad, comprensión y cortesía.
                </div>
            </div>
        </div>
    </div>

    <!-- Confianza Modal -->
    <div class="modal fade" id="confianzaModal" tabindex="-1" aria-labelledby="confianzaLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="confianzaLabel">
                        <i class="fa-solid fa-lock" style="margin-right: 5px;"></i>
                        Confianza
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    Generar seguridad y credibilidad en todas las interacciones.
                </div>
            </div>
        </div>
    </div>

    <!-- Puntualidad Modal -->
    <div class="modal fade" id="puntualidadModal" tabindex="-1" aria-labelledby="puntualidadLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="puntualidadLabel">
                        <i class="fa-solid fa-clock" style="margin-right: 5px;"></i>
                        Puntualidad
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    Cumplir con los tiempos y compromisos establecidos.
                </div>
            </div>
        </div>
    </div>

    <!-- Solidaridad Modal -->
    <div class="modal fade" id="solidaridadModal" tabindex="-1" aria-labelledby="solidaridadLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="solidaridadLabel">
                        <i class="fa-solid fa-hands-helping" style="margin-right: 5px;"></i>
                        Solidaridad
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    Apoyo y colaboración sin esperar recompensas.
                </div>
            </div>
        </div>
    </div>




    <section id="benificios">
        <div class="container-fluid bg-appointment my-0 wow fadeInUp" data-wow-delay="0.1s"
            style="visibility: visible; animation-delay: 0.1s; animation-name: fadeInUp; background: linear-gradient(135deg, #07105b 0%, #0d23ecd2 100%);">
            <div class="container">
                <div class="row gx-5">
                    <div class="col-lg-12 py-5">
                        <div class="py-5">

                            <div class="section-title mb-4">
                                <h5 class="position-relative d-inline-block text-uppercase"
                                    style="color: #06A3DA !important;">¿POR QUÉ ESTUDIAR
                                    EN</h5>
                                <h1 class="display-5 mb-0 ventajas"> IESTP "CATALINA BUENDÍA DE PECHO"?</h1>
                            </div>


                            <div class="row">

                                <div
                                    class="col-md-3 col-lg-3 col-xxl-3  d-flex justify-content-center align-items-center">
                                    <div class="services">
                                        <div class="icon d-flex align-items-center justify-content-center">
                                            <div class="card card-circle text-center"
                                                style="background-color: white; border-radius: 50%;">
                                                <img src="../../images/institucion/porqueestudiar1.png"
                                                    class="rounded-0 imagen-ventaja" alt="...">
                                            </div>
                                        </div>
                                        <div class="text media-body text-center">
                                            <p class="texto-ventaja">Título Profesional Técnico
                                            </p>

                                        </div>
                                    </div>
                                </div>

                                <div
                                    class="col-md-3 col-lg-3 col-xxl-3  d-flex justify-content-center align-items-center">
                                    <div class="services">
                                        <div class="icon d-flex align-items-center justify-content-center">
                                            <div class="card card-circle text-center"
                                                style="background-color: white; border-radius: 50%;">
                                                <img src="../../images/institucion/porqueestudiar2.png"
                                                    class="rounded-0 imagen-ventaja" alt="...">
                                            </div>
                                        </div>
                                        <div class="text media-body text-center">
                                            <p class="texto-ventaja">Docentes ampliamente calificados</p>

                                        </div>
                                    </div>
                                </div>

                                <div
                                    class="col-md-3 col-lg-3 col-xxl-3  d-flex justify-content-center align-items-center">
                                    <div class="services">
                                        <div class="icon d-flex align-items-center justify-content-center">
                                            <div class="card card-circle text-center"
                                                style="background-color: white; border-radius: 50%;">
                                                <img src="../../images/institucion/porqueestudiar3.png"
                                                    class="rounded-0 imagen-ventaja" alt="...">
                                            </div>
                                        </div>
                                        <div class="text media-body text-center">
                                            <p class="texto-ventaja">Laboratorios equipados y modernos</p>

                                        </div>
                                    </div>
                                </div>

                                <div
                                    class="col-md-3 col-lg-3 col-xxl-3  d-flex justify-content-center align-items-center">
                                    <div class="services">
                                        <div class="icon d-flex align-items-center justify-content-center">
                                            <div class="card card-circle text-center"
                                                style="background-color: white; border-radius: 50%;">
                                                <img src="../../images/institucion/porqueestudiar4.png"
                                                    class="rounded-0 imagen-ventaja" alt="...">
                                            </div>
                                        </div>
                                        <div class="text media-body text-center">
                                            <p class="texto-ventaja">Bolsa de Trabajo Exclusiva</p>

                                        </div>
                                    </div>
                                </div>

                                <div
                                    class="col-md-3 col-lg-3 col-xxl-3  d-flex justify-content-center align-items-center">
                                    <div class="services">
                                        <div class="icon d-flex align-items-center justify-content-center">
                                            <div class="card card-circle text-center"
                                                style="background-color: white; border-radius: 50%;">
                                                <img src="../../images/institucion/porqueestudiar5.png"
                                                    class="rounded-0 imagen-ventaja" alt="...">
                                            </div>
                                        </div>
                                        <div class="text media-body text-center">
                                            <p class="texto-ventaja">Certificación Modular Progresiva </p>

                                        </div>
                                    </div>
                                </div>

                                <div
                                    class="col-md-3 col-lg-3 col-xxl-3  d-flex justify-content-center align-items-center">
                                    <div class="services">
                                        <div class="icon d-flex align-items-center justify-content-center">
                                            <div class="card card-circle text-center"
                                                style="background-color: white; border-radius: 50%;">
                                                <img src="../../images/institucion/porqueestudiar6.png"
                                                    class="rounded-0 imagen-ventaja" alt="...">
                                            </div>
                                        </div>
                                        <div class="text media-body text-center">
                                            <p class="texto-ventaja">Experiencias Formativas Reales</p>

                                        </div>
                                    </div>
                                </div>

                                <div
                                    class="col-md-3 col-lg-3 col-xxl-3  d-flex justify-content-center align-items-center">
                                    <div class="services">
                                        <div class="icon d-flex align-items-center justify-content-center">
                                            <div class="card card-circle text-center"
                                                style="background-color: white; border-radius: 50%;">
                                                <img src="../../images/institucion/porqueestudiar7.png"
                                                    class="rounded-0 imagen-ventaja" alt="...">
                                            </div>
                                        </div>
                                        <div class="text media-body text-center">
                                            <p class="texto-ventaja">Formación para la empleabilidad y
                                                emprendimiento </p>

                                        </div>
                                    </div>
                                </div>


                                <div
                                    class="col-md-3 col-lg-3 col-xxl-3  d-flex justify-content-center align-items-center">
                                    <div class="services">
                                        <div class="icon d-flex align-items-center justify-content-center">
                                            <div class="card card-circle text-center"
                                                style="background-color: white; border-radius: 50%;">
                                                <img src="../../images/institucion/porqueestudiar8.png"
                                                    class="rounded-0 imagen-ventaja" alt="...">
                                            </div>
                                        </div>
                                        <div class="text media-body text-center">
                                            <p class="texto-ventaja">Talleres complementarios: inglés e
                                                informática
                                            </p>

                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </section>




















    @include('footer')
    @include('include.plugins-scripts')

    <!-- JavaScript to handle modal content -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#valorModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget); // Botón que activó el modal
                var valorNombre = button.data('valor'); // Extraer información de los atributos data-*
                var valorIcon = button.data('icon');
                var valorDescripcion = button.data('descripcion');

                var modal = $(this);
                modal.find('#valorNombre').text(valorNombre);
                modal.find('#valorDescripcion').text(valorDescripcion);
                modal.find('#valorIcon').attr('class', valorIcon);
            });
        });
    </script>
</body>

</html>
