<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Bolsa Laboral - Empresas</title>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">
    {{--     --}}

</head>

<body>

    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')
        @section('titlenavbar')
            Bolsa Laboral - Empresas
        @endsection

        @include('include.sidebar')


        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">
                            <!-- Column starts -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <div role="toolbar" class="toolbar  bg">
                                        <div class="saprat">
                                            <div class="d-flex align-items-center">
                                                <ul class="nav nav-pills  " id="pills-tab" role="tablist">
                                                    <li class="nav-item btn-group" role="presentation">
                                                        <button class="btn effect mx-2 nav-link active"
                                                            id="pills-home-tab" data-bs-toggle="pill"
                                                            data-bs-target="#pills-home" type="button" role="tab"
                                                            aria-controls="pills-home" aria-selected="true">
                                                            <svg xmlns="http://www.w3.org/2000/svg" height="1em"
                                                                viewBox="0 0 448 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. -->
                                                                <path
                                                                    d="M219.3 .5c3.1-.6 6.3-.6 9.4 0l200 40C439.9 42.7 448 52.6 448 64s-8.1 21.3-19.3 23.5L352 102.9V160c0 70.7-57.3 128-128 128s-128-57.3-128-128V102.9L48 93.3v65.1l15.7 78.4c.9 4.7-.3 9.6-3.3 13.3s-7.6 5.9-12.4 5.9H16c-4.8 0-9.3-2.1-12.4-5.9s-4.3-8.6-3.3-13.3L16 158.4V86.6C6.5 83.3 0 74.3 0 64C0 52.6 8.1 42.7 19.3 40.5l200-40zM111.9 327.7c10.5-3.4 21.8 .4 29.4 8.5l71 75.5c6.3 6.7 17 6.7 23.3 0l71-75.5c7.6-8.1 18.9-11.9 29.4-8.5C401 348.6 448 409.4 448 481.3c0 17-13.8 30.7-30.7 30.7H30.7C13.8 512 0 498.2 0 481.3c0-71.9 47-132.7 111.9-153.6z" />
                                                            </svg>
                                                            Empresas
                                                        </button>
                                                    </li>
                                                    <li class="nav-item btn-group" role="presentation"
                                                        id="modulemasive">
                                                        <button class="btn  mx-2 effect nav-link" id="pills-profile-tab"
                                                            data-bs-toggle="pill" data-bs-target="#pills-profile"
                                                            type="button" role="tab" aria-controls="pills-profile"
                                                            aria-selected="false">
                                                            <svg xmlns="http://www.w3.org/2000/svg" height="1em"
                                                                viewBox="0 0 640 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. -->
                                                                <path
                                                                    d="M144 480C64.5 480 0 415.5 0 336c0-62.8 40.2-116.2 96.2-135.9c-.1-2.7-.2-5.4-.2-8.1c0-88.4 71.6-160 160-160c59.3 0 111 32.2 138.7 80.2C409.9 102 428.3 96 448 96c53 0 96 43 96 96c0 12.2-2.3 23.8-6.4 34.6C596 238.4 640 290.1 640 352c0 70.7-57.3 128-128 128H144zm79-217c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l39-39V392c0 13.3 10.7 24 24 24s24-10.7 24-24V257.9l39 39c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-80-80c-9.4-9.4-24.6-9.4-33.9 0l-80 80z" />
                                                            </svg>
                                                            Solicitudes
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="tab-content my-0" id="pills-tabContent">
                                        <div class="tab-pane fade show active px-3 mt-3" id="pills-home" role="tabpanel"
                                            aria-labelledby="pills-home-tab">
                                            <div class="card-header flex-wrap p-2">
                                                <div>
                                                    <h4 class="card-title">Registro de empresas para la Bolsa Laboral
                                                    </h4>
                                                </div>
                                                <button id="btnCreateModal" type="button"
                                                    class="btn btn-primary btn-sm" data-bs-toggle="modal"
                                                    data-bs-target="#modalCreateUpdate">
                                                    + Nueva Empresa
                                                </button>
                                            </div>
                                            <div class="card-body p-2">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral"
                                                        class="table table-hover table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">#</th>
                                                                <th class="text-center">RUC</th>
                                                                <th class="text-center">Nombre</th>
                                                                <th class="text-center">Nro. Contacto</th>
                                                                <th class="text-center">Correo</th>
                                                                <th class="text-center">Dirección</th>
                                                                <th class="text-center">Estado</th>
                                                                <th class="text-center">Acciones</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="tab-pane fade px-3 mt-3" id="pills-profile" role="tabpanel"
                                            aria-labelledby="pills-profile-tab">
                                            <div class="card-header flex-wrap p-2">
                                                <div>
                                                    <h4 class="card-title">Solicitudes de Empresas para bolsa laboral
                                                    </h4>
                                                </div>
                                            </div>
                                            <div class="card-body p-2">
                                                <div class="table-responsive">
                                                    <table id="datatableSolicitud"
                                                        class="table table-hover table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">#</th>
                                                                <th class="text-center">RUC</th>
                                                                <th class="text-center">Nombre</th>
                                                                <th class="text-center">Nro. Contacto</th>
                                                                <th class="text-center">Correo</th>
                                                                <th class="text-center">Dirección</th>
                                                                <th class="text-center">Estado</th>
                                                                <th class="text-center">Acciones</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--**********************************
            Content body end
        ***********************************-->
        @include('include.footer')

    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->

    <!-- Modal -->
    <form id="formModal" novalidate>
        @csrf
        <div id="modalCreateUpdate" class="modal fade" tabindex="-1" aria-labelledby="modalCreateUpdateLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-lg">
                <div class="modal-content">
                    <!-- header -->
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalCreateUpdateLabel">Registrar nueva empresa</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <!-- body -->
                    <div class="modal-body">
                        <div class="row">
                            <div class="row col-xl-12">
                                <!-- data -->
                                <input id="txt-idcompany" name="txt-idcompany" type="hidden">
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-ruc" class="form-label text-primary">RUC</label>
                                    <div class="input-group">
                                        <input class="form-control form-control-sm" id="txt-ruc" name="txt-ruc"
                                            placeholder="Ingrese RUC" autocomplete="off"
                                            onkeypress='return event.charCode >= 48 && event.charCode <= 57'
                                            maxlength="11" type="text" required>
                                        {{-- mensaje de error campo vacio --}}
                                        <button class="btn btn-primary btn-sm" type="button" id="btn-querydata"><i
                                                class="fa-solid fa-magnifying-glass fa-beat-fade"></i>
                                            Validar
                                        </button>
                                        @include('include.div.invalid-feedback')
                                    </div>
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-nombre" class="form-label text-primary">Nombre</label>
                                    <input id="txt-nombre" name="txt-nombre" type="text"
                                        class="form-control form-control-sm" placeholder="Ingrese nombre" required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-nrocontacto" class="form-label text-primary">Nro. de
                                        Contacto</label>
                                    <input id="txt-nrocontacto" name="txt-nrocontacto" type="text"
                                        class="form-control form-control-sm" autocomplete="off"
                                        onkeypress='return event.charCode >= 48 && event.charCode <= 57'
                                        maxlength="9" placeholder="Ingrese celular o teléfono" required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-correo" class="form-label text-primary">Correo</label>
                                    <input id="txt-correo" name="txt-correo" type="text"
                                        class="form-control form-control-sm" placeholder="Ingrese correo" required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-direccion" class="form-label text-primary">Dirección</label>
                                    <input id="txt-direccion" name="txt-direccion" type="text"
                                        class="form-control form-control-sm" placeholder="Ingrese direccion" required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-activo" class="form-label text-primary">Activo</label>
                                    <select id="txt-activo" name="txt-activo"
                                        class="default-select form-control form-control-sm" required>
                                        <!-- combobox -->
                                        @include('include.combobox.bit') {{-- mensaje de error campo vacio --}}
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-user" class="form-label text-primary">Nombre de usuario</label>
                                    <input id="txt-user" name="txt-user" type="text"
                                        class="form-control form-control-sm" placeholder="Ingrese nombre de usuario"
                                        required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div id="div-txt-password" class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-password" class="form-label text-primary">Contraseña</label>
                                    <input id="txt-password" name="txt-password" type="password"
                                        class="form-control form-control-sm" placeholder="********" required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnCreateUpdate" type="button" class="btn btn-primary btn-sm ">Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>


    <form id="formModal2" novalidate>
        @csrf
        <div id="modalUpdatePassword" class="modal fade" tabindex="-1" aria-labelledby="modalUpdatePasswordLabel"
            aria-labelledby="modalUpdatePasswordLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-xs">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalUpdatePasswordLabel">Actualizar Contraseña</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="row col-xl-12">
                                <!-- data -->
                                <input id="txt_idcompany2" name="txt_idcompany2" type="hidden">
                                <!-- data -->
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt_ruc2" class="form-label text-primary"># RUC</label>
                                    <input id="txt_ruc2" name="txt_ruc2" type="text"
                                        class="form-control form-control-sm" required readonly>
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt_nombre2" class="form-label text-primary">Apellidos y
                                        Nombres</label>
                                    <input id="txt_nombre2" name="txt_nombre2" type="text"
                                        class="form-control form-control-sm" required readonly>
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt_password2" class="form-label text-primary">Contraseña</label>
                                    <input id="txt_password2" name="txt_password2" type="password"
                                        class="form-control form-control-sm" placeholder="********" required>
                                    <div class="invalid-feedback"> Ingrese una contraseña</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnUpdatePassword" type="button"
                            class="btn btn-primary btn-sm ">Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <!--**********************************
        Scripts
    ***********************************-->

    @include('include.plugins-scripts')

    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>


    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>
    @vite(['resources/js/login/logout.js']);

    <!--  Page JS -->
    @vite(['resources/js/admin/bolsa_laboral/empresas.js']);
</body>

</html>
