<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Categorias y Tags</title>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">
    {{--     --}}

</head>

<body>

    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')
        @section('titlenavbar')
            Categorías de las Ofertas Laborales
        @endsection

        @include('include.sidebar')


        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">
                            <!-- Column starts -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <div class="card-header flex-wrap px-3">
                                        <div>
                                            <h4 class="card-title">Registro de Categorías</h4>
                                        </div>
                                        <button id="btnCreateModal" type="button" class="btn btn-primary btn-sm"
                                            data-bs-toggle="modal" data-bs-target="#modalCreateUpdate">
                                            + Nueva Categoría
                                        </button>
                                    </div>
                                    <!-- /tab-content -->
                                    <div class="card-body p-0">
                                        <div class="tab-content my-3" id="pills-tabContent">
                                            <!-- VISTA 1 -->
                                            <div class="tab-pane fade  show active px-3 mt-3" id="dt-categorias"
                                                role="tabpanel" aria-labelledby="dt-categorias-tab">
                                                <!-- /tab-content -->
                                                <div class="tab-content" id="myTabContent-2">
                                                    <div class="tab-pane fade show active" id="withoutSpace"
                                                        Aulae="tabpanel" aria-labelledby="home-tab-2">
                                                        <div class="table-responsive">
                                                            <table id="datatableGeneral_categorias"
                                                                class="table table-bordered table-sm display rounded-3"
                                                                style="min-width:100%">
                                                                <thead class="thead-primary">
                                                                    <tr>
                                                                        <th class="text-center">#</th>
                                                                        <th class="text-center">Categoria</th>
                                                                        <th class="text-center">Acciones</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <!--  -->
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- /tab-content -->
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--**********************************
            Content body end
        ***********************************-->
        @include('include.footer')

    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->

    <!-- Modal -->
    <form id="formModal" novalidate>
        @csrf
        <div id="modalCreateUpdate" class="modal fade" tabindex="-1" aria-labelledby="modalCreateUpdateLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-sm">
                <div class="modal-content">
                    <!-- header -->
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalCreateUpdateLabel">Registrar nueva categoria</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <!-- body -->
                    <div class="modal-body">
                        <div class="row">
                            <div class="row col-xl-12">
                                <!-- data -->
                                <input id="txt-idcategory" name="txt-idcategory" type="hidden">
                                <input id="txt-idtag" name="txt-idtag" type="hidden">
                                <!-- data -->
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt-nombre" class="form-label text-primary">Nombre</label>
                                    <input id="txt-nombre" name="txt-nombre" type="text"
                                        class="form-control form-control-sm" placeholder="Ingrese nombre" required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnCreateUpdate" type="button" class="btn btn-primary btn-sm"
                            value="Create_Categoria">Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>


    <!--**********************************
        Scripts
    ***********************************-->

    @include('include.plugins-scripts')

    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>


    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>
    <script src="{{ asset('/js_Ajax_login/js_Script_Ajax_logout.js') }}"></script>


    <!--  Page JS -->
    <script src="{{ asset('js_Ajax_admin/categorias_etiquetas.js') }}" type="module"></script>

</body>

</html>
