import { notificaciontoast } from "../common/method_toast.js";

const btnsChangeLoginType = document.querySelectorAll(".btnChangeLoginType");
btnsChangeLoginType.forEach((btnChangeLoginType) => {
    btnChangeLoginType.addEventListener("click", (event) => {
        const loginType = event.currentTarget.dataset.type;
        changeLoginType(loginType);
    });
});

function changeLoginType(loginType) {
    $.ajax({
        headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
        type: "POST",
        url: `/changeLoginType/${loginType}`,
        processData: false,
        contentType: false,
        beforeSend: function () {},
        success: function (data) {
            if (data.status == true) {
                notificaciontoast("info", data.message, "Éxito!", "top-right");
                setTimeout(function () {
                    window.location = data.redirect;
                }, 1150);
            } else {
                notificaciontoast("error", data.message, "Error!");
                setTimeout(function () {
                    window.location = data.redirect;
                }, 1150);
            }
        },
        error: function (error) {
            console.log("Error", error);
        },
    });
}
