import { notificaciontoast } from "../common/method_toast.js";
import { confirmation_sweetAlert } from "../common/method_sweetAlert.js";

$(document).ready(function () {

    const tableName = "Ofertas Laborales";

    // LISTAR DATATABLE
    var table = $('#datatableGeneral').DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'POST',
            url: '/empresa/ofertas_laborales/list',
        },
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: {
            search: 'Buscar',
            info: 'Mostrando _START_ a _END_ de _TOTAL_ Registros',
            zeroRecords: 'No hay registros para mostrar.',
            infoFiltered: '(Filtrados de _MAX_ Registros)',
            emptyTable: 'La tabla está vacia.',
            infoEmpty: 'No hay registros',
            paginate: {
                next: '<i class="fa-solid fa-angle-right"></i>',
                previous: '<i class="fa-solid fa-angle-left"></i>'
            }
        },
        buttons: [
            {
                extend: "excel",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    columns: ":not(.noExport)",
                    orthogonal: "print"
                },
            },
            {
                extend: "pdf",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded ",
                exportOptions: {
                    columns: ":visible",
                    columns: ":not(.noExport)",
                    orthogonal: "print"
                },
            },
            {
                extend: "print",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    columns: ":not(.noExport)",
                    orthogonal: "print"
                },
            },
            {
                extend: "colvis",
                text: "Seleccionar celdas",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    columns: ":not(.noExport)",
                    orthogonal: "print"
                },
            },
        ],
        columns: [
            { data: 'idjob', className: 'text-center' },
            { data: 'nombrecategory', className: 'text-center' },
            { data: 'puesto', className: 'text-center' },
            { data: 'vacantes', className: 'text-center' },
            {
                data: "documento", className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.documento == null) {
                        return "--";
                    } else if (all.documento == "--") {
                        return `
                        <div class="d-flex justify-content-center">
                            --
                        `;
                    } else {
                        return `
                        <div class="d-flex justify-content-center">
                            <a href="/verTrabajoDocumento/${all.idjob}" class="btn btn-info shadow btn-xs sharp me-1"
                                target="_blank"
                                data-bs-placement="top"
                                title="Ver Doc. Oferta de Trabajo">
                                <i class="fas fa-file-lines fa-lg"></i>
                            </a>
                        </div>
                        `;
                    }
                },
            },
            {
                data: "fechas", className: "text-center",
                render: function (data, type, all, meta) {
                    return all.fecpublicacion + " - " + all.feccierre;
                },
            },
            {
                data: "rango_salarial", className: "text-center",
                render: function (data, type, all, meta) {
                    return all.salariomin + " - " + all.salariomax;
                },
            },
            {
                data: "estado_actual", className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.estado_actual == "1") {
                        return `<span class="badge light badge-success">Activo</span>`;
                    } else {
                        return `<span class="badge light badge-danger">Inactivo</span>`;
                    }
                },
            },
            {
                data: "idjob", className: "text-center noExport", sortable: false, searchable: false,
                render: function (data, type, all, meta) {
                    return `
                            <div class="d-flex justify-content-center">

                                <a href="javascript:void(0);" class="editBtn btn btn-dark shadow btn-xs sharp me-1"
                                data-idjob="${all.idjob}"
                                data-puesto="${all.puesto}"
                                data-vacantes="${all.vacantes}"
                                data-tipo="${all.tipo}"
                                data-modalidad="${all.modalidad}"
                                data-experiencia="${all.experiencia}"
                                data-fecpublicacion="${all.fecpublicacion}"
                                data-feccierre="${all.feccierre}"
                                data-salariomin="${all.salariomin}"
                                data-salariomax="${all.salariomax}"
                                data-nivel_educativo="${all.nivel_educativo}"
                                data-descripcion="${all.descripcion}"
                                data-estado_actual="${all.estado_actual}"
                                data-idcompany="${all.idcompany}"
                                data-nombrecompany="${all.nombrecompany}"
                                data-idcategory="${all.idcategory}"
                                data-nombrecategory="${all.nombrecategory}"
                                data-ubigeo_id="${all.idubigeo}"
                                data-iddepartamento="${all.iddepartamento}"
                                data-departamento="${all.departamento}"
                                data-idprovincia="${all.idprovincia}"
                                data-provincia="${all.provincia}"
                                data-iddistrito="${all.iddistrito}"
                                data-distrito="${all.distrito}"
                                data-bs-placement="top"
                                title="Editar registro">
                                <i class="fas fa-pencil-alt"></i>
                                </a>

                                <a href="javascript:void(0);" class="deleteBtn btn btn-dark shadow btn-xs sharp"
                                data-idjob="${all.idjob}"
                                data-bs-placement="top"
                                title="Eliminar registro">
                                <i class="fas fa-trash"></i>
                                </a>

                            </div>
                        `;
                },
            },
        ]
    });

    // Agregar una columna de números automáticos
    table.on('order.dt search.dt', function () {
        table.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
            cell.innerHTML = i + 1;
        });
    }).draw();

    var valbtn, formCheck, formModal;

    // INICIO - MODAL CREATE
    $("#btnCreateModal").click(function () {
        // change value
        $("#btnCreateUpdate").attr("value", "Create");
        $("#btnCreateUpdate").html("Registrar");
        $("#modalCreateUpdateLabel").html("Registrar datos de la oferta laboral");
        clearCheck();
        clearForm();
    });
    // FIN - MODAL CREATE


    // INICIO - MODAL UPDATE
    $("#datatableGeneral tbody").on("click", ".editBtn", function (e) {
        clearCheck();   // borrar validaciones
        //cambiar el text del button
        $("#btnCreateUpdate").attr("value", "Update");
        $("#btnCreateUpdate").html("Actualizar");
        $("#modalCreateUpdateLabel").html("Actualizar datos de la oferta laboral");
        // setear data de usuario
        $("#txt-idjob").val($(this).data("idjob"));
        $("#txt-companies").selectpicker("val", $(this).attr("data-idcompany"));
        $("#txt-categories").selectpicker("val", $(this).attr("data-idcategory"));
        $("#txt-puesto").val($(this).data("puesto"));
        $("#txt-vacantes").val($(this).data("vacantes"));
        $("#txt-tipo").selectpicker("val", $(this).attr("data-tipo"));
        $("#txt-modalidad").selectpicker("val", $(this).attr("data-modalidad"));
        $("#txt-experiencia").selectpicker("val", $(this).attr("data-experiencia"));
        $("#txt-nivel_educativo").selectpicker("val", $(this).attr("data-nivel_educativo"));
        $("#txt-fecpublicacion").val($(this).data("fecpublicacion"));
        $("#txt-feccierre").val($(this).data("feccierre"));
        $("#txt-salariomin").val($(this).data("salariomin"));
        $("#txt-salariomax").val($(this).data("salariomax"));
        // $("#txt-estado").selectpicker("val", $(this).attr("data-estado"));
        // ubigeo
        $("#txt_departamento").selectpicker("val", $(this).attr("data-iddepartamento"));
        let sl_departamento = $(this).data("departamento");
        let sl_provincia = $(this).data("provincia");
        let sl_distrito = $(this).data("distrito");
        ubigeo_for_update(sl_departamento, sl_provincia, sl_distrito);
        tinymce.get("txt-descripcion").setContent($(this).data("descripcion"));
        // show form
        $("#modalCreateUpdate").modal("show");
    });
    // FIN - MODAL UPDATE


    // INICIO - MODAL DELETE
    $("#datatableGeneral tbody").on("click", ".deleteBtn", function (e) {
        let idjob = $(this).data("idjob")
        // confirmacion
        confirmation_sweetAlert("Deseas continuar?", "Se procederá a eliminar el registro de la base de datos", "warning")
            .then(function (isConfirm) {
                if (isConfirm.value) {
                    // enviando el parametro de la data que se procede a delete
                    destroy(idjob);
                } else {
                    console.log("Cancelado");
                }
            });
    });
    // FIN - MODAL DELETE


    // INICIO - FUNCION CREATE O UPDATE
    $("#btnCreateUpdate").on("click", function (event) {

        event.preventDefault();
        // Iterar sobre los formularios y evitar la acción predeterminada si no son válidos

        formCheck = $("#formModal")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
        } else {
            valbtn = $("#btnCreateUpdate").val();
            // FUNCION CREAR
            if (valbtn === "Create") {
                const salarioMinimo = parseFloat(document.getElementById("txt-salariomin").value);
                const salarioMaximo = parseFloat(document.getElementById("txt-salariomax").value);

                // Verificar si el salario mínimo es mayor que el salario máximo
                if (salarioMinimo > salarioMaximo) {
                    notificaciontoast("error", "El salario mínimo debe ser meno que el Salario máx", "Error!", "bottom-right", 3000);
                    $("#txt-salariomin").addClass("border border-danger shadow");
                    $("#txt-salariomax").addClass("border border-danger shadow");

                    setTimeout(function () {
                        $("#txt-salariomin").removeClass("border border-danger shadow");
                        $("#txt-salariomax").removeClass("border border-danger shadow");
                    }, 1000);
                } else {
                    // insertar
                    store();
                }

            }
            // FUNCION ACTUALIZAR
            if (valbtn === "Update") {
                const salarioMinimo = parseFloat(document.getElementById("txt-salariomin").value);
                const salarioMaximo = parseFloat(document.getElementById("txt-salariomax").value);

                // Verificar si el salario mínimo es mayor que el salario máximo
                if (salarioMinimo > salarioMaximo) {
                    notificaciontoast("error", "El salario mín debe ser menor que el Salario máx", "Error!", "bottom-right", 3000);
                    $("#txt-salariomin").addClass("border border-danger shadow");
                    $("#txt-salariomax").addClass("border border-danger shadow");

                    setTimeout(function () {
                        $("#txt-salariomin").removeClass("border border-danger shadow");
                        $("#txt-salariomax").removeClass("border border-danger shadow");
                    }, 1000);
                } else {
                    // actualizar
                    update($("#txt-idjob").val());
                }
            }
        }
        $(formCheck).addClass('was-validated'); // añadir validaciones
    });
    // FIN - FUNCION CREATE O UPDATE


    // INICIO - FUNCION CREATE O UPDATE
    $("#btnUpdateView").on("click", function (event) {
        event.preventDefault();
        // Iterar sobre los formularios y evitar la acción predeterminada si no son válidos
        cb_companies();
        cb_categories();
    });
    // FIN - FUNCION CREATE O UPDATE


    function store() {
        var salariomin = $('#txt-salariomin').val();
        var salariomax = $('#txt-salariomax').val();

        if (salariomin >= 1000000 || salariomax >= 1000000) {
            notificaciontoast("error", "Uno de los salarios excede los 6 dígitos.", "Error!", "bottom-right", 3000);
        } else {
            if (tinymce.get("txt-descripcion").getContent() == "") {
                tinymce.get("txt-descripcion").setContent("No hay descripción");
            }

            // Obtener el contenido del editor TinyMCE
            var descripcion = tinymce.get("txt-descripcion").getContent();

            // Crear un objeto FormData desde el formulario
            var formData = new FormData(document.getElementById('formModal'));

            // Agregar el contenido del editor al FormData
            formData.append("descripcion", descripcion);

            $.ajax({
                type: "POST",
                url: '/empresa/ofertas_laborales/store',
                data: formData,
                processData: false,  // Para que jQuery no procese los datos
                contentType: false,  // Para que jQuery no establezca el contentType
                dataType: 'json',
                beforeSend: function () { },
                success: function (data) {
                    if (data.status == true) {
                        table.ajax.reload();
                        setTimeout(function () {
                            notificaciontoast("info", data.mensaje, "Éxito!", "bottom-right", 3000);
                            $("#modalCreateUpdate").modal("hide");
                        }, 1000); // ocultar después de 1 segundo
                    } else {
                        notificaciontoast("error", data.mensaje, "Error!", "bottom-right", 3000);
                    }
                },
                error: function (error) {
                    console.log("Error", error);
                }
            });
        }
    }



    function update(idjob) {

        if (tinymce.get("txt-descripcion").getContent() == "") {
            tinymce.get("txt-descripcion").setContent("No hay descripcion");
        }

        // Obtener el contenido del editor TinyMCE
        var descripcion = tinymce.get("txt-descripcion").getContent();

        // Serializar el formulario y convertirlo en un objeto de datos
        var formData = $("#formModal").serializeArray();

        // Agregar el contenido del editor al objeto de datos
        formData.push({ name: "descripcion", value: descripcion });

        // Convertir el objeto de datos a una cadena de consulta
        var queryString = $.param(formData);

        formModal = $('#formModal');
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'PUT',
            url: '/empresa/ofertas_laborales/update/' + idjob,
            // data: formModal.serialize(),
            data: queryString,
            dataType: 'json',
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    setTimeout(function () {
                        notificaciontoast("info", data.mensaje, "Éxito!", "bottom-right", 3000);
                        $("#modalCreateUpdate").modal("hide");
                    }, 1000);   // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!", "bottom-right", 3000);
                }
            },
            error: function (error) {
                console.log('Error', error)
            }
        })
    }

    function destroy(idjob) {
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: "DELETE",
            url: '/empresa/ofertas_laborales/destroy/' + idjob,
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    notificaciontoast("info", data.mensaje, "Éxito!", "bottom-right", 3000);
                } else {
                    notificaciontoast("error", data.mensaje, "Error!", "bottom-right", 3000);
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // LIMPIAR VALIDACIONES
    function clearCheck() {
        formCheck = $("#formModal")[0];
        $(formCheck).removeClass('was-validated'); // remover validaciones
    }

    // LIMPIAR FORMULARIO
    function clearForm() {
        $("#txt-idjob").val("");
        $("#txt-companies").selectpicker("val", "");
        $("#txt-categories").selectpicker("val", "");
        $("#txt-puesto").val("");
        $("#txt-vacantes").val("");
        $("#txt-tipo").selectpicker("val", "Tiempo Completo");
        $("#txt-modalidad").selectpicker("val", "Presencial");
        $("#txt-experiencia").selectpicker("val", "1 año");
        $("#txt-nivel_educativo").selectpicker("val", "Profesional Técnico");
        $("#txt-fecpublicacion").val("");
        $("#txt-feccierre").val("");
        $("#txt-salariomin").val("");
        $("#txt-salariomax").val("");
        $("#txt-documento").val("");
        // $("#txt-estado").selectpicker("");
        // ubigeo
        $("#txt_departamento").selectpicker("val", "");
        vaciar_provincias();
        vaciar_distritos();
        $("#txt-link").val("");
        tinymce.get("txt-descripcion").setContent("");
        // $("#txt-descripcion").val("");
    }

});


