// cb_provincias();

var sl_attributes, iddepartamento, idprovincia, iddistrito;

// on change departamentos
var namedepartamento;
const selectDepartamento = document.querySelector('#txt_departamento');
selectDepartamento.addEventListener('change', (e) => {
    e.preventDefault();
    iddepartamento = selectDepartamento.value;
    sl_attributes = selectDepartamento.options[selectDepartamento.selectedIndex];
    namedepartamento = sl_attributes.getAttribute('namedepartamento');
    $("#txt_provincia").find("option").remove().end() // delete options
    cb_provincias(namedepartamento);
    vaciar_distritos();
});

// listar provincias por departamento
export function cb_provincias(departamento, sl_provincia = "no") {
    $.ajax({
        type: "GET",
        url: '/ajax_all/ubigeo/provincias/' + departamento,
        dataType: 'json',
        beforeSend: function () { },
        success: function (response) {
            // si no hay idprovincia seteado
            if (sl_provincia === "no") {
                $("#txt_provincia").append('<option selected disabled value="">Seleccione opción</option>');
                response.forEach((elemento) => {
                    $("#txt_provincia").append('<option value="' + elemento.idprovincia + '" nameprovincia="' + elemento.provincia + '" >' + elemento.provincia + '</option>');
                })
            }
            // para listar con una provincia seleccionada
            else {
                $("#txt_provincia").append('<option disabled value="">Seleccione opción</option>');
                response.forEach((elemento) => {
                    if (elemento.provincia == sl_provincia) {
                        $("#txt_provincia").append('<option selected value="' + elemento.idprovincia + '" nameprovincia="' + elemento.provincia + '" >' + elemento.provincia + '</option>');
                    }
                    else {
                        $("#txt_provincia").append('<option value="' + elemento.idprovincia + '" nameprovincia="' + elemento.provincia + '" >' + elemento.provincia + '</option>');
                    }
                })
            }
            $("#txt_provincia").selectpicker("refresh");
        },
        error: function (error) {
            console.log("Error", error);
        },
    });
}

// on change provincias
var nameprovincia;
const selectProvincia = document.querySelector('#txt_provincia');
selectProvincia.addEventListener('change', (e) => {
    e.preventDefault();
    idprovincia = selectProvincia.value;
    sl_attributes = selectProvincia.options[selectProvincia.selectedIndex];
    nameprovincia = sl_attributes.getAttribute('nameprovincia');
    $("#txt_distrito").find("option").remove().end() // delete options
    cb_distritos(nameprovincia);
    // $("#distrito").find("option").remove().end() // Agregado
    // distrito();
});


export function cb_distritos(provincia, sl_distrito = "no") {
    $.ajax({
        type: "GET",
        url: '/ajax_all/ubigeo/distritos/' + provincia,
        dataType: 'json',
        beforeSend: function () { },
        success: function (response) {
            // si no hay iddistrito seteado
            if (sl_distrito === "no") {
                $("#txt_distrito").append('<option selected disabled value="">Seleccione opción</option>');
                response.forEach((elemento) => {
                    $("#txt_distrito").append('<option value="' + elemento.iddistrito + '" namedistrito="' + elemento.distrito + '" >' + elemento.distrito + '</option>');
                })
            }
            // para listar con un distrito seleccionado
            else {
                $("#txt_distrito").append('<option disabled value="">Seleccione opción</option>');
                response.forEach((elemento) => {
                    if (elemento.distrito == sl_distrito) {
                        $("#txt_distrito").append('<option selected value="' + elemento.iddistrito + '" namedistrito="' + elemento.distrito + '" >' + elemento.distrito + '</option>');

                    }
                    else {
                        $("#txt_distrito").append('<option value="' + elemento.iddistrito + '" namedistrito="' + elemento.distrito + '" >' + elemento.distrito + '</option>');
                    }
                })
            }
            $("#txt_distrito").selectpicker("refresh");
        },
        error: function (error) {
            console.log("Error", error);
        },
    });
}


export function ubigeo_for_update(sl_departamento, sl_provincia, sl_distrito) {
    cb_provincias(sl_departamento, sl_provincia);
    cb_distritos(sl_provincia, sl_distrito);
}

export function vaciar_distritos() {
    $("#txt_distrito").find("option").remove().end() // delete options
    $("#txt_distrito").append('<option selected disabled value="">Seleccione opción</option>');
    $("#txt_distrito").selectpicker("refresh");
}

export function vaciar_provincias() {
    $("#txt_provincia").find("option").remove().end() // delete options
    $("#txt_provincia").append('<option selected disabled value="">Seleccione opción</option>');
    $("#txt_provincia").selectpicker("refresh");
}
