import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";

// Click en el botón subir plantilla (carga data del plan)
$("#datatableGeneral tbody").on("click", ".btnUpload_Plantilla", function (e) {
    e.preventDefault();
    let planData = {
        id: $(this).data("id"),
        nombreplan: $(this).data("nombre"),
        nombreprograma: $(this).data("nombreprograma"),
        tipo: $(this).data("tipo"),
        modalidad: $(this).data("modalidad"),
        enfoque: $(this).data("enfoque"),
        nivelformativo: $(this).data("nivelformativo")
    };
    $("#archivo").data("plan-data", planData);
    $("#archivo").click();
});

// Cuando el usuario selecciona archivo, inicia proceso
$("#archivo").on('change', function () {
    let inputArchivo = this; // <--- Guardamos referencia del input
    let planData = $(this).data("plan-data") || {};

    confirmation_sweetAlert("¿Deseas continuar?", "Se procederá a importar el excel", "warning")
        .then(function (isConfirm) {
            if (!isConfirm.value) {
                inputArchivo.value = '';
                return;
            }

            // Animación de barra de progreso
            document.getElementById('progressSection').style.display = 'block';
            const progreso = document.getElementById('progreso');
            const porcentaje = document.getElementById('porcentaje');
            let cantidad = 0;
            let tiempoCargaEstimado = 9000;
            let intervalo = tiempoCargaEstimado / 100;
            let tiempo = setInterval(() => {
                cantidad += 1;
                progreso.style.width = `${cantidad}%`;
                porcentaje.textContent = `${cantidad}%`;

                if (cantidad === 100) {
                    clearInterval(tiempo);
                    setTimeout(() => {
                        // Construye FormData SOLO una vez, bien claro:
                        let formData = new FormData();
                        formData.append('plan_id', planData.id);
                        formData.append('nombreplan', planData.nombreplan);
                        formData.append('nombreprograma', planData.nombreprograma);
                        formData.append('nivelformativo', planData.nivelformativo);
                        formData.append('tipo', planData.tipo);
                        formData.append('modalidad', planData.modalidad);
                        formData.append('enfoque', planData.enfoque);
                        formData.append('_token', $('meta[name="csrf-token"]').attr('content'));

                        // Asegura que hay archivo:
                        if (!inputArchivo.files || !inputArchivo.files.length) {
                            notificaciontoast('error', 'No se seleccionó archivo.', 'Error!');
                            resetBar();
                            return;
                        }
                        formData.append('archivo', inputArchivo.files[0]);

                        // Primera petición: almacenar periodo/store
                        $.ajax({
                            url: "/admin/planes_estudio/periodo/store/" + planData.id,
                            type: 'POST',
                            data: formData,
                            dataType: 'json',
                            processData: false,
                            contentType: false,
                            success: function (data) {
                                if (data.status === true) {
                                    notificaciontoast('info', data.mensaje, 'Éxito!');

                                    // Aquí puedes hacer la segunda petición para cargar cursos si necesitas
                                    // Solo si nuevosIDs existe y quieres cargar cursos:
                                    if (data.nuevosIDs && Array.isArray(data.nuevosIDs) && data.nuevosIDs.length) {
                                        let optionExcel = '';
                                        if (planData.tipo === 'Modular') {
                                            optionExcel += 'MOD_'
                                        } else if (planData.tipo === 'Transversal') {
                                            optionExcel += 'TRA_'
                                        }
                                        if (planData.nivelformativo === 'Profesional Técnico') {
                                            optionExcel += 'PRO'
                                        } else if (planData.nivelformativo === 'Técnico') {
                                            optionExcel += 'TEC'
                                        }

                                        let formData2 = new FormData();
                                        formData2.append('_token', $('meta[name="csrf-token"]').attr('content'));
                                        formData2.append('archivo', inputArchivo.files[0]);
                                        data.nuevosIDs.forEach(id => {
                                            formData2.append('nuevosIDs[]', id);
                                        });

                                        fetch('/admin/planes_estudio/planes/upload/' + planData.id + '/' + optionExcel, {
                                            method: "POST",
                                            body: formData2,
                                        })
                                        .then(response => response.json())
                                        .then(response => {
                                            notificaciontoast('info', response.mensaje || 'Cursos cargados', 'Éxito!');
                                            window.table.ajax.reload();
                                            resetBar();
                                        })
                                        .catch(error => {
                                            notificaciontoast('error', 'Error cargando cursos: ' + error.message);
                                            resetBar();
                                        });
                                    } else {
                                        window.table.ajax.reload();
                                        resetBar();
                                    }
                                } else {
                                    notificaciontoast('error', data.mensaje || 'Error!', 'Error!');
                                    resetBar();
                                }
                            },
                            error: function (xhr, status, error) {
                                notificaciontoast('error', 'Error en la carga: ' + error, 'Error!');
                                resetBar();
                            }
                        });
                    }, 1000);
                }
            }, intervalo);

            // Función para limpiar y ocultar barra de progreso y archivo
            function resetBar() {
                setTimeout(() => {
                    $('#progressSection').hide();
                    inputArchivo.value = '';
                    document.getElementById("name_archivo_upload").innerHTML = '';
                }, 1000);
            }
        });
});
