import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from '../../common/schemas.js';

$(document).ready(function () {
  const tableName = 'Programas';

  var dt_idplan = "0"; formModal;

  cb_programs()
  function cb_programs() {
    $.ajax({
      type: "GET",
      url: "/ajax_all/programs",
      dataType: "json",
      beforeSend: function () { },
      success: function (response) {
        $("#txt-program_id").append('<option selected disabled value="">Seleccione programa</option>');
        response.forEach((elemento) => {
          $("#txt-program_id").append('<option ' +
            'value="' + elemento.id + '"' +
            'data-codprograma="' + elemento.codprograma + '"' +
            'data-nombre="' + elemento.nombre + '"' +
            'data-nivel_formativo="' + elemento.nivel_formativo + '"' +
            ' >' + elemento.nombre + '</option>');
        })
        $("#txt-program_id").selectpicker("refresh");
      },
      error: function (error) {
        console.log("Error", error);
      },
    });
  }

  var table = $('#datatableGeneral').DataTable({
    createdRow: function (row, data, index) {
      $(row).addClass('selected')
    },
    order: [],
    ajax: routeList,
    searching: true,
    dom: 'Bfrtip',
    select: false,
    lengthChange: false,
    responsive: true,
    language: languageSchema,
    buttons: getButtonsSchema(tableName),
    columns: [
      {
        data: "idplan", className: "text-truncate",
        render: function (data, type, all, meta) {
          return "<h5>" + all.nombreprograma + "</h5>"
          // +
          // "<b> Nivel: </b>" + all.nivelformativo + "</br>" +
          // "<b> Tipo de Plan: </b>" + all.tipo + "</br>" +
          // "<b> Modalidad: </b>" + all.modalidad + "</br>" +
          // "<b> Enfoque: </b>" + all.enfoque
        },
      },
      {
        data: 'nombreplan', className: 'text-center',
        render: function (data, type, all, meta) {
          return "<h5>" + all.nombreplan + "</h5>";
        },
      },
      {
        data: "documento", className: "text-center",
        render: function (data, type, all, meta) {
          if (all.documento == null) {
            return "--";
          } else if (all.documento == "--" || all.documento == "" || all.documento == null) {
            return `
                <div class="d-flex justify-content-center">
                    --
                </div>
                `;
          } else {
            return `
                <div class="d-flex justify-content-center">
                    <a href="/verDocumentoPlan/${all.id}" class="btn btn-info shadow btn-xs sharp me-1"
                    target="_blank"
                    data-bs-placement="top"
                    title="Ver Documento">
                    <i class="fas fa-file-lines fa-lg"></i>
                    </a>
                </div>
                `;
          }
        },
      },
      { data: 'fecha', className: 'text-center' },
      {
        data: 'id', className: 'text-center', sortable: false,
        render: function (data, type, all, meta) {
          if (all.estado_cursos == 0) {
            return `
              <div class="d-flex justify-content-center">
                <a href="javascript:void(0);" class="btnDonwload_Plantilla btn btn-primary shadow btn-xs sharp me-1"
                  data-id="${all.id}"
                  data-nombre="${all.nombreplan}"
                  data-program_id="${all.program_id}"
                  data-nombreprograma="${all.nombreprograma}"
                  data-nivelformativo="${all.nivelformativo}"
                  data-tipo="${all.tipo}"
                  data-modalidad="${all.modalidad}"
                  data-enfoque="${all.enfoque}"
                  title="Cargar Plan">
                  <i class="fa-solid fa-download"></i>
                </a>
                
                <a href="javascript:void(0);" class="btnUpload_Plantilla btn btn-info shadow btn-xs sharp me-1"
                  data-id="${all.id}"
                  data-nombre="${all.nombreplan}"
                  data-program_id="${all.program_id}"
                  data-nombreprograma="${all.nombreprograma}"
                  data-nivelformativo="${all.nivelformativo}"
                  data-tipo="${all.tipo}"
                  data-modalidad="${all.modalidad}"
                  data-enfoque="${all.enfoque}"
                  title="Descargar Plan">
                  <i class="fa-solid fa-upload"></i>
                </a>
                
                <a href="javascript:void(0);" class="editBtn btn btn-warning shadow btn-xs sharp me-1"
                  data-id="${all.id}"
                  data-program_id="${all.program_id}"
                  data-nombre="${all.nombreplan}"
                  data-tipo="${all.tipo}"
                  data-modalidad="${all.modalidad}"
                  data-enfoque="${all.enfoque}"
                  data-documento="${all.documento}"
                  data-fecha="${all.fecha}"
                  data-bs-placement="top"
                  title="Editar registro">
                  <i class="fas fa-pencil-alt"></i>
                </a>
                
                <a href="#" class="deleteBtn btn btn-danger shadow btn-xs sharp me-1"
                  data-idplan="${all.id}"
                  data-bs-placement="top"
                  title="Eliminar registro">
                  <i class="fas fa-trash"></i>
                </a>
              </div>
            `;
          } else if (all.estado_cursos == 1) {
            return `
              <div class="d-flex justify-content-center">
                <a href="javascript:void(0);" class="editBtn btn btn-warning shadow btn-xs sharp me-1"
                  data-id="${all.id}"
                  data-program_id="${all.program_id}"
                  data-nombre="${all.nombreplan}"
                  data-tipo="${all.tipo}"
                  data-modalidad="${all.modalidad}"
                  data-enfoque="${all.enfoque}"
                  data-documento="${all.documento}"
                  data-fecha="${all.fecha}"
                  data-bs-placement="top"
                  title="Editar registro">
                  <i class="fas fa-pencil-alt"></i>
                </a>
                
                <a href="#" class="deleteBtn btn btn-danger shadow btn-xs sharp me-1"
                  data-idplan="${all.id}"
                  data-bs-placement="top"
                  title="Eliminar registro">
                  <i class="fas fa-trash"></i>
                </a>
                
                <a href="javascript:void(0);" class="btnVerCursos btn btn-info shadow btn-xs sharp"
                  data-idplan="${all.id}"
                  data-bs-placement="top"
                  title="Ver Curso">
                  <i class="fas fa-eye fa-lg"></i>
                </a>
                
              </div>
            `;
          }
        }
      }
    ],
  })

  // INICIO - MODAL CREATE
  $("#btnCreateModal").click(function () {
    // change value
    $("#btnCreateUpdate").attr("value", "Create");
    $("#btnCreateUpdate").html("Registrar");
    $("#modalCreateUpdateLabel").html("Registrar datos del Plan");
    // ocultar div
    $("#div-txt-estado").css("display", "none");
    clearCheck();
    clearForm();
    $("#txt-estado").selectpicker("val", "0"); // para poder pasar el check validity
  });
  // FIN - MODAL CREATE


  // INICIO - MODAL UPDATE
  $("#datatableGeneral tbody").on("click", ".editBtn", function (e) {
    //cambiar el text del titulo
    document.getElementById("modalCreateUpdateLabel").innerHTML = "Actualizar datos del Plan seleccionado";
    clearForm();

    // setear data de programa
    $("#txt-id").val($(this).data("id"));
    $("#txt-nombre").val($(this).data("nombre"));
    $("#txt-program_id").selectpicker("val", $(this).attr("data-program_id"));
    $("#txt-tipo").selectpicker("val", $(this).attr("data-tipo"));
    $("#txt-modalidad").selectpicker("val", $(this).attr("data-modalidad"));
    $("#txt-enfoque").selectpicker("val", $(this).attr("data-enfoque"));
    $("#txt-fecha").val($(this).data("fecha"));

    clearCheck();
    $("#btnCreateUpdate").attr("value", "Update");
    $("#btnCreateUpdate").html("Actualizar");
    $("#modalCreateUpdateLabel").html("Actualizar datos del Plan de Estudios");
    $("#modalCreateUpdate").modal("show");
  });
  // FIN - MODAL UPDATE


  // INICIO - MODAL DELETE
  $("#datatableGeneral tbody").on("click", ".deleteBtn", function (e) {
    var id = $(this).data("idplan");
    // confirmacion
    confirmation_sweetAlert("Deseas continuar?", "Se procederá a eliminar el plan, periodos y cursos de la base de datos", "warning")
      .then(function (isConfirm) {
        if (isConfirm.value) {
          destroy(id);
        } else {
          console.log("Cancelado");
        }
      });
  });

  var valbtn, formCheck;
  // INICIO - FUNCION CREATE O UPDATE
  $("#btnCreateUpdate").on("click", function (event) {
    event.preventDefault();
    formCheck = $("#formModal")[0];
    if (!formCheck.checkValidity()) {
      event.preventDefault();
      event.stopPropagation();
      $(formCheck).addClass('was-validated'); // añadir validaciones
    } else {
      // obtener valor del boton
      valbtn = $("#btnCreateUpdate").val()
      // FUNCION CREAR
      if (valbtn === "Create") {
        // insertar tabla cargo
        store();
      }
      // FUNCION ACTUALIZAR
      if (valbtn === "Update") {
        // actualizar tabla cargo
        update();
      }
    }
  });
  // FIN - FUNCION CREATE O UPDATE

  var formModal, formData;

  function store() {
    formData = new FormData(document.getElementById('formModal'));
    formModal = $("#formModal");
    $.ajax({
      type: "POST",
      url: "/admin/planes_estudio/planes/store",
      data: formData,
      processData: false,
      contentType: false,
      beforeSend: function () {
        $('#btnCreateUpdate').addClass('disabled');
      },
      success: function (data) {
        if (data.status == true) {
          table.ajax.reload(); // añadir validaciones
          formModal.addClass("was-validated");
          notificaciontoast("info", data.mensaje, "Éxito!");
          setTimeout(function () {
            $("#modalCreateUpdate").modal("hide");
            $('#btnCreateUpdate').removeClass('disabled');
          }, 1000); // ocultar despues de 1 sec
        } else {
          notificaciontoast("error", data.mensaje, "Error!");
        }
      },
      error: function (error) {
        console.log("Error", error);
        $('#btnCreateUpdate').removeClass('disabled');
      },
    });
  }

  function update() {
    formData = new FormData(document.getElementById('formModal'));
    formModal = $("#formModal");
    $.ajax({
      type: "POST",
      url: "/admin/planes_estudio/planes/update",
      data: formData,
      processData: false,
      contentType: false,
      beforeSend: function () {
        $('#btnCreateUpdate').addClass('disabled');
      },
      success: function (data) {
        if (data.status == true) {
          table.ajax.reload(); // añadir validaciones
          formModal.addClass("was-validated");
          notificaciontoast("info", data.mensaje, "Éxito!");
          setTimeout(function () {
            $("#modalCreateUpdate").modal("hide");
            $('#btnCreateUpdate').removeClass('disabled');
          }, 1000); // ocultar despues de 1 sec
        } else {
          notificaciontoast("error", data.mensaje, "Error!");
        }
      },
      error: function (error) {
        console.log("Error", error);
        $('#btnCreateUpdate').removeClass('disabled');
      },
    });
  }


  function destroy(id) {
    $.ajax({
      headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
      type: "DELETE",
      url: '/admin/planes_estudio/planes/destroy/' + id,
      beforeSend: function () { },
      success: function (data) {
        if (data.status == true) {
          notificaciontoast("info", data.mensaje, "Éxito!");
          table.ajax.reload();
        } else {
          notificaciontoast("error", data.mensaje, "Error!");
        }
      },
      error: function (error) {
        console.log("Error", error);
      },
    });
  }

  window.table = table;

  // Función para convertir números a números romanos
  function toRoman(num) {
    if (typeof num !== 'number' || num < 1 || num > 3999) {
      return false;
    }

    var digits = String(+num).split(''),
      key = ['', 'C', 'CC', 'CCC', 'CD', 'D', 'DC', 'DCC', 'DCCC', 'CM', '', 'X', 'XX', 'XXX', 'XL', 'L', 'LX', 'LXX', 'LXXX', 'XC', '', 'I', 'II', 'III', 'IV', 'V', 'VI', 'VII', 'VIII', 'IX'],
      roman = '', i = 3;

    while (i--) {
      roman = (key[+digits.pop() + (i * 10)] || '') + roman;
    }

    return Array(+digits.join('') + 1).join('M') + roman;
  }
  // LISTAR DATATABLE
  var table2 = $('#datatableGeneral2').DataTable({
    createdRow: function (row, data, index) {
      $(row).addClass("selected");
    },
    order: [],
    ajax: {
      headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
      type: 'POST',
      url: '/admin/planes_estudio/planes/list_by_idplan',
      data: function (d) {
        d.id = dt_idplan;
      },
    },
    searching: false,
    paging: true, // Deshabilita la paginación
    info: false, // Oculta la información de entradas
    pageLength: 12, // 12 filas
    select: false,
    lengthChange: false,
    responsive: true,
    language: {
      search: 'Buscar',
      info: 'Mostrando _START_ a _END_ de _TOTAL_ Registros',
      zeroRecords: 'No hay registros para mostrar.',
      infoFiltered: '(Filtrados de _MAX_ Registros)',
      emptyTable: 'La tabla está vacia.',
      infoEmpty: 'No hay registros',
      paginate: {
        next: '<i class="fa-solid fa-angle-right"></i>',
        previous: '<i class="fa-solid fa-angle-left"></i>'
      }
    },
    columns: [
      {
        data: 'modulo', className: 'text-center', name: "primero",
        render: function (data, type, all, row) {
          return `
              <div class="text-wrap">
                <h4 class='mb-0'>Modulo ${all.modulo}</h4><br>${all.descripcion}
              </div>
            `;
        }
      },
      {
        data: 'periodo', className: 'text-center', name: "segundo",
        render: function (data, type, all, row) {
          if (all.periodo == 0) {
            // return all.periodo;
            return 'NO'
          } else {
            // Utiliza la función toRoman para convertir el número a número romano
            return type === 'display' ? toRoman(data) : data;
          }
        }
      },
      { data: 'curso', className: 'text-center' },
      { data: 'tipo', className: 'text-center' },
      { data: 'creditos', className: 'text-center' },
      { data: 'horas', className: 'text-center' },
      {
        data: 'id',
        className: 'text-center',
        sortable: false,
        render: function (data, type, all, meta) {
          return `
                    <div class="d-flex justify-content-center">
                      <a href="javascript:void(0);" class="btnEdithCourse btn btn-warning shadow btn-xs sharp"
                      data-idcourse="${all.id}"
                      data-curso="${all.curso}"
                      data-tipocurso="${all.tipo}"
                      data-creditos="${all.creditos}"
                      data-horas="${all.horas}"
                      data-bs-placement="top"
                      title="Editar Curso">
                      <i class="fas fa-pencil-alt"></i>
                      </a>
                    </div>

                  `
        }
      }
    ],
    rowsGroup: [
      "primero:name",
      "segundo:name",
    ],
  });

  // INICIO - MODAL VER CURSOS
  $("#datatableGeneral tbody").on("click", ".btnVerCursos", function (e) {
    dt_idplan = $(this).data("idplan");
    // cargar tabla
    table2.ajax.reload();
    setTimeout(function () { $("#modalDetalleCursos").modal("show"); }, 500); // mostrar despues de x sec
    // mostrar modal
  });
  // FIN - MODAL VER CURSOS


  //EDITAR CURSO
  $("#datatableGeneral2 tbody").on("click", ".btnEdithCourse", function (e) {
    let formCheck = $("#formModal3")[0];
    $(formCheck).removeClass("was-validated"); // remover validaciones
    $("#formModal3")[0].reset();
    // cargar tabla
    $("#txt_idcourse").val($(this).data("idcourse"));
    $("#txt_curso").val($(this).data("curso"));
    $("#txt_tipo_curso").val($(this).data("tipocurso"));
    $("#txt_creditos").val($(this).data("creditos"));
    $("#txt_horas").val($(this).data("horas"));
    setTimeout(function () { $("#modalEdithCourse").modal("show"); }, 500); // mostrar despues de x sec
  });
  //FIN


  //BTN ACTUALIZAR CURSO
  $("#btnUpdateCurse").on("click", function (event) {
    event.preventDefault();
    let formCheck = $('#formModal3')[0];
    if (!formCheck.checkValidity()) {
      event.preventDefault();
      event.stopPropagation();

    } else {
      confirmation_sweetAlert("Deseas continuar?", "Se procederá a actualizar la información del curso seleccionado", "warning")
        .then(function (isConfirm) {
          if (isConfirm.value) {
            let idcourse = $("#txt_idcourse").val();
            $.ajax({
              headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
              type: "PUT",
              url: "/admin/planes_estudio/planes/update/course/" + idcourse,
              data: $("#formModal3").serialize(),
              dataType: "json",
              beforeSend: function () {
                notificaciontoast("warning", "Validando información!", "Mensaje!");
              },
              success: function (response) {
                $("#modalEdithCourse").modal("hide");
                //
                if (response.status == true) {
                  notificaciontoast("info", response.mensaje, "Éxitos!");
                  table2.ajax.reload();
                  // document.getElementById("tr37").style.backgroundColor = "blue";
                } else if (response.status == false) {
                  notificaciontoast("error", response.mensaje, "Error!");
                }
              },
              error: function (error) {
                notificaciontoast("error", error, "Error!");
              },
            });
          } else {
            console.log("Cancelado");
          }
        });
    }
    $(formCheck).addClass('was-validated'); // añadir validaciones

  });
  //FIN

  // LIMPIAR VALIDACIONES
  function clearCheck() {
    formCheck = $("#formModal")[0];
    $(formCheck).removeClass('was-validated'); // remover validaciones
  }

  // - - - - - - - - - - LIMPIAR CAMPOS - - - - - - - - - -
  function clearForm() {
    $("#txt-id").val("");
    $("#txt-nombre").val("");
    $("#txt-program_id").selectpicker("val", "");
    $("#txt-tipo").selectpicker("val", "");
    $("#txt-modalidad").selectpicker("val", "");
    $("#txt-enfoque").selectpicker("val", "");
    $("#txt-fecha").val("");
    $("#txt-documento").val("");
  }
})