import { notificaciontoast } from "../../common/method_toast.js";

$("#datatableGeneral tbody").on("click", ".btnDonwload_Plantilla", function (e) {
    e.preventDefault();
    var id = $(this).data("id");
    var nombreplan = $(this).data("nombre");
    var nombreprograma = $(this).data("nombreprograma");
    var tipo = $(this).data("tipo");
    var modalidad = $(this).data("modalidad");
    var enfoque = $(this).data("enfoque");
    var nivelformativo = $(this).data("nivelformativo");
    var nombreArchivo = "PLANTILLA_" + tipo.toUpperCase() + "_" + nivelformativo.toUpperCase() + ".xlsx";

    var formData = new FormData();
    formData.append('plan_id', id);
    formData.append('nombreplan', nombreplan);
    formData.append('nombreprograma', nombreprograma);
    formData.append('nivelformativo', nivelformativo);
    formData.append('tipo', tipo);
    formData.append('modalidad', modalidad);
    formData.append('enfoque', enfoque);
    formData.append('_token', $('meta[name="csrf-token"]').attr('content'));
    
    $.ajax({
        url: '/admin/planes_estudio/planes/download',
        type: 'POST',
        data: formData,
        processData: false, // Importante para FormData
        contentType: false, // Importante para FormData
        xhrFields: {
            responseType: 'blob' // Para recibir el archivo binario
        },
        success: function (blob, status, xhr) {
            var url = window.URL.createObjectURL(blob);
            var a = document.createElement('a');
            a.href = url;
            a.download = nombreArchivo;
            document.body.appendChild(a);
            a.click();
            window.URL.revokeObjectURL(url);
        },
        error: function (xhr, status, error) {
            notificaciontoast("Error al descargar el archivo: " + error);
        }
    });
});
