import { notificaciontoast } from "../jsAjaxToastSweetalert/method_toast.js";
import { message_sweetAlert } from "../jsAjaxToastSweetalert/method_sweetAlert.js";

'use strict';
(function () {

    // INICIO - MODAL LOGIN
    $("#bt-student").click(function () {
        $("#loginModal").modal("show");
        $("#loginModalLabel").html("Inciar sesión como estudiante/egresado");
        $("#txt-usertype").val("3");
    });

    $("#bt-teacher").click(function () {
        $("#loginModal").modal("show");
        $("#loginModalLabel").html("Inciar sesión como docente");
        $("#txt-usertype").val("2");
    });

    $("#bt-admin").click(function () {
        $("#loginModal").modal("show");
        $("#loginModalLabel").html("Inciar sesión como administrador");
        $("#txt-usertype").val("1");
    });

    $("#bt-company").click(function () {
        $("#loginModal2").modal("show");
        $("#loginModal2Label").html("Inciar sesión como empresa");
        $("#txt-usertype2").val("4");
    });

    $("#registro-empresa").click(function () {
        $("#loginModal2").modal("hide");
        $("#modalRegistro").modal("show");
    });
    // FIN - MODAL LOGIN

    // Obtener una referencia al botón
    var miBoton = document.querySelector('#btn_button_login');

    // Agregar un evento de clic al botón
    miBoton.addEventListener('click', function (event) {
        event.preventDefault();
        // Obtener todos los elementos con la clase 'needs-validation'
        var forms = document.querySelectorAll('.needs-validation');

        // Iterar sobre los formularios y evitar la acción predeterminada si no son válidos
        Array.prototype.slice.call(forms).forEach(function (form) {
            if (!form.checkValidity()) {
                event.preventDefault();
                event.stopPropagation();
            } else {

                notificaciontoast("warning", "Validando credenciales", "Mensaje", "top-right");

                //LLAMAR A FUNCION PARA VERIFICAR CON DELAY
                setTimeout(function () {
                    callback2();
                }, 1150);

            }

            form.classList.add('was-validated');
        });
    }, false);


    function callback2() {

        // RESPUESTA HTTP
        function checkStatus(response) {
            if (response.status >= 200 && response.status < 300) {
                return response;
            } else {
                var error = new Error(response.statusText);
                error.response = response;
                throw error;
            }
        }

        function parseJSON(response) {
            return response.json();
        }

        // FUNCIÓN RESPUESTAS EN TOAST
        function fuctionRespuesta(data) {

            if (data.status) {
                notificaciontoast("info", data.message, "Éxito!", "top-right");
                setTimeout(function () {
                    window.location = data.redirect;
                }, 1150);

            } else if (data.status == false) {
                notificaciontoast("error", data.message, "Error!", "top-right");
            } else {

                $.each(data.errors, function (key, val) {
                    notificaciontoast("error", val, "Error", "top-right");
                });
            }
        }

        // VALIDACION DE CREDENCIALES
        const txt_usertype = document.getElementById('txt-usertype').value;
        const identificationtype_id = document.getElementById('txt-identificationtype').value;
        const nroidenti = document.getElementById('text_input_codigo').value;
        const password = document.getElementById('dlab-password').value;

        // CONSULTA A LA BD
        fetch(authenticateRoute, {
            method: "POST",
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': $('input[name="_token"]').val(),
            },
            body: JSON.stringify({
                txt_usertype,
                identificationtype_id,
                nroidenti,
                password,
            }),
        })
        .then(checkStatus)
        .then(parseJSON)
        .then((response) => {
            fuctionRespuesta(response);
        })
        .catch(function (error) {
            console.log("request failed", error);
        });
    }


    // Obtener una referencia al botón
    var miBotonCompany = document.querySelector('#btn_button_loginCompany');

    // Agregar un evento de clic al botón
    miBotonCompany.addEventListener('click', function (event) {
        event.preventDefault();
        // Obtener todos los elementos con la clase 'needs-validation'
        var forms = document.querySelectorAll('.needs-validation');

        // Iterar sobre los formularios y evitar la acción predeterminada si no son válidos
        Array.prototype.slice.call(forms).forEach(function (form) {
            if (!form.checkValidity()) {
                event.preventDefault();
                event.stopPropagation();
            } else {

                notificaciontoast("warning", "Validando credenciales", "Mensaje", "top-right");

                //LLAMAR A FUNCION PARA VERIFICAR CON DELAY
                setTimeout(function () {
                    callback3();
                }, 1150);

            }

            form.classList.add('was-validated');
        });
    }, false);


    function callback3() {

        // RESPUESTA HTTP
        function checkStatus(response) {
            if (response.status >= 200 && response.status < 300) {
                return response;
            } else {
                var error = new Error(response.statusText);
                error.response = response;
                throw error;
            }
        }

        function parseJSON(response) {
            return response.json();
        }

        // FUNCIÓN RESPUESTAS EN TOAST
        function fuctionRespuesta(data) {

            if (data.status) {
                notificaciontoast("info", data.message, "Éxito!", "top-right");
                setTimeout(function () {
                    window.location = data.redirect;
                }, 1150);

            } else if (data.status == false) {
                notificaciontoast("error", data.message, "Error!", "top-right");
            } else {

                $.each(data.errors, function (key, val) {
                    notificaciontoast("error", val, "Error", "top-right");
                });
            }
        }

        // VALIDACION DE CREDENCIALES
        const txt_usertype = document.getElementById('txt-usertype2').value;
        const ruc = document.getElementById('txt-ruc_name').value;
        const password = document.getElementById('txt-password').value;

        // CONSULTA A LA BD
        fetch(authenticateRouteCompany, {
            method: "POST",
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': $('input[name="_token"]').val(),
            },
            body: JSON.stringify({
                txt_usertype,
                ruc,
                password,
            }),
        })
            .then(checkStatus)
            .then(parseJSON)
            .then((response) => {
                fuctionRespuesta(response);
            })
            .catch(function (error) {
                console.log("request failed", error);
            });
    }

    var formCheck, formModal;
    // INICIO - FUNCION CREATE O UPDATE
    $("#btnSolicitud").on("click", function (event) {
        formCheck = $("#formModal3")[0];
        store();
        $(formCheck).addClass('was-validated'); // añadir validaciones
    });
    // FIN - FUNCION CREATE O UPDATE


    function store() {
        formModal = $('#formModal3');
        $.ajax({
            type: "POST",
            url: '/solicitud/empresas/storeSolicitud',
            data: formModal.serialize(),
            dataType: 'json',
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    setTimeout(function () {
                        notificaciontoast("info", data.mensaje, "Éxito!");
                        $("#modalRegistro").modal("hide");
                    }, 1000); 
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }


    $("#btn-querydata").on("click", function (event) {
        event.preventDefault();

        if (document.getElementById('txt-ruc').value == "") {
            notificaciontoast("error", "Ingrese número  RUC", "Mensaje!");
            // setear data de programa
            $("#txt-ruc").addClass("border border-danger shadow");
            setTimeout(function () {
                document.getElementById('txt-ruc').focus();
                $("#txt-ruc").removeClass("border border-danger shadow");
            }, 1500);
            
        } else { 
            
            var nroruc = $("#txt-ruc").val();
            $.ajax({
                type: "GET",
                url: '/admin/bolsa_laboral/empresas/query_data/' + nroruc,
                dataType: 'json',
                beforeSend: function () {
                    notificaciontoast("warning", "Consultando!", "Mensaje!");
                },
                success: function (response) {
                    const dataObj = JSON.parse(response.data);
                    console.log(dataObj)
                    if (dataObj.hasOwnProperty('error')) {
                        notificaciontoast("error", "Datos del RUC no encontrado/invaliddo", "Error!");
                    } else {
                        notificaciontoast("info", response.mensaje, "Éxito!");
                        
                        $("#txt-nombre").val(dataObj.nombre);
                        $("#txt-direccion").val(dataObj.direccion);
                        
                        if(dataObj.estado === "ACTIVO"){
                            $("#txt-activo").selectpicker("val", "1");
                        }else{
                            $("#txt-activo").selectpicker("val", "0");
                        }
                        
                        // setear data de programa
                        $("#txt-nombre").addClass("border border-info shadow");
                        $("#txt-direccion").addClass("border border-info shadow");
                        $("#txt-activo").addClass("border border-info shadow");
                        
                        setTimeout(function () {
                            $("#txt-nombre").removeClass("border border-info shadow");
                            $("#txt-direccion").removeClass("border border-info shadow");
                            $("#txt-activo").removeClass("border border-info shadow");
                        }, 1500);
                    }
                },
                error: function (error) {
                    console.log("Error", error);
                },
            });
        }
    });


})();
