"use strict";

import { notificaciontoast } from "../jsAjaxToastSweetalert/method_toast.js";
import { confirmation_sweetAlert } from "../jsAjaxToastSweetalert/method_sweetAlert.js";

$(document).ready(function () {

     var idasig = 0;

    $("#btn_modal_evento").on("click", function (event) {
        event.preventDefault();
       // document.getElementById('form').reset();
       if(document.getElementById("id_hidden_asignatura").value == "0"){
        Swal.fire({
            title: "Alerta!",
            text: "Seleccione una asignatura, para registrar el material correspondiente",
            type: "warning",
            width: 600,
            padding: "3em",
            color: "#716add",
            background: "#fff url(/images/trees.png)",
            backdrop: `
            rgba(4, 27, 11, 0.796)
            url(images/big/rainbow.gif)
              left top
              no-repeat
            `

          });
       }else{
        List_carpetas(document.getElementById("id_hidden_asignatura").value);
        $("#folderModal").modal("show");
       }
    });

    //Lista de asginaturas por docente
    var idbtnguardad = "";
    List_asignaturas();
    function List_asignaturas() {
        $.ajax({
            type: "GET",
            url: "/docente/repositorio/meterialesrecursos/ajax_all/asignaturas",
            dataType: "json",
            beforeSend: function () { },
            success: function (response) {
                var html = "";
                response.forEach((elemento) => {
                    html += `<a href="javascript:void(0)" class="list-group-item bg-light asignaturaBtn" id="btn_Asignatura${elemento.id}" data-idasiglist="${elemento.id}" data-codcurso="${elemento.codcurso}" data-curso="${elemento.namecurso}">
                                <h6 class="title"><i class="fa-regular fa-envelope align-middle"></i> ${elemento.codcurso} - ${elemento.namecurso}</h6>
                                <span class="mx-4 px-2">Sec: ${elemento.seccion} Turno: ${elemento.turno} </span>
                            </a>`;
                })
                $("#secc_asignaturas").html(html);

                var enlaces = document.querySelectorAll('#secc_asignaturas .asignaturaBtn');
                // Adjuntar un evento de clic a cada enlace
                enlaces.forEach(function(enlace) {
                    enlace.addEventListener('click', function() {
                        // Obtener los atributos del enlace al dar clic
                        if(idbtnguardad != ""){
                            var miBoton = document.getElementById('btn_Asignatura'+idbtnguardad);
                            miBoton.classList.remove('active');
                        }
                        var idasiglist = enlace.getAttribute('data-idasiglist');
                        idbtnguardad = idasiglist;
                        var miBoton = document.getElementById('btn_Asignatura'+idasiglist);

                        // Agrega una nueva clase al elemento
                        miBoton.classList.add('active');

                        var codcurso = enlace.getAttribute('data-codcurso');
                        document.getElementById("id_hidden_asignatura").value = idasiglist;
                        document.getElementById("id_hidden_codcurso").value = codcurso;

                        var curso = enlace.getAttribute('data-curso');
                        var html = `  <div class="drive">
                                    <div class="dz-folder">
                                        <svg width="79" height="62" viewBox="0 0 79 62" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path opacity="0.7" d="M75.1668 20.5H68.3334V13.6667C68.3343 12.9934 68.2024 12.3266 67.9451 11.7044C67.6879 11.0822 67.3104 10.5168 66.8343 10.0407C66.3583 9.56467 65.7929 9.1872 65.1707 8.92996C64.5485 8.67272 63.8817 8.54078 63.2084 8.54168H37.1563C36.3935 8.54184 35.6403 8.37168 34.9517 8.04362C34.2631 7.71556 33.6564 7.23787 33.1759 6.64543L29.8276 2.52834C29.1893 1.73859 28.3825 1.10165 27.4661 0.664169C26.5498 0.226689 25.5472 -0.000241404 24.5317 4.56815e-06H5.12506C4.45179 -0.000894936 3.78495 0.131054 3.16275 0.38829C2.54055 0.645527 1.97521 1.023 1.49913 1.49908C1.02305 1.97516 0.645583 2.54049 0.388346 3.16269C0.131109 3.78489 -0.000838865 4.45173 6.06388e-05 5.12501V55.6404C-0.00347238 56.4099 0.147413 57.1723 0.443784 57.8824C0.740155 58.5925 1.17599 59.236 1.72548 59.7746C2.26414 60.3241 2.90758 60.7599 3.6177 61.0563C4.32781 61.3527 5.09017 61.5036 5.85965 61.5H63.3622C64.6314 61.4996 65.8665 61.0884 66.8827 60.3278C67.8988 59.5672 68.6415 58.4981 68.9997 57.2804L78.4468 24.8734C78.5942 24.3642 78.6213 23.8278 78.5259 23.3063C78.4306 22.7849 78.2154 22.2928 77.8974 21.8687C77.5793 21.4447 77.1671 21.1003 76.6933 20.8628C76.2194 20.6253 75.6968 20.5011 75.1668 20.5Z" fill="#01A3FF"/>
                                            <path d="M75.1645 20.5H26.6031C25.3352 20.5002 24.1016 20.9115 23.0875 21.6723C22.0733 22.4332 21.3332 23.5024 20.9784 24.7196L11.48 57.2828C11.1252 58.4994 10.3853 59.5681 9.3715 60.3285C8.35766 61.0889 7.12455 61.5 5.85724 61.5H63.3662C64.6343 61.5001 65.8682 61.0889 66.8826 60.3281C67.8971 59.5672 68.6374 58.4978 68.9923 57.2804L78.4446 24.8733C78.5932 24.3641 78.6211 23.8273 78.5262 23.3054C78.4313 22.7836 78.2162 22.2909 77.8979 21.8666C77.5797 21.4423 77.167 21.0979 76.6925 20.8607C76.2181 20.6235 75.6949 20.5 75.1645 20.5Z" fill="#01A3FF"/>
                                        </svg>
                                    </div>
                                    <div class="drive-content">
                                        <h4 class="title">${curso}</h4>
                                        <div class="progress default-progress">
                                            <div class="progress-bar bg-vigit progress-animated bg-primary" style="width: 60%; height:100%;" role="progressbar">
                                                <span class="sr-only">60% Complete</span>
                                            </div>
                                        </div>
                                        <span>40 GB / 50GB</span>
                                    </div>
                                </div>`;

                            $("#div_asignatura").html(html);

                        List_materialesOfasignaturas(idasiglist)

                    });
                });
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }


    //lista de carpetas segun la asignatura seleccionada
    // List_materialesOfasignaturas(idasig);
    function List_materialesOfasignaturas(idasig) {
        $.ajax({
            type: "GET",
            url: "/docente/repositorio/meterialesrecursos/ajax_all/asignaturas/file/"+idasig,
            dataType: "json",
            beforeSend: function () { },
            success: function (response) {
                var html = "";
                if(response.length > 0){
                    response.forEach((elemento) => {
                        html += `<li>
                                    <div class="file-list">
                                        <div class="dz-media">
                                            <svg width="40" height="30"
                                                viewBox="0 0 79 62" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path opacity="0.7"
                                                    d="M75.1668 20.5H68.3334V13.6667C68.3343 12.9934 68.2024 12.3266 67.9451 11.7044C67.6879 11.0822 67.3104 10.5168 66.8343 10.0407C66.3583 9.56467 65.7929 9.1872 65.1707 8.92996C64.5485 8.67272 63.8817 8.54078 63.2084 8.54168H37.1563C36.3935 8.54184 35.6403 8.37168 34.9517 8.04362C34.2631 7.71556 33.6564 7.23787 33.1759 6.64543L29.8276 2.52834C29.1893 1.73859 28.3825 1.10165 27.4661 0.664169C26.5498 0.226689 25.5472 -0.000241404 24.5317 4.56815e-06H5.12506C4.45179 -0.000894936 3.78495 0.131054 3.16275 0.38829C2.54055 0.645527 1.97521 1.023 1.49913 1.49908C1.02305 1.97516 0.645583 2.54049 0.388346 3.16269C0.131109 3.78489 -0.000838865 4.45173 6.06388e-05 5.12501V55.6404C-0.00347238 56.4099 0.147413 57.1723 0.443784 57.8824C0.740155 58.5925 1.17599 59.236 1.72548 59.7746C2.26414 60.3241 2.90758 60.7599 3.6177 61.0563C4.32781 61.3527 5.09017 61.5036 5.85965 61.5H63.3622C64.6314 61.4996 65.8665 61.0884 66.8827 60.3278C67.8988 59.5672 68.6415 58.4981 68.9997 57.2804L78.4468 24.8734C78.5942 24.3642 78.6213 23.8278 78.5259 23.3063C78.4306 22.7849 78.2154 22.2928 77.8974 21.8687C77.5793 21.4447 77.1671 21.1003 76.6933 20.8628C76.2194 20.6253 75.6968 20.5011 75.1668 20.5Z"
                                                    fill="var(--primary)" />
                                                <path
                                                    d="M75.1645 20.5H26.6031C25.3352 20.5002 24.1016 20.9115 23.0875 21.6723C22.0733 22.4332 21.3332 23.5024 20.9784 24.7196L11.48 57.2828C11.1252 58.4994 10.3853 59.5681 9.3715 60.3285C8.35766 61.0889 7.12455 61.5 5.85724 61.5H63.3662C64.6343 61.5001 65.8682 61.0889 66.8826 60.3281C67.8971 59.5672 68.6374 58.4978 68.9923 57.2804L78.4446 24.8733C78.5932 24.3641 78.6211 23.8273 78.5262 23.3054C78.4313 22.7836 78.2162 22.2909 77.8979 21.8666C77.5797 21.4423 77.167 21.0979 76.6925 20.8607C76.2181 20.6235 75.6949 20.5 75.1645 20.5Z"
                                                    fill="var(--primary)" />
                                            </svg>
                                        </div>
                                        <div class="carpetalisfileBtn dz-info"
                                            data-carpeta="${elemento.carpeta}"
                                            data-idasig="${elemento.id}"
                                            data-codcurso=" ${elemento.codcurso}">
                                            <a href="javascript:void(0)" class="row justify-content-between items-align-center">
                                                <h4 class="title">${elemento.carpeta}</h4>
                                                <span>Curso:  ${elemento.codcurso} -  ${elemento.nombre}</span>
                                            </a>
                                        </div>
                                        <div class="d-flex">
                                        </div>

                                            <a href="javascript:void(0)" class="btnDeleteRepository btn btn-dark  shadow btn-xs sharp"
                                                data-idrepository="${elemento.idrepository}"
                                                data-bs-placement="top"
                                                title="Eliminar Archivo"
                                                ><i class="fa-solid fa-trash-can"></i></a>
                                    </div>
                                </li>`;
                    })
                }else{
                    html = "";
                }
                $("#folder").html(html);

                var enlaces = document.querySelectorAll('#folder .carpetalisfileBtn');

                // Adjuntar un evento de clic a cada enlace
                enlaces.forEach(function(enlace) {
                    enlace.addEventListener('click', function() {
                        // Obtener los atributos del enlace al dar clic
                        var idasig = enlace.getAttribute('data-idasig');
                        var carpeta = enlace.getAttribute('data-carpeta');

                        Lista_archivos(idasig,carpeta)
                         $("#ModalListFile").modal("show");

                    });
                });


            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }


    //Listar de carpetas segun la asignatura, sirve para guardar en la misma carpeta o ingresar otra
    function List_carpetas(idasig) {
        $.ajax({
            type: "GET",
            url: "/docente/repositorio/meterialesrecursos/ajax_all/asignaturas/file/"+idasig,
            dataType: "json",
            beforeSend: function () { },
            success: function (response) {
                var html = "";
                if(response.length > 0){
                    response.forEach((elemento) => {
                        html += `<div class="file-header">
                        <a href="javascript:void(0)" class="carpetaBtn" data-carpeta="${elemento.carpeta}" data-codcurso="${elemento.codcurso}">
                            <div class="page-titles">
                                <div class="my-2">
                                        <div class="file-path">
                                            <div class="me-2">
                                                <svg width="20" height="16" viewBox="0 0 20 16"
                                                    fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path
                                                        d="M18.9833 6.64169C18.9049 6.545 18.8058 6.46712 18.6933 6.41376C18.5808 6.36041 18.4578 6.33293 18.3333 6.33335H16.6666V5.50002C16.6666 4.83698 16.4033 4.20109 15.9344 3.73225C15.4656 3.26341 14.8297 3.00002 14.1666 3.00002H8.93331L8.66665 2.16669C8.49377 1.67771 8.1731 1.2546 7.74906 0.955986C7.32502 0.657367 6.81861 0.498019 6.29998 0.500019H3.33331C2.67027 0.500019 2.03439 0.763411 1.56555 1.23225C1.09671 1.70109 0.833313 2.33698 0.833313 3.00002V13C0.833313 13.6631 1.09671 14.2989 1.56555 14.7678C2.03439 15.2366 2.67027 15.5 3.33331 15.5H15.3333C15.901 15.4984 16.4512 15.3036 16.8935 14.9476C17.3357 14.5917 17.6437 14.0959 17.7666 13.5417L19.1666 7.35002C19.192 7.22578 19.1886 7.0974 19.1569 6.97466C19.1251 6.85191 19.0657 6.73803 18.9833 6.64169ZM4.47498 13.1834C4.43264 13.3713 4.32647 13.5388 4.17453 13.6574C4.02259 13.7759 3.83428 13.8381 3.64165 13.8334H3.33331C3.1123 13.8334 2.90034 13.7456 2.74406 13.5893C2.58778 13.433 2.49998 13.221 2.49998 13V3.00002C2.49998 2.779 2.58778 2.56704 2.74406 2.41076C2.90034 2.25448 3.1123 2.16669 3.33331 2.16669H6.29998C6.4817 2.1572 6.66153 2.20746 6.81201 2.30978C6.96248 2.4121 7.07533 2.56087 7.13331 2.73335L7.58331 4.10002C7.63679 4.25897 7.73698 4.39809 7.87079 4.49919C8.0046 4.60029 8.1658 4.65867 8.33331 4.66669H14.1666C14.3877 4.66669 14.5996 4.75448 14.7559 4.91076C14.9122 5.06704 15 5.27901 15 5.50002V6.33335H6.66665C6.47401 6.32864 6.2857 6.39084 6.13376 6.50935C5.98182 6.62786 5.87565 6.79537 5.83331 6.98335L4.47498 13.1834ZM16.1416 13.1834C16.0993 13.3713 15.9931 13.5388 15.8412 13.6574C15.6893 13.7759 15.5009 13.8381 15.3083 13.8334H6.00831C6.05135 13.7405 6.08216 13.6425 6.09998 13.5417L7.33331 8.00002H17.3333L16.1416 13.1834Z"
                                                        fill="#01A3FF" />
                                                </svg>
                                            </div>
                                            <h2 class="heading">${elemento.carpeta}</h2>
                                        </div>
                                </div>
                            </div>
                        </a>
                    </div>`;
                    })
                }else{
                    html = "";
                }

                $("#list_carpetas").html(html);

                var enlaces = document.querySelectorAll('#list_carpetas .carpetaBtn');

                // Adjuntar un evento de clic a cada enlace
                enlaces.forEach(function(enlace) {
                    enlace.addEventListener('click', function() {
                        // Obtener los atributos del enlace al dar clic
                        var carpeta = enlace.getAttribute('data-carpeta');
                        var codcurso = enlace.getAttribute('data-codcurso');
                        document.getElementById("text_carpeta").value = carpeta;
                        document.getElementById("id_hidden_codcurso").value = codcurso;

                    });
                });
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    //lista de archivo dentro de la carpeta
    function Lista_archivos(idasig,carpeta) {
        $.ajax({
            type: "GET",
            url: "/docente/repositorio/meterialesrecursos/ajax_all/asignaturas/file/carpeta/"+idasig+"/"+carpeta,
            dataType: "json",
            beforeSend: function () { },
            success: function (response) {
                var html = "";
                if(response.length > 0){
                    response.forEach((elemento) => {
                        html += `<li>
                                    <div class="timeline-panel">
                                        <div class="media me-3 media-danger">
                                            PU
                                        </div>
                                        <div class="media-body">
                                            <h5 class="mb-1">${elemento.archivo} <small class="text-muted">${elemento.created_at}</small></h5>
                                            <p class="mb-1">${elemento.descripcion}</p>
                                        </div>
                                        <div class="d-flex">
                                            <a href="/docente/repositorio/meterialesrecursos/viewfile/${elemento.codcurso}/${elemento.carpeta}/${elemento.archivo}"
                                                data-bs-placement="top"
                                                title="Descargar Archivo"
                                                target="_blank" class="btn btn-primary  shadow btn-xs sharp me-1">
                                                <i class="fa-solid fa-download"></i></a>
                                            <a style="display:none;" href="javascript:void(0)" id="btnEditRepository" class="btn btn-dark  shadow btn-xs sharp me-1"
                                                ><i class="fa-solid fa-pen-to-square"></i></a>
                                            <a style="display:none;" href="javascript:void(0)" id="" class="btn btn-dark  shadow btn-xs sharp"
                                                data-idrepository="${elemento.idrepository}"
                                                data-bs-placement="top"
                                                title="Eliminar Archivo"
                                                ><i class="fa-solid fa-trash-can"></i></a>
                                        </div>
                                    </div>
                                </li>`;
                    })
                }else{
                    html = "";
                }
                $("#list_files_carpetas").html(html);
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    //Eliminar repositorio
    $("#folder").on("click", ".btnDeleteRepository",function (event) {
        let idrepository = $(this).data("idrepository")
        // confirmacion
        confirmation_sweetAlert("Deseas continuar?", "Se procederá a eliminar el registro de la base de datos", "warning")
            .then(function (isConfirm) {
                if (isConfirm.value) {
                    // enviando el parametro de la data que se procede a delete
                    destroy(idrepository);
                } else {
                    console.log("Cancelado");
                }
            });
    });

    function destroy(idrepository) {
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: "DELETE",
            url: '/docente/repositorio/delete/' + idrepository,
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    List_materialesOfasignaturas(idasig)
                    notificaciontoast("info", data.mensaje, "Éxito!");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    //metodo guardar archivo y registro en base de datos
    var estado = false;
    $("#btn_save_file_asignatura").on("click", function (event) {
        event.preventDefault();
        let formCheck = $('#formModalFolder')[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();

        } else {
            confirmation_sweetAlert("Deseas continuar?", "Se procederá a cargar el archivo, en la carpeta y asginatura selecionada ", "warning")
                .then(function (isConfirm) {
                    if (isConfirm.value) {
                        //FUNCION REGISTRAR TRAMITE
                        if (estado === true) {
                            document.getElementById('formModalFolder').classList.remove('was-validated');
                            document.getElementById('file_material_asginatura').classList.remove('is-invalid');
                            estado = false;
                        }
                        var formData = new FormData(document.getElementById('formModalFolder'));
                        $.ajax({
                            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
                            type: 'POST',
                            url: '/docente/repositorio/upload/file',
                            data: formData,
                            processData: false,
                            contentType: false,
                            beforeSend: function () {
                                notificaciontoast("warning", "Validando información!", "Mensaje!");
                            },
                            success: function (response) {
                                if (response.status == true) {
                                    notificaciontoast("info", response.mensaje, "Éxitos!");
                                    List_materialesOfasignaturas($("#id_hidden_asignatura").val())
                                    document.getElementById('formModalFolder').classList.remove('was-validated')
                                    document.getElementById('formModalRepositorio').reset();
                                    // $("#id_hidden_asignatura").val("");
                                    // $("#id_hidden_codcurso").val("");
                                    $("#folderModal").modal("hide");

                                } else if (response.status == false) {

                                    if (typeof response.mensaje.file_material_asginatura != 'undefined') {
                                        document.getElementById('file_material_asginatura').classList.add('is-invalid');
                                        document.getElementById('validate_message_File_docuemento').innerHTML = response.mensaje.file_material_asginatura[0];
                                    }
                                    estado = true;
                                }

                            },
                            error: function (error) {
                                notificaciontoast("error", error, "Error!");
                            },
                        });

                    } else {
                        console.log("Cancelado");
                    }
                });


        }
        $(formCheck).addClass('was-validated'); // añadir validaciones

    });


});

