import { notificaciontoast } from "../jsAjaxToastSweetalert/method_toast.js";
import { confirmation_sweetAlert } from "../jsAjaxToastSweetalert/method_sweetAlert.js";

document.addEventListener('DOMContentLoaded', function () {

    var idsemester, idsubject;

    var functionCalendarioprogramacion = function () {
        $.ajax({
            type: "GET",
            url: "/docente/programacion/ajax_all/eventos/calendario/"+idsemester,
            dataType: "json",
            beforeSend: function () { },
            success: function (response) {

                var calendar = new FullCalendar.Calendar(document.getElementById('calendar'), {

                    eventDidMount: function(info) {
                        var tooltip = new bootstrap.Tooltip(info.el, {
                            title: info.event.extendedProps.description,
                            placement: 'top',
                            trigger: 'hover',
                            container: 'body'
                        });
                    },
                    headerToolbar: {
                        left: 'prev,next today',
                        center: 'title',
                        right: 'dayGridMonth,timeGridWeek,timeGridDay'
                    },
                    locale: 'es',
                    navLinks: false, // can click day/week names to navigate views
                    editable: false,
                    droppable: false, // this allows things to be dropped onto the calendar
                    dayMaxEvents: true,
                    initialView: 'dayGridMonth',
                    initialDate: '2024-01-01',
                    eventColor: 'green',
                    buttonText: {
                        today: 'Hoy',
                        month: 'Mes',
                        week: 'Semana',
                        day: 'Día'
                    },
                    events: response
                });

                calendar.render();
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    };

    // Eventos_programados_asignados();
    function Eventos_programados_asignados(idsubject) {
        $.ajax({
            type: "GET",
            url: "/docente/programacion/ajax_all/eventos/programados/" + idsubject,
            dataType: "json",
            beforeSend: function () { },
            success: function (response) {
                var html = "";
                response.forEach((elemento) => {
                    html += `
                    <li>
                        <div class="timeline-panel">
                            <div class="col-xl-9 col-sm-6">
                                <div class="card schedule-card mb-0">
                                    <div class="card-body px-3 pb-1 pt-1">
                                        <div class="d-flex align-items-center justify-content-between">
                                            <ul class="list-unstyled">
                                                <li class="mb-2 d-flex align-items-center">
                                                    <i class="fa-solid fa-book fa-lg" style="color: #125e47; margin-right: 0.5rem;"></i>
                                                    <b class="text-md text-primary">${elemento.nombre_evento}</b>
                                                </li>
                                                <li class="mb-2 d-flex align-items-center">
                                                    <i class="fa-solid fa-star" style="color: #125e47; margin-right: 0.5rem;"></i>
                                                    ${elemento.tipo_nota} - Peso: ${elemento.porcentaje}
                                                </li>
                                                <li class="mb-2 d-flex align-items-center">
                                                    <i class="fa-regular fa-calendar-days fa-lg mr-2" style="color: #125e47; margin-right: 0.5rem;"></i>
                                                    ${elemento.fecha}
                                                </li>
                                                <li class="d-flex align-items-center">
                                                    <i class="fa-regular fa-clock fa-lg mr-2" style="color: #125e47; margin-right: 0.5rem;"></i>
                                                    De ${elemento.horaini2} a ${elemento.horafin2}
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-3 col-sm-6 d-flex justify-content-center align-items-center">
                                <div class="file-list">
                                    <a href="/docente/programacion/evaluaciones/download/${elemento.idscheduleingcalendar}" target="_blank" class="downloadBtn btn btn-success shadow btn-xs sharp me-2"
                                        data-bs-placement="top"
                                        title="Descargar Archivo">
                                        <i class="fa-solid fa-download"></i>
                                    </a>

                                    <a href="javascript:void(0);" class="editBtn btn btn-dark shadow btn-xs sharp me-2"
                                        data-idscheduleingcalendar="${elemento.idscheduleingcalendar}"
                                        data-subject_id="${elemento.subject_id}"
                                        data-gradetype_id="${elemento.gradetype_id}"
                                        data-nombre_evento="${elemento.nombre_evento}"
                                        data-fecinicio="${elemento.fecinicio}"
                                        data-horaini="${elemento.horaini}"
                                        data-horafin="${elemento.horafin}"
                                        data-duracion="${elemento.duracion}"
                                        data-descripcion="${elemento.descripcion}"
                                        data-estado="${elemento.estado}"
                                        data-tipo_nota="${elemento.tipo_nota}"
                                        data-namecurso="${elemento.namecurso}"
                                        data-bs-placement="top"
                                        title="Editar Evaluacion">
                                        <i class="fas fa-pencil-alt"></i>
                                    </a>

                                    <a href="javascript:void(0);" class="deleteBtn btn btn-dark shadow btn-xs sharp me-2"
                                        data-idscheduleingcalendar="${elemento.idscheduleingcalendar}"
                                        data-bs-placement="top"
                                        title="Eliminar Evaluacion">
                                        <i class="fas fa-trash"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </li>`;
                })
                document.getElementById("list_evaluaciones").innerHTML= html;
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }


    $(document).on("change", "#txt-semestre", function () {
        idsemester = $(this).val();
        idsubject = "0";
        $("#text_asignatura").val("");
        cb_subjects(idsemester);
        Eventos_programados_asignados(idsubject)
        functionCalendarioprogramacion(idsemester);
    });

    $(document).on("change", "#txt-asignatura", function () {
        idsubject = $(this).val();
        var curso = $('option:selected', this).data('namecurso');
        $("#dt-subject_id").val(idsubject);
        $("#text_asignatura").val(curso);
        Eventos_programados_asignados(idsubject);
    });

    // INICIO - MODAL CREATE
    $("#btnCreateModal").click(function () {
        // change value
        $("#btnCreateUpdate").attr("value", "Create");
        $("#btnCreateUpdate").html("Registrar");
        $("#modalCreateUpdateLabel").html("Registrar datos del Administrador");
        // clearCheck();
        clearForm();
        $("#modalCreateUpdate").modal("show");
    });
    // FIN - MODAL CREATE

    // INICIO - MODAL UPDATE
    $("#list_evaluaciones").on("click", ".editBtn", function () {
        //cambiar el text del button
        $("#btnCreateUpdate").html("Actualizar");
        $("#modalCreateUpdateLabel").html("Actualizar datos del Administrador");
        // setear data de usuario
        $("#dt-idscheduleingcalendar").val($(this).data("idscheduleingcalendar"));
        $("#dt-subject_id").val($(this).data("subject_id"));
        $("#dt-gradetype_id").selectpicker("val", $(this).attr("data-gradetype_id"));
        $("#dt-nombre_evento").val($(this).data("nombre_evento"));
        $("#dt-fecinicio").val($(this).data("fecinicio"));
        $("#dt-horaini").val($(this).data("horaini"));
        $("#dt-horafin").val($(this).data("horafin"));
        $("#dt-archivo").val("");
        $("#dt-descripcion").val($(this).data("descripcion"));
        $("#dt-estado").val($(this).data("estado"));
        // show form
        $("#modalCreateUpdate").modal("show");
        // change value
        $("#btnCreateUpdate").attr("value", "Update");
    });
    // FIN - MODAL UPDATE

    // INICIO - MODAL DELETE
    $("#list_evaluaciones").on("click", ".deleteBtn", function (e) {
        let idscheduleingcalendar = $(this).data("idscheduleingcalendar")
        // confirmacion
        confirmation_sweetAlert("Deseas continuar?", "Se procederá a eliminar el registro de la base de datos", "warning")
            .then(function (isConfirm) {
                if (isConfirm.value) {
                    // enviando el parametro de la data que se procede a delete
                    destroy(idscheduleingcalendar);
                } else {
                    console.log("Cancelado");
                }
            });
    });
    // FIN - MODAL DELETE

    var formCheck, valbtn;
    $('#btnCreateUpdate').on('click', function (event) {
        // Iterar sobre los formularios y evitar la acción predeterminada si no son válidos
        // formCheck = $("#formModal")[0];
        // if (!formCheck.checkValidity()) {
        //     event.preventDefault();
        //     event.stopPropagation();
        //     $(formCheck).addClass('was-validated'); // añadir validaciones
        // } else {
            valbtn = $("#btnCreateUpdate").val();
            // FUNCION CREAR
            if (valbtn === "Create") {
                // insertar
                store();
            }
            // FUNCION ACTUALIZAR
            if (valbtn === "Update") {
                // actualizar
                update($("#dt-idscheduleingcalendar").val());
            }
        // }
    });



    //--------- F U N C I O N E S --------------//
    cb_tipo_programacion()
    function cb_tipo_programacion() {
        $.ajax({
            type: "GET",
            url: "/docente/programacion/ajax_all/tipoprogramacion",
            dataType: "json",
            beforeSend: function () { },
            success: function (response) {
                // $("#txt-identificationtype").append('<option selected disabled value="">Seleccione una opcion</option>');
                response.forEach((elemento) => {
                    $("#dt-gradetype_id").append('<option ' +
                        'value="' + elemento.id + '" ' +
                        'data-tipo="' + elemento.nombre + '"' +
                        ' >' + elemento.nombre + '</option>');
                })
                $("#dt-gradetype_id").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    cb_semesters();
    function cb_semesters() {
        $("#txt-semestre").find("option").remove().end() // delete options
        $.ajax({
            type: "GET",
            url: '/ajax_all/semestersDocentes',
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt-semestre").append('<option selected disabled value="">Selecciona un semestre</option>');
                response.forEach((elemento) => {
                    $("#txt-semestre").append('<option' +
                        ' value="' + elemento.id + '" ' +
                        ' data-anho="' + elemento.anho + '" ' +
                        ' data-numero="' + elemento.numero + '" ' +
                        ' data-fecinicio="' + elemento.fecinicio + '" ' +
                        ' data-fecfin="' + elemento.fecfin + '" ' +
                        '>' + elemento.anho + " - " + elemento.numero + '</option>');
                })
                $("#txt-semestre").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function cb_subjects(idsemester) {
        $("#txt-asignatura").find("option").remove().end() // delete options
        $.ajax({
            type: "GET",
            url: "/docente/materiales_recursos/ajax_all/asignaturas/" + idsemester,
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt-asignatura").append('<option selected disabled value="">Selecciona una asignatura</option>');
                response.forEach((elemento) => {
                    $("#txt-asignatura").append('<option' +
                        ' value="' + elemento.id + '" ' +
                        ' data-namecurso="' + elemento.namecurso + '" ' +
                        '>' + elemento.namecurso + " - Sec:" + elemento.seccion + '</option>');
                })
                $("#txt-asignatura").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }


    function store() {
        var formData = new FormData(document.getElementById('formModal'));
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'POST',
            url: '/docente/programacion/evaluaciones/store',
            data: formData,
            processData: false,
            contentType: false,
            success: function (data) {
                // Validators
                if (data.status == 'validators') {
                    for (var campo in data.mensaje) {
                        if (data.mensaje.hasOwnProperty(campo)) {
                            var mensajes = data.mensaje[campo];
                            for (var i = 0; i < mensajes.length; i++) {
                                var mensaje = mensajes[i];
                                // console.log("campo: " + campo + ", mensaje: " + mensaje);
                                notificaciontoast("error", mensaje, "Error!", "bottom-right", 3000);
                            }
                        }
                    }
                }
                if (data.status == true) {
                    notificaciontoast('info', data.mensaje, 'Éxito!')
                    $("#modalCreateUpdate").modal("hide");
                    functionCalendarioprogramacion(idsemester);
                    Eventos_programados_asignados(idsubject);
                } else if (data.status == false) 
                {
                    notificaciontoast('error', data.mensaje, 'Error!')
                }
            },
            error: function (error) {
                console.log('Error', error)
            }
        })
    }

    var formData;
    function update(idscheduleingcalendar) {
        formData = new FormData(document.getElementById('formModal'));
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'POST',
            url: '/docente/programacion/evaluaciones/update/' + idscheduleingcalendar,
                data: formData,
                processData: false,
                contentType: false,
            success: function (data) {
                if (data.status == true) {
                    // formModal.addClass("was-validated");    // añadir validaciones
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () { $("#modalCreateUpdate").modal("hide"); }, 1000);   // ocultar despues de 1 sec
                    functionCalendarioprogramacion(idsemester);
                    Eventos_programados_asignados(idsubject);
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log('Error', error)
            }
        })
    }

    function destroy(idscheduleingcalendar) {
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: "DELETE",
            url: '/docente/programacion/evaluaciones/delete/' + idscheduleingcalendar,
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    functionCalendarioprogramacion(idsemester);
                    Eventos_programados_asignados(idsubject);
                    notificaciontoast("info", data.mensaje, "Éxito!");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function clearForm() {
        // $("#dt-subject_id").val("");
        // $("#text_asignatura").val("");
        $("#dt-idscheduleingcalendar").selectpicker("val", "");
        $("#dt-gradetype_id").selectpicker("val", "");
        $("#dt-nombre_evento").val("");
        $("#dt-fecinicio").val("");
        $("#dt-horaini").val("");
        $("#dt-horafin").val("");
        $("#dt-archivo").val("");
        $("#dt-descripcion").val("");
    }
});


