//"use strict";
import { notificaciontoast } from "../jsAjaxToastSweetalert/method_toast.js";
import { confirmation_sweetAlert } from "../jsAjaxToastSweetalert/method_sweetAlert.js";

$(document).ready(function () {
    const tableName = "Notas ";
    var dt_idsubject = "null",
        dt_scheduleingcalendar_id = "null",
        dt_idevaluateprogramming = "null",
        dt_idteacher = "null";


    // LISTAR DATATABLE CURSOS
    var table_cursos = $("#datatableGeneralCursos").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: "/docente/notas/list_cursos",
        },

        searching: false,
        // dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        columns: [
            { data: "programa", className: "text-center bg-primary", sortable: false },
            { data: "plan", className: "text-center bg-primary", sortable: false },
            { data: "periodo", className: "text-center bg-primary", sortable: false },
            { data: "codcurso", className: "text-center bg-primary", sortable: false },
            { data: "curso", className: "text-center bg-primary", sortable: false },
            { data: "tipo", className: "text-center bg-primary", sortable: false },
            { data: "creditos_horas", className: "text-center bg-primary", sortable: false },
            { data: "condicion", className: "text-center bg-primary", sortable: false },
            { data: "seccion", className: "text-center bg-primary", sortable: false },
            { data: "turno", className: "text-center bg-primary", sortable: false },
            { data: "accion", className: "text-center noExport", sortable: false, searchable: false,
                render: function (data, type, all, meta) {
                    return `
                            <div class="d-flex justify-content-center">
                                <a href="javascript:void(0);" class="viewsScheduleingcalendarBtn btn btn-info shadow btn-xs sharp me-1"
                                data-idsubject="${all.idsubject}"
                                data-idteacher="${all.idteacher}"
                                data-programa="${all.programa}"
                                data-plan="${all.plan}"
                                data-periodo="${all.periodo}"
                                data-curso="${all.curso}"
                                data-bs-placement="top"
                                title="Ver Evaluaciones">
                                <i class="fa-solid fa-eye fa-fade fa-xl"></i>
                                </a>
                            </div>
                            `;
                },
            },
        ],
    });




    // Ver cursos
    $("#datatableGeneralCursos tbody").on("click", ".viewsScheduleingcalendarBtn", function (e) {
        dt_idsubject = $(this).data("idsubject");
        dt_idteacher = $(this).data("idteacher");
        $("#data-programa").val($(this).data("programa"));
        $("#data-plan").val($(this).data("plan"));
        $("#data-periodo").val($(this).data("periodo"));
        $("#data-curso").val($(this).data("curso"));
        table_evaluaciones.ajax.reload();
    });




    // LISTAR DATATABLE NOTAS
    var table_evaluaciones = $("#datatableGeneralEvaluaciones").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: "/docente/notas/list_evaluaciones",
            data: function (d) {
                d.idsubject = dt_idsubject;
            }
        },
        searching: true,
        // dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        columns: [
            // { data: "n", className: "text-center bg-primary", sortable: false },
            { data: "nombre_evento", className: "text-center bg-primary", sortable: false },
            { data: "tipo_nota", className: "text-center bg-primary", sortable: false },
            { data: "fecinicio", className: "text-center bg-primary", sortable: false },
            { data: "horaini", className: "text-center bg-primary", sortable: false },
            { data: "horafin", className: "text-center bg-primary", sortable: false },
            { data: "accion", className: "text-center noExport", sortable: false, searchable: false,
                render: function (data, type, all, meta) {
                    return `
                            <div class="d-flex justify-content-center">
                                <a href="javascript:void(0);" class="viewsStudentBtn btn btn-info shadow btn-xs sharp me-1"
                                data-scheduleingcalendar_id="${all.scheduleingcalendar_id}" 
                                data-nombre_evento="${all.nombre_evento}" 
                                data-fecinicio="${all.fecinicio}" 
                                data-horaini="${all.horaini}" 
                                data-horafin="${all.horafin}" 
                                data-bs-placement="top"
                                title="Ver Estudiante">
                                <i class="fa-solid fa-eye fa-fade fa-xl"></i>
                                </a>
                            </div>
                            `;
                },
            },
        ],
    });




    // Ver Estudiantes
    $("#datatableGeneralEvaluaciones tbody").on("click", ".viewsStudentBtn", function (e) {

        dt_scheduleingcalendar_id = $(this).data("scheduleingcalendar_id");
        $("#data-nombre_evento").val($(this).data("nombre_evento"));
        $("#data-fecinicio").val($(this).data("fecinicio"));
        $("#data-horaini").val($(this).data("horaini"));
        $("#data-horafin").val($(this).data("horafin"));

        // show form
        table_estudiantes.ajax.reload();
        // $("#modalCreateUpdate").modal("show");
    });




    // LISTAR DATATABLE NOTAS
    var table_estudiantes = $("#datatableGeneralEstudiantes").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: "/docente/notas/list_estudiantes",
            data: function (d) {
                d.scheduleingcalendar_id = dt_scheduleingcalendar_id;
            }
        },
        searching: true,
        // dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        columns: [
            // { data: "n", className: "text-center bg-primary", sortable: false },
            { data: "identificacion", className: "text-center bg-primary", sortable: false }, 
            { data: "estudiante", className: "text-center bg-primary", sortable: false }, 
            { data: "archivo", className: "text-center", sortable: false, 
                render: function (data, type, all, meta) { 
                    if (all.idevaluateprogramming != 0) { 
                        return ` 
                            <div class="d-flex justify-content-center"> 
                                <a href="/alumno/programacion/evaluaciones/viewLoadFile/${all.idevaluateprogramming}" target="_blank" class="viewFileBtn btn btn-primary shadow btn-xs sharp me-2"
                                    data-bs-placement="top" 
                                    title="Ver Documento"> 
                                    <i class="fa-solid fa-eye fa-lg"></i> 
                                </a> 
                            </div> 
                        `; 
                    } else { 
                        return `<div class="d-flex justify-content-center">-</div>`; 
                    } 
                }, 
            },
            { data: "nota", className: "text-center bg-primary", sortable: false },
            { data: "estado", className: "text-center", sortable: false,
                render: function (data, type, all, meta) {
                    if (all.nota == "-") {
                        return `<span class="badge light badge-dark">Sin evaluar</span>`;
                    } else if (all.nota < 12.5) {
                        return `<span class="badge light badge-danger">Desaprobado</span>`;
                    } else if (all.nota >= 12.5) {
                        return `<span class="badge light badge-success">Aprobado</span>`;
                    }
                },
            },
            { data: "accion", className: "text-center noExport", sortable: false, searchable: false,
                render: function (data, type, all, meta) {
                    return `
                            <div class="d-flex justify-content-center">
                                <a href="javascript:void(0);" class="editBtn btn btn-dark shadow btn-xs sharp me-1"
                                data-idevaluateprogramming="${all.idevaluateprogramming}"
                                data-scheduleingcalendar_id="${all.scheduleingcalendar_id}" 
                                data-idstudent="${all.idstudent}"  
                                data-estudiante="${all.estudiante}" 
                                data-nota="${all.nota}" 
                                data-bs-placement="top"
                                title="Editar nota">
                                <i class="fa-solid fa-pencil fa-fade fa-xl"></i>
                                </a>
                            </div>
                            `;
                },
            },
        ],
    });


    // Ver Estudiantes
    $("#datatableGeneralEstudiantes tbody").on("click", ".editBtn", function (e) {

        $("#txt-idevaluateprogramming").val($(this).data("idevaluateprogramming"));
        $("#txt-scheduleingcalendar_id").val($(this).data("scheduleingcalendar_id"));
        $("#txt-idstudent").val($(this).data("idstudent"));
        $("#txt-estudiante").val($(this).data("estudiante"));
        $("#txt-nota").val($(this).data("nota"));
        
        // show form
        $("#modalCreateUpdate").modal("show");
    });


    var formCheck;


    // INICIO - FUNCION CREATE O UPDATE
    $("#btnCreateUpdate").on("click", function (event) {
        event.preventDefault();
        // Iterar sobre los formularios y evitar la acción predeterminada si no son válidos
        formCheck = $("#formModal")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
            $(formCheck).addClass('was-validated'); // añadir validaciones
        } else {
            // actualizar
            var id = document.getElementById("txt-idevaluateprogramming").value;
            if(id != 0) {
                update_nota();
            } else {
                store_nota();
            }
        }
    });
    // FIN - FUNCION CREATE O UPDATE




    var formModal;

    function store_nota() {
        formModal = $('#formModal');
        $.ajax({
            type: "POST",
            url: '/docente/notas/gestionar_nota/store_nota',
            data: formModal.serialize(),
            dataType: 'json',
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table_estudiantes.ajax.reload();
                    formModal.addClass("was-validated");    // añadir validaciones
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () { $("#modalCreateUpdate").modal("hide"); }, 1000); // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function update_nota() {
        formModal = $('#formModal');
        var id = document.getElementById("txt-idevaluateprogramming").value;
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'PUT',
            url: '/docente/notas/gestionar_nota/update_nota/' + id,
            data: formModal.serialize(),
            dataType: 'json',
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table_estudiantes.ajax.reload();
                    formModal.addClass("was-validated");
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () { $("#modalUpdate").modal("hide"); }, 500);
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log('Error', error)
            }
        });
    }

});
