//"use strict";
import { notificaciontoast } from "../jsAjaxToastSweetalert/method_toast.js";
import { confirmation_sweetAlert } from "../jsAjaxToastSweetalert/method_sweetAlert.js";

$(document).ready(function () {
    const tableName = "General de Horarios";

    //LISTAR DATATABLE
    var dt_idsemester = 0, dt_idsubject =  0, dt_idclass = 0;

    var table = $("#datatableGeneral").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: 'POST',
            url: '/docente/asistencias/list_students',
            data: function (d) {
                d.idsemester = dt_idsemester,
                d.idsubject = dt_idsubject,
                d.idsubjectclass = dt_idclass;
            },
        },
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: {
            search: 'Buscar',
            info: 'Mostrando _START_ a _END_ de _TOTAL_ Registros',
            zeroRecords: 'No hay registros para mostrar.',
            infoFiltered: '(Filtrados de _MAX_ Registros)',
            emptyTable: 'La tabla está vacia.',
            infoEmpty: 'No hay registros',
            paginate: {
                next: '<i class="fa-solid fa-angle-right"></i>',
                previous: '<i class="fa-solid fa-angle-left"></i>'
            }
        },
        buttons: [
            {
                extend: "excel",
                title: function () {
                    return (
                        "Reporte de Horarios " + semester
                    );
                },
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
            {
                extend: "pdf",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded ",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
            {
                extend: "print",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
            {
                extend: "colvis",
                text: "Seleccionar celdas",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
        ],
        columns: [
            { data: "identificacion", className: "text-center bg-primary", },
            { data: "estudiante", className: "text-center bg-primary", },
            { data: "estado_asistencia", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.estado_asistencia == "0") {
                        return `<span class="badge light badge-dark">Sin evaluar</span>`;
                    } else if (all.estado_asistencia == "1") {
                        return `<span class="badge light badge-success">Asistio</span>`;
                    } else if (all.estado_asistencia == "2") {
                        return `<span class="badge light badge-warning">Tardanza</span>`;
                    } else if (all.estado_asistencia == "3") {
                        return `<span class="badge light badge-danger">No Asistio</span>`;
                    }
                },
            },
            { data: "estado_clase", sortable: false, className: "text-center noExport",
                render: function (data, type, all, meta) {
                    if (all.estado_asistencia == "0") {
                        return `
                        <i class="fa-solid fa-circle" aria-hidden="true"></i>
                        <select class="editBtn default-select"
                            data-idattendance="${all.idattendance}"
                            data-idsubjectenrollment="${all.idsubjectenrollment}"
                            data-idsubjectclass="${all.idsubjectclass}"
                            data-estado_asistencia="0"
                        >
                            <option selected value="0">Seleccionar</option>
                            <option value="1">Asistió</option>
                            <option value="2">Tardanza</option>
                            <option value="3">No Asistió</option>
                        </select>
                        `;
                    } else if (all.estado_asistencia == "1") {
                        return `
                        <i class="fa-solid fa-circle text-success" aria-hidden="true"></i>
                        <select class="editBtn default-select"
                            data-idattendance="${all.idattendance}"
                            data-idsubjectenrollment="${all.idsubjectenrollment}"
                            data-idsubjectclass="${all.idsubjectclass}"
                            data-estado_asistencia="1"
                        >
                            <option selected value="1">Asistió</option>
                            <option value="2">Tardanza</option>
                            <option value="3">No Asistió</option>
                        </select>
                        `;
                    } else if (all.estado_asistencia == "2") {
                        return `
                        <i class="fa-solid fa-circle text-warning" aria-hidden="true"></i>
                        <select class="editBtn default-select"
                            data-idattendance="${all.idattendance}"
                            data-idsubjectenrollment="${all.idsubjectenrollment}"
                            data-idsubjectclass="${all.idsubjectclass}"
                            data-estado_asistencia="2"
                        >
                            <option value="1">Asistió</option>
                            <option selected value="2">Tardanza</option>
                            <option value="3">No Asistió</option>
                        </select>
                        `;
                    } else if (all.estado_asistencia == "3") {
                        return `
                        <i class="fa-solid fa-circle text-danger" aria-hidden="true"></i>
                        <select class="editBtn default-select"
                            data-idattendance="${all.idattendance}"
                            data-idsubjectenrollment="${all.idsubjectenrollment}"
                            data-idsubjectclass="${all.idsubjectclass}"
                            data-estado_asistencia="3"
                        >
                            <option value="1">Asistió</option>
                            <option value="2">Tardanza</option>
                            <option selected value="3">No Asistió</option>
                        </select>
                        `;
                    }
                },
            },
        ],
        // rowsGroup: [
        //     'primero:name',
        // ],
        // orderFixed: [0, 'asc'],
    });


    //--------- F U N C I O N E S --------------//
    function tl_subjects(idsemester) {
        $.ajax({
            type: "GET",
            url: '/docente/materiales_recursos/ajax_all/asignaturas/' + idsemester,
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                response.forEach((elemento) => {
                    document.getElementById("tlsubject").innerHTML +=
                        "<li class=''>" +
                        "<div class='divsubject timeline-badge primary'></div>" +
                        "<a class='btnSubject timeline-panel text-muted px-2 py-1 mr-4 ml-2' href='javascript:void(0);' " +
                            "data-idsubject='" + elemento.id + "'" +
                            "data-codcurso='" + elemento.codcurso + "'" +
                            "data-curso='" + elemento.namecurso + "'" +
                            "data-seccion='" + elemento.seccion + "'" + ">" +
                            "<h6 class='mb-0'>" + "<strong class='text-info'>" + elemento.namecurso + "</strong>" +
                            "<br>Seccion: " + elemento.seccion  + "</h6>" +
                        "</a>" +
                        "</li>"
                });
            },
            error: function (error) { console.log("Error", error);  },
        });
    }


    // listar subjectclasses
    function tl_subjectclasses(idsubject) {
        $.ajax({
            type: "GET",
            url: '/ajax_all/teachers/subjectclasses/' + idsubject,
            dataType: 'json',
            beforeSend: function () {
            },
            success: function (response) {
                $('#tlsubjectclass').html('');
                response.forEach((elemento) => {
                    document.getElementById("tlsubjectclass").innerHTML +=
                        "<li class=''>" +
                        "<div class='divsubjectclass timeline-badge primary'></div>" +
                        "<a class='btnSubjectclass timeline-panel text-muted px-2 py-1 mr-4 ml-2' href='javascript:void(0);' " +
                            "data-idclass='" + elemento.idclass + "'" +
                            "data-dia='" + elemento.dia + "'" +
                            "data-horaini='" + elemento.horaini + "'" +
                            "data-horafin='" + elemento.horafin + "'" +
                        ">" +
                            "<h6 class='mb-0'>" + "<strong class='text-info'>" +
                                elemento.clase + " - " +
                                elemento.dia + "</strong>" +
                                " <br> " +
                                elemento.horaini2 +
                                " - " +
                                elemento.horafin2 +
                            "</h6>" +
                        "</a>" +
                        "</li>"
                });
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // on change semestres
    $(document).on("click", ".btnSemester", function () {
        dt_idsemester = $(this).attr("data-idsemester");
        $(".divsemester").removeClass("warning").addClass("primary");
        $(this).prev("div").removeClass("primary").addClass("warning");
        notificaciontoast("info", "Consultando a la  base de datos!", "Mensaje!");
        tl_subjects(dt_idsemester);
        table.ajax.reload();
    });


    // on change asignaturas
    $(document).on("click", ".btnSubject", function () {
        dt_idsubject = $(this).attr("data-idsubject");
        $(".divsubject").removeClass("success").addClass("primary");
        $(this).prev("div").removeClass("primary").addClass("success");
        document.getElementById("tlsubjectclass").innerHTML = "";
        tl_subjectclasses(dt_idsubject);
        // limpiar tabla
        table.ajax.reload();
    });


    // on change clases_asignaturas
    $(document).on("click", ".btnSubjectclass", function () {
        dt_idclass = $(this).attr("data-idclass");
        $(".divsubjectclass").removeClass("success").addClass("primary");
        $(this).prev("div").removeClass("primary").addClass("success");
        // limpiar tabla
        table.ajax.reload();
    });


    $("#datatableGeneral tbody").on("change", ".editBtn", async function (e) {

        document.getElementById("txt-idsubjectclass").value = $(this).attr("data-idsubjectclass");
        document.getElementById("txt-idsubjectenrollment").value = $(this).attr("data-idsubjectenrollment");
        document.getElementById("txt-estado_asistencia").value = $(this).val();

        var id = $(this).attr("data-idattendance");

        var formData = $("#formModal").serialize();
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "PUT",
            url: "/docente/asistencias/update/" + id,
            data: formData,
            dataType: "json",
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    // let pagina_seleccionada = $('#myTabContent-2 .paginate_button.current').attr('data-dt-idx');
                    table.ajax.reload();
                    notificaciontoast("info", data.mensaje, "Éxito!");
                } else {
                    notificaciontoast(
                        "error",
                        data.mensaje.txt_idrol_name[0],
                        "Error!"
                    );
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    });

});
