"use strict";

import { notificaciontoast } from "../jsAjaxToastSweetalert/method_toast.js";
import { confirmation_sweetAlert } from "../jsAjaxToastSweetalert/method_sweetAlert.js";

$(document).ready(function () {


    const tableName = "Tramites documentarios ";

    // LISTAR DATATABLE
    var datatableGeneral = $("#datatableGeneral").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            url: '/alumno/tramites/documentarios/list',
            dataSrc: 'data'
        },
        pageLength: 12, // 12 filas
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: {
            search: 'Buscar',
            info: 'Mostrando _START_ a _END_ de _TOTAL_ Registros',
            zeroRecords: 'No hay registros para mostrar.',
            infoFiltered: '(Filtrados de _MAX_ Registros)',
            emptyTable: 'La tabla está vacia.',
            infoEmpty: 'No hay registros',
            paginate: {
                next: '<i class="fa-solid fa-angle-right"></i>',
                previous: '<i class="fa-solid fa-angle-left"></i>'
            }
        },
        buttons: [
            {
                extend: "excel",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
            {
                extend: "pdf",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded ",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
            {
                extend: "print",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
            {
                extend: "colvis",
                txt: "Seleccionar celdas",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
        ],
        columns: [
            { data: "areadestino", className: "text-start",
                render: function (data, type, all, meta) {
                    return "<strong class='text-primary'>" + all.areadestino + "</strong>"
                },
                name: "primero",
            },
            { data: "codigosolicitud", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                        return ( all.codigosolicitud );
                },
            },
            { data: "comprobante", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                        return ( all.comprobante );
                },
            },
            { data: "asunto", sortable: false, className: "text-start",
                render: function (data, type, all, meta) {
                        return ( all.asunto );
                },
            },
            { data: "folio", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                        return ( all.folio );
                },
            },
            { data: "ruta_archivo", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    return  `<a href="/alumno/tramite/documentario/verDocSolicitante/${all.nroidenti}/${all.comprobante}/${all.codigosolicitud}/${all.nombredoc}"  target="_blank" data-bs-placement="top"  title="Documento del remitente" class="text-danger">
                                <i class="fa-solid fa-file-pdf"></i>
                            </a>`;
                },
            },
            { data: "estado", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.estado == "1") {
                        return `<span class="badge light badge-danger">Pendiente</span>`;
                    } else if (all.estado == "2")  {
                        return `<span class="badge light badge-info">En proceso</span>`;
                    } else if (all.estado == "3") {
                        return `<span class="badge light badge-primary">Finalizado</span>`;
                    }
                },
            },
        ],
        rowsGroup: [
            'primero:name',
        ],
        orderFixed: [0, 'asc'], // Fija el orden por defecto de la primera columna
    });


    var datatableGeneralFinalizados = $("#datatableGeneralFinalizados").DataTable({
            createdRow: function (row, data, index) {
                $(row).addClass("selected");
            },
            order: [],
            ajax:{
                url: '/alumno/tramites/documentarios/listfinalizados',
                dataSrc: 'data'
              },
            pageLength: 12, // 12 filas
            searching: true,
            dom: "Bfrtip",
            select: false,
            lengthChange: false,
            responsive: true,
            language: {
                search: 'Buscar',
                info: 'Mostrando _START_ a _END_ de _TOTAL_ Registros',
                zeroRecords: 'No hay registros para mostrar.',
                infoFiltered: '(Filtrados de _MAX_ Registros)',
                emptyTable: 'La tabla está vacia.',
                infoEmpty: 'No hay registros',
                paginate: {
                    next: '<i class="fa-solid fa-angle-right"></i>',
                    previous: '<i class="fa-solid fa-angle-left"></i>'
                }
            },
            buttons: [
                {
                    extend: "excel",
                    title: "Reporte de " + tableName,
                    type: "button",
                    orientation: "landscape",
                    className: "btn btn-sm btn-arounded",
                    exportOptions: {
                        columns: ":visible",
                        orthogonal: "print",
                    },
                },
                {
                    extend: "pdf",
                    title: "Reporte de " + tableName,
                    type: "button",
                    orientation: "landscape",
                    className: "btn btn-sm btn-arounded ",
                    exportOptions: {
                        columns: ":visible",
                        orthogonal: "print",
                    },
                },
                {
                    extend: "print",
                    title: "Reporte de " + tableName,
                    type: "button",
                    orientation: "landscape",
                    className: "btn btn-sm btn-arounded",
                    exportOptions: {
                        columns: ":visible",
                        orthogonal: "print",
                    },
                },
                {
                    extend: "colvis",
                    txt: "Seleccionar celdas",
                    title: "Reporte de " + tableName,
                    type: "button",
                    orientation: "landscape",
                    className: "btn btn-sm btn-arounded",
                    exportOptions: {
                        columns: ":visible",
                        orthogonal: "print",
                    },
                },
            ],
            columns: [
                {
                    data: "areaorigen",
                    className: "text-start",

                    render: function (data, type, all, meta) {
                        return "<strong class='text-primary'>" + all.areaorigen + "</strong>"
                    },
                    name: "primero",
                },
                {
                    data: "codigosolicitud",
                    sortable: false,
                    className: "text-center",

                    render: function (data, type, all, meta) {
                            return ( all.codigosolicitud );
                    },
                },
                {
                    data: "comprobante",
                    sortable: false,
                    className: "text-center",

                    render: function (data, type, all, meta) {
                            return ( all.comprobante );
                    },
                },
                {
                    data: "asunto",
                    sortable: false,
                    className: "text-start",

                    render: function (data, type, all, meta) {
                            return ( all.asunto );
                    },
                },
                {
                    data: "folio",
                    sortable: false,
                    className: "text-center",

                    render: function (data, type, all, meta) {
                            return ( all.folio );
                    },
                },
                {
                    data: "nombredoc",
                    sortable: false,
                    className: "text-center",

                    render: function (data, type, all, meta) {
                        return  `<a href="/alumno/tramite/documentario/verDocSolicitante/${all.nroidenti}/${all.comprobante}/${all.codigosolicitud}/${all.nombredoc}"  target="_blank" data-bs-placement="top"  title="Documento del remitente" class="text-danger">
                                    <i class="fa-solid fa-file-pdf"></i>
                                </a>`;
                    },
                },
                {
                    data: "namedocemitido",
                    sortable: false,
                    className: "text-center",

                    render: function (data, type, all, meta) {
                        return  `<a href="/alumno/tramite/documentario/verDocSolicitante/${all.nroidenti}/${all.comprobante}/${all.codigosolicitud}/${all.namedocemitido}"  target="_blank" data-bs-placement="top"  title="Documento del remitente" class="text-danger">
                                    <i class="fa-solid fa-file-pdf"></i>
                                </a>`;
                    },
                },
                {
                    data: "estado",
                    sortable: false,
                    className: "text-center",
                    render: function (data, type, all, meta) {
                        if (all.estado == "1") {
                            return `<span class="badge light badge-danger">Pendiente</span>`;
                        } else if (all.estado == "2")  {
                            return `<span class="badge light badge-info">En proceso</span>`;
                        } else if (all.estado == "3") {
                            return `<span class="badge light badge-primary">Finalizado</span>`;
                        }
                    },
                },
            ],
// Fija el orden por defecto de la primera columna
    });

    $('#btnRefresh').click(function(){
        notificaciontoast("warning", " Actualizando tablas! ", "Mensaje!");
        datatableGeneral.ajax.reload();
        datatableGeneralFinalizados.ajax.reload();
    });

});

