import { notificaciontoast } from "../jsAjaxToastSweetalert/method_toast.js";
import { confirmation_sweetAlert } from "../jsAjaxToastSweetalert/method_sweetAlert.js";

$(document).ready(function () {

    const tableName = "Postulaciones";
    var dt_idcompany="all", dt_idcategory="all";

    // LISTAR DATATABLE
    var table = $('#datatableGeneral').DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'POST',
            url: '/admin/bolsa_laboral/postulaciones/list',
            data: function (d) {
                d.idcompany = dt_idcompany;
                d.idcategory = dt_idcategory;
            },
        },
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: {
            search: 'Buscar',
            info: 'Mostrando _START_ a _END_ de _TOTAL_ Registros',
            zeroRecords: 'No hay registros para mostrar.',
            infoFiltered: '(Filtrados de _MAX_ Registros)',
            emptyTable: 'La tabla está vacia. Selecciones una empresa y categoría.',
            infoEmpty: 'No hay registros',
            paginate: {
                next: '<i class="fa-solid fa-angle-right"></i>',
                previous: '<i class="fa-solid fa-angle-left"></i>'
            }
        },
        buttons: [
            {
                extend: "excel",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    columns: ":not(.noExport)",
                    orthogonal: "print"
                },
            },
            {
                extend: "pdf",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded ",
                exportOptions: {
                    columns: ":visible",
                    columns: ":not(.noExport)",
                    orthogonal: "print"
                },
            },
            {
                extend: "print",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    columns: ":not(.noExport)",
                    orthogonal: "print"
                },
            },
            {
                extend: "colvis",
                text: "Seleccionar celdas",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    columns: ":not(.noExport)",
                    orthogonal: "print"
                },
            },
        ],
        columns: [
            { data: 'idjobapplication', className: 'text-center' },
            { data: 'nombrecompany', className: 'text-center' },
            { data: 'puesto', className: 'text-center' },
            { data: 'nombres', className: 'text-center' },
            { data: 'correo', className: 'text-center' },
            { data: 'celular', className: 'text-center' },
            { data: 'fecaplicacion', className: 'text-center' },
            { data: "estadojobapplication", className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.isvisto == "1" && all.estadojobapplication == "2") {
                        return `<span class="btn btn-info btn-sm btn-rounded">CV revisado</span>`;
                    } else if (all.estadojobapplication == "2") {
                        return `<span class="btn btn-dark btn-sm btn-rounded">Pendiente</span>`;
                    } else if (all.estadojobapplication == "1") {
                        return `<span class="btn btn-success btn-sm btn-rounded">Aprobado</span>`;
                    } else if (all.estadojobapplication == "0") {
                        return `<span class="btn btn-dark btn-sm btn-rounded">Rechazado</span>`;
                    } else if (all.estadojobapplication == "3") {
                        return `<span class="btn btn-success btn-sm btn-rounded">Seleccionado</span>`;
                    }
                },
            },
            { data: "idjobapplication", className: "text-center noExport", sortable: false, searchable: false,
                render: function (data, type, all, meta) {
                    return `
                            <div class="d-flex justify-content-center">

                                <a href="javascript:void(0);" class="btnAprobar btn btn-success shadow btn-xs sharp me-2 rounded-circle"
                                data-idjobapplication="${all.idjobapplication}"
                                data-bs-placement="top"
                                title="Aprobar CV">
                                <i class="fas fa-check fa-lg"></i>
                                </a>

                                <a href="javascript:void(0);" class="btnRechazar btn btn-dark shadow btn-xs sharp me-2 rounded-circle"
                                data-idjobapplication="${all.idjobapplication}"
                                data-bs-placement="top"
                                title="Rechazar CV">
                                <i class="fas fa-x fa-lg"></i>
                                </a>

                                <a href="/verCurriculumVitae/admin/${all.idjobapplication}" target="_blank" class="btnVerCurriculumVitae btn btn-info shadow btn-xs sharp me-2 rounded-circle"
                                data-bs-placement="top"
                                title="Ver CV">
                                <i class="fas fa-eye fa-lg"></i>
                                </a>

                                <a href="javascript:void(0);" class="deleteBtn btn btn-dark shadow btn-xs sharp rounded-circle"
                                data-idjobapplication="${all.idjobapplication}"
                                data-bs-placement="top"
                                title="Eliminar registro">
                                <i class="fas fa-trash fa-lg"></i>
                                </a>

                            </div>

                            `;
                },
            },
        ]
    });

    // Agregar una columna de números automáticos
    table.on('order.dt search.dt', function () {
        table.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
            cell.innerHTML = i + 1;
        });
    }).draw();


    $(document).on("change", "#txt-companies", function () {
        dt_idcompany = $(this).val();
        notificaciontoast("info", "Consultando a la  base de datos!", "Mensaje!");
        table.ajax.reload();
    });


    $(document).on("change", "#txt-categories", function () {
        dt_idcategory = $(this).val();
        notificaciontoast("info", "Consultando a la  base de datos!", "Mensaje!");
        // limpiar tabla
        table.ajax.reload();
    });
    

    var valbtn, formCheck, formModal;

    // INICIO - MODAL APROBAR
    $("#datatableGeneral tbody").on("click", ".btnAprobar", function (e) {
        formCheck = $("#formModal")[0];
        $(formCheck).removeClass('was-validated'); // remover validaciones
        $('#txt-idjobapplication').val($(this).data("idjobapplication"));
        $("#div-feedback-rechazar").css("display", "none");     // ocultar div
        $("#div-feedback-aprobar").removeAttr("style");         // mostrar div
        $('#txt-feedback').val('');
        $("#btnAprobarRechazar").attr("value", "Aprobar");
        $("#btnAprobarRechazar").html("Aprobar");
        $("#modalFeedback").modal("show");
    });
    // FIN - MODAL APROBAR


    // INICIO - MODAL RECHAZAR
    $("#datatableGeneral tbody").on("click", ".btnRechazar", function (e) {
        formCheck = $("#formModal")[0];
        $(formCheck).removeClass('was-validated'); // remover validaciones
        $('#txt-idjobapplication').val($(this).data("idjobapplication"));
        $("#div-feedback-aprobar").css("display", "none");     // ocultar div
        $("#div-feedback-rechazar").removeAttr("style");         // mostrar div
        $('#txt-feedback').val('');
        $("#btnAprobarRechazar").attr("value", "Rechazar");
        $("#btnAprobarRechazar").html("Rechazar");
        $("#modalFeedback").modal("show");
    });
    // FIN - MODAL RECHAZAR

    // INICIO - VER CV
    $("#datatableGeneral tbody").on("click", ".btnVerCurriculumVitae", function (e) {
        setTimeout(() => {
            table.ajax.reload();
        }, 2000);
    });
    // FIN - VER CV


    // on click feedback predeterminado
    $("#formModal").on("click", ".feedback-predeterminado", function (e) {
        let comentario = $(this).val()
        $('#txt-feedback').val(comentario)
    });

    // INICIO - FUNCION APROBAR O RECHAZAR
    $("#btnAprobarRechazar").on("click", function (event) {
        event.preventDefault();
        // Iterar sobre los formularios y evitar la acción predeterminada si no son válidos
        formCheck = $("#formModal")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
        } else {
            valbtn = $("#btnAprobarRechazar").val();
            if (valbtn === "Aprobar") {
                aprobar_postulacion($("#txt-idjobapplication").val());
            }
            if (valbtn === "Rechazar") {
                rechazar_postulacion($("#txt-idjobapplication").val());
            }
        }
        $(formCheck).addClass('was-validated'); // añadir validaciones
    });
    // FIN - FUNCION APROBAR O RECHAZAR



    // INICIO - MODAL DELETE
    $("#datatableGeneral tbody").on("click", ".deleteBtn", function (e) {
        let idjobapplication = $(this).data("idjobapplication")
        // confirmacion
        confirmation_sweetAlert("Deseas continuar?", "Se procederá a eliminar el registro de la base de datos", "warning")
            .then(function (isConfirm) {
                if (isConfirm.value) {
                    // enviando el parametro de la data que se procede a delete
                    destroy(idjobapplication);
                } else {
                    console.log("Cancelado");
                }
            });
    });
    // FIN - MODAL DELETE



    function aprobar_postulacion(idjobapplication) {
        formModal = $('#formModal');
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'PUT',
            url: '/admin/bolsa_laboral/postulaciones/aprobar/' + idjobapplication,
            data: formModal.serialize(),
            dataType: 'json',
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    setTimeout(function () {
                        notificaciontoast("info", data.mensaje, "Éxito!");
                        $("#modalFeedback").modal("hide");
                    }, 1000);   // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log('Error', error)
            }
        })
    }

    function rechazar_postulacion(idjobapplication) {
        formModal = $('#formModal');
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'PUT',
            url: '/admin/bolsa_laboral/postulaciones/rechazar/' + idjobapplication,
            data: formModal.serialize(),
            dataType: 'json',
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    setTimeout(function () {
                        notificaciontoast("info", data.mensaje, "Éxito!");
                        $("#modalFeedback").modal("hide");
                    }, 1000);   // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log('Error', error)
            }
        })
    }

    function destroy(idjobapplication) {
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: "DELETE",
            url: '/admin/bolsa_laboral/postulaciones/destroy/' + idjobapplication,
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    notificaciontoast("info", data.mensaje, "Éxito!");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

});


