import { notificaciontoast } from "../jsAjaxToastSweetalert/method_toast.js";
import { confirmation_sweetAlert } from "../jsAjaxToastSweetalert/method_sweetAlert.js";

window.addEventListener("DOMContentLoaded", async () => {

    // om
    var js_btndownload = document.querySelector("#btnUpload_Plantilla");
    js_btndownload.addEventListener("click", async (e) => {

        // validacion campos vacios
        if (document.getElementById("text_nombreplan").value === "") {
            notificaciontoast("error", "Debe llenar el nombre del plan");
            return;
        }

        if (document.getElementById("cb_programa").value === "0") {
            notificaciontoast("error", "Debe Seleccionar un programa");
            return;
        }

        if (document.getElementById("cb_tipoplan").value === "") {
            notificaciontoast("error", "Debe Seleccionar un plan");
            return;
        }

        if (document.getElementById("cb_modalidad").value === "") {
            notificaciontoast("error", "Debe Seleccionar una modalidad");
            return;
        }

        if (document.getElementById("cb_enfoque").value === "") {
            notificaciontoast("error", "Debe Seleccionar un enfoque");
            return;
        }

        e.preventDefault();
        $("#archivo").click();
    });

    var js_btnarchivo = document.querySelector("#archivo");
    js_btnarchivo.addEventListener('change', function () {
        confirmation_sweetAlert("Deseas continuar?", "Se procederá a importar el excel", "warning")
            .then(function (isConfirm) {
                if (isConfirm.value) {
                    var inputArchivo = document.getElementById('archivo');
                    var nombreArchivo = inputArchivo.value.split("\\").pop();
                    document.getElementById("name_archivo_upload").innerHTML = `<i class="fa-solid fa-file-excel"></i> ${nombreArchivo}`;
                    document.getElementById('progressSection').style.display = 'block';

                    const progreso = document.getElementById('progreso');
                    const porcentaje = document.getElementById('porcentaje');
                    let cantidad = 0;
                    let tiempoCargaEstimado = 9000; // Tiempo estimado en milisegundos para la carga del servidor (5 segundos en este ejemplo)
                    let intervalo = tiempoCargaEstimado / 100; // Intervalo de actualización de la barra de progreso

                    let tiempo = setInterval(() => {
                        cantidad += 1;
                        progreso.style.width = `${cantidad}%`;

                        if (cantidad === 100) {
                            clearInterval(tiempo);
                            setTimeout(() => {
                                var formData = $('#form').serialize();

                                $.ajax({
                                    headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
                                    type: 'POST',
                                    url: route_ajax_store_plan,     // ruta para guardar el plan en base de datos
                                    data: formData,
                                    dataType: 'json',
                                    beforeSend: function () { },
                                    success: function (data) {
                                        if (data.status == true) {
                                            notificaciontoast('info', data.mensaje, 'Éxito!');
                                            var idplan = data.idplan;
                                            var formDatas = $('#form').serialize(); // Obtener los datos del formulario en forma de cadena
                                            formDatas += '&nivel_formativo=' + encodeURIComponent(window.nivelSeleccionado); // Agregar `nivel_formativo`xx
                                            $.ajax({
                                                headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
                                                type: 'POST',
                                                url: "/admin/institucion/periodo/store/" + idplan,
                                                data: formDatas,
                                                dataType: 'json',
                                                beforeSend: function () { },
                                                success: function (data) {
                                                    if (data.status == true) {
                                                        notificaciontoast('info', data.mensaje, 'Éxito!');
                                                        var formData = new FormData(document.getElementById("form"));
                                                        const nuevosIDs = data.nuevosIDs; // Supongamos que `nuevosIDs` contiene los IDs
                                                        nuevosIDs.forEach(id => {
                                                            formData.append('nuevosIDs[]', id);
                                                        });
                                                        // GET OPTION
                                                        console.log(window.nivelSeleccionado);
                                                        console.log($('#cb_tipoplan').val());
                                                        var optionExcel = '';
                                                        if ($('#cb_tipoplan').val() == 'Modular') {
                                                            optionExcel += 'MOD_'
                                                        }
                                                        else if ($('#cb_tipoplan').val() == 'Transversal') {
                                                            optionExcel += 'TRA_'
                                                        }
                                                        if (window.nivelSeleccionado == 'Profesional Técnico') {
                                                            optionExcel += 'PRO'
                                                        } else if (window.nivelSeleccionado == 'Técnico') {
                                                            optionExcel += 'TEC'
                                                        }
                                                        // CARGAR EXCEL
                                                        fetch('/admin/institucion/planes/upload/' + optionExcel, {
                                                            method: "POST",
                                                            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
                                                            body: formData,
                                                        })
                                                            .then(function checkStatus(response) {
                                                                if (response.status >= 200 && response.status < 300) {
                                                                    notificaciontoast('info', data.mensaje, 'Cursos cargados');
                                                                    document.getElementById('archivo').value = '';
                                                                    document.getElementById("name_archivo_upload").innerHTML = '';
                                                                    return response.json();
                                                                } else {
                                                                    var error = new Error(response.statusText);
                                                                    document.getElementById('archivo').value = '';
                                                                    document.getElementById("name_archivo_upload").innerHTML = '';
                                                                    error.response = response;
                                                                    return response.json();
                                                                }
                                                            })
                                                            .then(function (response) {

                                                                window.table.ajax.reload();
                                                                setTimeout(() => {
                                                                    $('#progressSection').hide(); // Ocultar el preload tras completar el proceso en el servidor
                                                                    document.getElementById('archivo').value = '';
                                                                    document.getElementById("name_archivo_upload").innerHTML = '';
                                                                }, 1000); // Tiempo de espera antes de ocultar el preload (en milisegundos)
                                                            })
                                                            .catch(function (error) {
                                                                setTimeout(() => {
                                                                    $('#progressSection').hide(); // Ocultar el preload en caso de error
                                                                    document.getElementById('archivo').value = '';
                                                                    document.getElementById("name_archivo_upload").innerHTML = '';
                                                                }, 1000); // Tiempo de espera antes de ocultar el preload (en milisegundos)
                                                            });
                                                    } else {
                                                        notificaciontoast('error', 'Error!');
                                                        document.getElementById('archivo').value = '';
                                                        document.getElementById("name_archivo_upload").innerHTML = '';
                                                    }
                                                },
                                                error: function (response) {
                                                    console.log('Error', response.mensaje);
                                                    document.getElementById('archivo').value = '';
                                                    document.getElementById("name_archivo_upload").innerHTML = '';
                                                }
                                            });
                                            // Continuar con más acciones si es necesario
                                        } else {
                                            notificaciontoast('error', 'Error!');
                                            document.getElementById('archivo').value = '';
                                            document.getElementById("name_archivo_upload").innerHTML = '';
                                        }
                                    },
                                    error: function (error) {
                                        console.log('Error', error);
                                        document.getElementById('archivo').value = '';
                                        document.getElementById("name_archivo_upload").innerHTML = '';
                                    }
                                });
                            }, 1000); // Simulación de tiempo antes de realizar la solicitud al servidor
                        }
                        porcentaje.textContent = `${cantidad}%`;
                    }, intervalo); // Usar el intervalo calculado
                } else {
                    console.log("Cancelado");
                }
            });
    });
});
