import { notificaciontoast } from "../jsAjaxToastSweetalert/method_toast.js";
import { confirmation_sweetAlert } from "../jsAjaxToastSweetalert/method_sweetAlert.js";

$(document).ready(function () {

    const tableName_categorias = "Categorias de Ofertas";

    // LISTAR DATATABLE CATEGORIAS
    var table_categorias = $('#datatableGeneral_categorias').DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'POST',
            url: '/admin/bolsa_laboral/categorias/list',
        },
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: {
            search: 'Buscar',
            info: 'Mostrando _START_ a _END_ de _TOTAL_ Registros',
            zeroRecords: 'No hay registros para mostrar.',
            infoFiltered: '(Filtrados de _MAX_ Registros)',
            emptyTable: 'La tabla está vacia.',
            infoEmpty: 'No hay registros',
            paginate: {
                next: '<i class="fa-solid fa-angle-right"></i>',
                previous: '<i class="fa-solid fa-angle-left"></i>'
            }
        },
        buttons: [{
            extend: "excel",
            title: "Reporte de " + tableName_categorias,
            type: "button",
            orientation: "landscape",
            className: "btn btn-sm btn-arounded",
            exportOptions: {
                columns: ":visible",
                columns: ":not(.noExport)",
                orthogonal: "print"
            },
        },
        {
            extend: "pdf",
            title: "Reporte de " + tableName_categorias,
            type: "button",
            orientation: "landscape",
            className: "btn btn-sm btn-arounded ",
            exportOptions: {
                columns: ":visible",
                columns: ":not(.noExport)",
                orthogonal: "print"
            },
        },
        {
            extend: "print",
            title: "Reporte de " + tableName_categorias,
            type: "button",
            orientation: "landscape",
            className: "btn btn-sm btn-arounded",
            exportOptions: {
                columns: ":visible",
                columns: ":not(.noExport)",
                orthogonal: "print"
            },
        },
        {
            extend: "colvis",
            text: "Seleccionar celdas",
            title: "Reporte de " + tableName_categorias,
            type: "button",
            orientation: "landscape",
            className: "btn btn-sm btn-arounded",
            exportOptions: {
                columns: ":visible",
                columns: ":not(.noExport)",
                orthogonal: "print"
            },
        },
        ],
        columns: [
            { data: 'idcategory', className: 'text-center' },
            { data: 'nombre', className: 'text-center' },
            {
                data: "idcategory",
                className: "text-center noExport",
                sortable: false,
                searchable: false,
                render: function (data, type, all, meta) {
                    return `
                            <div class="d-flex justify-content-center">

                                <a href="javascript:void(0);" class="editBtn btn btn-dark shadow btn-xs sharp me-1"
                                data-idcategory="${all.idcategory}"
                                data-nombre="${all.nombre}"
                                data-bs-placement="top"
                                title="Editar registro">
                                <i class="fas fa-pencil-alt"></i>
                                </a>

                                <a href="javascript:void(0);" class="deleteBtn btn btn-dark shadow btn-xs sharp"
                                data-idcategory="${all.idcategory}"
                                data-bs-placement="top"
                                title="Eliminar registro">
                                <i class="fas fa-trash"></i>
                                </a>

                            </div>

                            `;
                },
            },
        ]
    });

    const tableName_Etiquetas = "Etiquetas de Ofertas";

    // LISTAR DATATABLE CATEGORIAS
    var table_etiquetas = $('#datatableGeneral_etiquetas').DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'POST',
            url: '/admin/bolsa_laboral/etiquetas/list',
        },
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: {
            search: 'Buscar',
            info: 'Mostrando _START_ a _END_ de _TOTAL_ Registros',
            zeroRecords: 'No hay registros para mostrar.',
            infoFiltered: '(Filtrados de _MAX_ Registros)',
            emptyTable: 'La tabla está vacia.',
            infoEmpty: 'No hay registros',
            paginate: {
                next: '<i class="fa-solid fa-angle-right"></i>',
                previous: '<i class="fa-solid fa-angle-left"></i>'
            }
        },
        buttons: [{
            extend: "excel",
            title: "Reporte de " + tableName_Etiquetas,
            type: "button",
            orientation: "landscape",
            className: "btn btn-sm btn-arounded",
            exportOptions: {
                columns: ":visible",
                columns: ":not(.noExport)",
                orthogonal: "print"
            },
        },
        {
            extend: "pdf",
            title: "Reporte de " + tableName_Etiquetas,
            type: "button",
            orientation: "landscape",
            className: "btn btn-sm btn-arounded ",
            exportOptions: {
                columns: ":visible",
                columns: ":not(.noExport)",
                orthogonal: "print"
            },
        },
        {
            extend: "print",
            title: "Reporte de " + tableName_Etiquetas,
            type: "button",
            orientation: "landscape",
            className: "btn btn-sm btn-arounded",
            exportOptions: {
                columns: ":visible",
                columns: ":not(.noExport)",
                orthogonal: "print"
            },
        },
        {
            extend: "colvis",
            text: "Seleccionar celdas",
            title: "Reporte de " + tableName_Etiquetas,
            type: "button",
            orientation: "landscape",
            className: "btn btn-sm btn-arounded",
            exportOptions: {
                columns: ":visible",
                columns: ":not(.noExport)",
                orthogonal: "print"
            },
        },
        ],
        columns: [
            { data: 'idtag', className: 'text-center' },
            { data: 'nombre', className: 'text-center' },
            {
                data: "idtag",
                className: "text-center noExport",
                sortable: false,
                searchable: false,
                render: function (data, type, all, meta) {
                    return `
                            <div class="d-flex justify-content-center">

                                <a href="javascript:void(0);" class="editBtn btn btn-dark shadow btn-xs sharp me-1"
                                data-idtag="${all.idtag}"
                                data-nombre="${all.nombre}"
                                data-bs-placement="top"
                                title="Editar registro">
                                <i class="fas fa-pencil-alt"></i>
                                </a>

                                <a href="javascript:void(0);" class="deleteBtn btn btn-dark shadow btn-xs sharp"
                                data-idtag="${all.idtag}"
                                data-bs-placement="top"
                                title="Eliminar registro">
                                <i class="fas fa-trash"></i>
                                </a>

                            </div>

                            `;
                },
            },
        ]
    });

    var valbtn, formCheck, formModal;


    // INICIO - CATEGORIAS SELECCIONADO
    $("#dt-categorias-tab").on("click", function (event) {
        event.preventDefault();
        $("#btnCreateUpdate").attr("value", "Create_Categoria");
        $('#btnCreateModal').html(`+ Nueva Categoría`);
        console.log('categorias seleccionado')
    });
    // FIN - CATEGORIAS SELECCIONADO

    // INICIO - ETIQUETAS SELECCIONADO
    $("#dt-etiquetas-tab").on("click", function (event) {
        event.preventDefault();
        $("#btnCreateUpdate").attr("value", "Create_Etiqueta");
        $('#btnCreateModal').html(`+ Nueva Etiqueta`);
        console.log('etiquetas seleccionado')
    });
    // FIN - ETIQUETAS SELECCIONADO


    // INICIO - MODAL CREATE
    $("#btnCreateModal").click(function () {
        valbtn = $("#btnCreateUpdate").val();
        $("#btnCreateUpdate").html("Registrar");
        // FUNCION CREAR
        if (valbtn === "Create_Categoria") {
            $("#modalCreateUpdateLabel").html("Registrar nueva categoria");
        }
        // FUNCION ACTUALIZAR
        if (valbtn === "Create_Etiqueta") {
            $("#modalCreateUpdateLabel").html("Registrar nueva etiqueta");
        }
        // limpiar validaciones
        formCheck = $("#formModal")[0];
        $(formCheck).removeClass('was-validated'); // remover validaciones
        clearForm();
    });
    // FIN - MODAL CREATE

    // INICIO - MODAL UPDATE CATEGORIAS
    $("#datatableGeneral_categorias tbody").on("click", ".editBtn", function (e) {
        // limpiar validaciones
        formCheck = $("#formModal")[0];
        $(formCheck).removeClass('was-validated'); // remover validaciones
        //cambiar el text del button
        $("#btnCreateUpdate").attr("value", "Update_Categoria");
        $("#btnCreateUpdate").html("Actualizar");
        $("#modalCreateUpdateLabel").html("Actualizar datos de la categoría");
        // setear data de usuario
        $("#txt-idcategory").val($(this).data("idcategory"));
        $("#txt-nombre").val($(this).data("nombre"));
        // show form
        $("#modalCreateUpdate").modal("show");
    });
    // FIN - MODAL UPDATE CATEGORIAS

    // Cuando se cierra el modal, limpia todo
    $('#modalCreateUpdate').on('hidden.bs.modal', function () {
        clearForm();
        // quitar validaciones visuales
        formCheck = $("#formModal")[0];
        $(formCheck).removeClass('was-validated');

        // restaurar texto y modo del botón
        $("#btnCreateUpdate").html("Registrar");
        $("#btnCreateUpdate").attr("value", "Create_Categoria");

        // restaurar título según pestaña activa
        if ($("#dt-categorias-tab").hasClass("active")) {
            $("#modalCreateUpdateLabel").html("Registrar nueva categoría");
        } else {
            $("#modalCreateUpdateLabel").html("Registrar nueva etiqueta");
        }
    });

    // INICIO - MODAL DELETE CATEGORIAS
    $("#datatableGeneral_categorias tbody").on("click", ".deleteBtn", function (e) {
        let idcategory = $(this).data("idcategory")
        // confirmacion
        confirmation_sweetAlert("Deseas continuar?", "Se procederá a eliminar el registro de la base de datos", "warning")
            .then(function (isConfirm) {
                if (isConfirm.value) {
                    // enviando el parametro de la data que se procede a delete
                    destroy_category(idcategory);
                } else {
                    console.log("Cancelado");
                }
            });
    });
    // FIN - MODAL DELETE CATEGORIAS

    // INICIO - MODAL UPDATE ETIQUETAS
    $("#datatableGeneral_etiquetas tbody").on("click", ".editBtn", function (e) {
        // limpiar validaciones
        formCheck = $("#formModal")[0];
        $(formCheck).removeClass('was-validated'); // remover validaciones
        //cambiar el text del button
        $("#btnCreateUpdate").attr("value", "Update_Etiqueta");
        $("#btnCreateUpdate").html("Actualizar");
        $("#modalCreateUpdateLabel").html("Actualizar datos de la etiqueta");
        // setear data de usuario
        $("#txt-idtag").val($(this).data("idtag"));
        $("#txt-nombre").val($(this).data("nombre"));
        // show form
        $("#modalCreateUpdate").modal("show");
    });
    // FIN - MODAL UPDATE ETIQUETAS

    // INICIO - MODAL DELETE ETIQUETAS
    $("#datatableGeneral_etiquetas tbody").on("click", ".deleteBtn", function (e) {
        let idtag = $(this).data("idtag")
        // confirmacion
        confirmation_sweetAlert("Deseas continuar?", "Se procederá a eliminar el registro de la base de datos", "warning")
            .then(function (isConfirm) {
                if (isConfirm.value) {
                    // enviando el parametro de la data que se procede a delete
                    destroy_tag(idtag);
                } else {
                    console.log("Cancelado");
                }
            });
    });
    // FIN - MODAL DELETE ETIQUETAS

    // INICIO - FUNCION CREATE O UPDATE
    $("#btnCreateUpdate").on("click", function (event) {
        event.preventDefault();
        // Iterar sobre los formularios y evitar la acción predeterminada si no son válidos
        formCheck = $("#formModal")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
        } else {
            valbtn = $("#btnCreateUpdate").val();
            if (valbtn === "Create_Categoria") {
                // insertar
                store_category();
            }
            if (valbtn === "Update_Categoria") {
                // actualizar
                update_category($("#txt-idcategory").val());
            }
            if (valbtn === "Create_Etiqueta") {
                // insertar
                store_tag();
            }
            if (valbtn === "Update_Etiqueta") {
                // actualizar
                update_tag($("#txt-idtag").val());
            }
        }
        $(formCheck).addClass('was-validated'); // añadir validaciones
    });
    // FIN - FUNCION CREATE O UPDATE


    function store_category() {
        formModal = $('#formModal');
        $.ajax({
            type: "POST",
            url: '/admin/bolsa_laboral/categorias/store',
            data: formModal.serialize(),
            dataType: 'json',
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table_categorias.ajax.reload();
                    setTimeout(function () {
                        notificaciontoast("info", data.mensaje, "Éxito!");
                        $("#modalCreateUpdate").modal("hide");
                    }, 1000); // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function update_category(idcategory) {
        formModal = $('#formModal');
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'PUT',
            url: '/admin/bolsa_laboral/categorias/update/' + idcategory,
            data: formModal.serialize(),
            dataType: 'json',
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table_categorias.ajax.reload();
                    setTimeout(function () {
                        notificaciontoast("info", data.mensaje, "Éxito!");
                        $("#modalCreateUpdate").modal("hide");
                    }, 1000);   // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log('Error', error)
            }
        })
    }

    function destroy_category(idcategory) {
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: "DELETE",
            url: '/admin/bolsa_laboral/categorias/destroy/' + idcategory,
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table_categorias.ajax.reload();
                    notificaciontoast("info", data.mensaje, "Éxito!");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }


    function store_tag() {
        formModal = $('#formModal');
        $.ajax({
            type: "POST",
            url: '/admin/bolsa_laboral/etiquetas/store',
            data: formModal.serialize(),
            dataType: 'json',
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table_etiquetas.ajax.reload();
                    setTimeout(function () {
                        notificaciontoast("info", data.mensaje, "Éxito!");
                        $("#modalCreateUpdate").modal("hide");
                    }, 1000); // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function update_tag(idtag) {
        formModal = $('#formModal');
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'PUT',
            url: '/admin/bolsa_laboral/etiquetas/update/' + idtag,
            data: formModal.serialize(),
            dataType: 'json',
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table_etiquetas.ajax.reload();
                    setTimeout(function () {
                        notificaciontoast("info", data.mensaje, "Éxito!");
                        $("#modalCreateUpdate").modal("hide");
                    }, 1000);   // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log('Error', error)
            }
        })
    }

    function destroy_tag(idtag) {
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: "DELETE",
            url: '/admin/bolsa_laboral/etiquetas/destroy/' + idtag,
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table_etiquetas.ajax.reload();
                    notificaciontoast("info", data.mensaje, "Éxito!");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // LIMPIAR FORMULARIO
    function clearForm() {
        $("#txt-idcategory").val("");
        $("#txt-idtag").val("");
        $("#txt-nombre").val("");
    }

});


