"use strict";

(function () {
    var chartBarDonut = function () {
        // RESPUESTA HTTP
        function checkStatus(response) {
            if (response.status >= 200 && response.status < 300) {
                return response;
            } else {
                var error = new Error(response.statusText);
                error.response = response;
                throw error;
            }
        }

        function parseJSON(response) {
            return response.json();
        }

        // FUNCIÓN RESPUESTAS EN TOAST
        function fuctionRespuesta(response) {
            var totalactivo = 0;
            var totalinactivo = 0;
            var total = 0;

            response.data.forEach((elemento) => {
                if (elemento.estadouser === "Activos") {
                    totalactivo = parseInt(elemento.datatotal);
                } else if (elemento.estadouser === "Inactivos") {
                    totalinactivo = parseInt(elemento.datatotal);
                }
            });
            total = parseInt(totalactivo) + parseInt(totalinactivo);
            const chartOrderStatistics2 = document.querySelector(
                    "#orderStatisticsChart2"
                ),
                orderChartConfig2 = {
                    chart: {
                        height: 165,
                        width: 130,
                        type: "donut",
                    },
                    labels: ["Activos", "Inactivos"],
                    series: [totalactivo, totalinactivo],
                    colors: ["#00273A", "#FB7D5B"],
                    stroke: {
                        width: 3,
                        colors: "#ffffff",
                    },
                    dataLabels: {
                        enabled: true,
                        formatter: function (val, opt) {
                            return parseInt(val) + "%";
                        },
                    },
                    legend: {
                        show: false,
                    },
                    grid: {
                        padding: {
                            top: 0,
                            bottom: 0,
                            right: 15,
                        },
                    },
                    plotOptions: {
                        pie: {
                            donut: {
                                position: "center",
                                size: "65%",
                                labels: {
                                    show: true,
                                    value: {
                                        fontSize: "18px",
                                        fontFamily: "poppins",
                                        color: "#757371",
                                        offsetY: -15,
                                        formatter: function (val) {
                                            return parseInt(val) + "";
                                        },
                                    },
                                    name: {
                                        offsetY: 20,
                                        fontFamily: "poppins",
                                    },
                                    total: {
                                        show: true,
                                        fontSize: "0.8125rem",
                                        color: "#fff",
                                        label: "Totales",
                                        formatter: function (w) {
                                            return total;
                                        },
                                    },
                                },
                            },
                        },
                    },
                };
            if (
                typeof chartOrderStatistics2 !== undefined &&
                chartOrderStatistics2 !== null
            ) {
                const statisticsChart2 = new ApexCharts(
                    chartOrderStatistics2,
                    orderChartConfig2
                );
                statisticsChart2.render();
            }
        }

        // CONSULTA A LA BD routeDashboardgraficadonustres
        fetch(routeDashboardgraficadonusuno, {
            method: "GET",
        })
            .then(checkStatus)
            .then(parseJSON)
            .then((response) => {
                fuctionRespuesta(response);
            })
            .catch(function (error) {
                console.log("request failed", error);
            });
    };

    chartBarDonut();
})();
