

(function ($) {
    /* "use strict" */

    var dlabChartlist = function () {


        var chartBarRunningprograma = function () {
                // RESPUESTA HTTP
                function checkStatus(response) {
                    if (response.status >= 200 && response.status < 300) {
                        return response;
                    } else {
                        var error = new Error(response.statusText)
                        error.response = response
                        throw error
                    }
                }

                function parseJSON(response) {
                    return response.json()
                }

                // FUNCIÓN RESPUESTAS EN TOAST
                function fuctionRespuesta(response) {

                    const nombresProgramas = [];

                    // Recorrer el array original y obtener los nombres de los programas
                    response.data.forEach(item => {
                        nombresProgramas.push(item.programa);
                    });

                   // Arrays para almacenar las cantidades por género
                    const cantidadesMasculino = [];
                    const cantidadesFemenino = [];
                    const cantidadesOtros = [];

                    // Recorrer el array original para obtener las cantidades por género y almacenarlas en los arrays correspondientes
                    response.data.forEach(item => {
                        cantidadesMasculino.push(item.masculino);
                        cantidadesFemenino.push(item.femenino);
                        cantidadesOtros.push(item.otros);
                    });


                    var series_array = [
                        {
                            name: 'Masculino: ',
                            data: cantidadesMasculino
                        },
                        {
                            name: 'Femenino: ',
                            data: cantidadesFemenino
                        },
                        {
                            name: 'Otros: ',
                            data: cantidadesOtros
                        },
                    ]

                   var options = {
                        series: series_array,
                        chart: {
                            type: 'bar',
                            height: 300,
                            toolbar: {
                                show: false,
                            },

                        },
                        plotOptions: {
                            bar: {
                                horizontal: false,
                                endingShape: 'rounded',
                                columnWidth: '45%',
                                borderRadius: 5,

                            },
                        },
                        colors: ['#00273A', '#FB7D5B'],
                        dataLabels: {
                            enabled: true,
                        },
                        markers: {
                            shape: "circle",
                        },
                        legend: {
                            show: true,
                            fontSize: '8px',
                            labels: {
                                colors: '#000000',

                            },
                            markers: {
                                width: 30,
                                height: 30,
                                strokeWidth: 0,
                                strokeColor: '#fff',
                                fillColors: undefined,
                                radius: 35,
                            }
                        },
                        stroke: {
                            show: true,
                            width: 6,
                        },
                        xaxis: {
                            categories: nombresProgramas,
                            labels: {
                                style: {
                                    fontSize: '13px',
                                    fontFamily: 'poppins',
                                    fontWeight: 100,
                                    cssClass: 'apexcharts-xaxis-label',
                                },
                            },
                            axisBorder: {
                                show: false,
                            },
                            axisTicks: {
                                show: false,
                                borderType: 'solid',
                                color: '#78909C',
                                height: 6,
                                offsetX: 0,
                                offsetY: 0
                            },
                            crosshairs: {
                                show: false,
                            }
                        },
                        yaxis: {
                            labels: {
                                offsetX: -16,
                                style: {
                                    fontSize: '13px',
                                    fontFamily: 'poppins',
                                    fontWeight: 100,
                                    cssClass: 'apexcharts-xaxis-label',
                                },
                            },
                        },
                        fill: {
                            opacity: 1,
                        },
                        tooltip: {
                            y: {
                                formatter: function (val) {
                                    return "" + val + " en total"
                                }
                            }
                        },
                        grid: {
                            borderColor: '#C1BBEB',
                            xaxis: {
                                lines: {
                                    show: false
                                },
                            },
                            yaxis: {
                                lines: {
                                    show: true
                                },
                            },
                        },
                        responsive: [{
                            breakpoint: 575,
                            options: {
                                plotOptions: {
                                    bar: {
                                        columnWidth: '1%',
                                        borderRadius: -1,
                                    },
                                },
                                chart: {
                                    height: 250,
                                },
                                series: [
                                    {
                                        name: 'Projects',
                                        data: [31, 40, 28, 31, 40, 28, 31, 40]
                                    },
                                    {
                                        name: 'Projects',
                                        data: [11, 32, 45, 31, 40, 28, 31, 40]
                                    },

                                ],
                            }
                        }]
                    };

                    if (jQuery("#chartBarRunning_programas").length > 0) {

                        var chart = new ApexCharts(document.querySelector("#chartBarRunning_programas"), options);
                        chart.render();

                        jQuery('#dzOldSeries1').on('change', function () {
                            jQuery(this).toggleClass('disabled');
                            chart.toggleSeries('Income');
                        });

                        jQuery('#dzNewSeries1').on('change', function () {
                            jQuery(this).toggleClass('disabled');
                            chart.toggleSeries('Expense');
                        });

                    }

                }

                // CONSULTA A LA BD
                    fetch(routeDashboardgraficabarrasprogramas,
                    {
                      method: "GET",
                    })
                    .then(checkStatus)
                    .then(parseJSON)
                    .then((response) => {
                        fuctionRespuesta(response);
                    })
                    .catch(function (error) {
                        console.log('request failed', error)
                    })
        }

        /* Function ============ */
        return {
            init: function () {
            },


            load: function () {
                chartBarRunningprograma();
            },

            resize: function () {
                chartBarRunningprograma();
            }
        }
    }();



    jQuery(window).on('load', function () {
        setTimeout(function () {
            dlabChartlist.load();
        }, 1000);

    });



})(jQuery);
