<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bt_solicitudes_empleos', function (Blueprint $table) {
            $table->id();


            $table->date('fecaplicacion');
            $table->tinyInteger('estado');
            $table->text('documento');
            $table->tinyInteger('isvisto');
            $table->text('feedback');
            $table->date('fecfeedback');


            $table->unsignedBigInteger('jpjob_id');
            $table->unsignedBigInteger('student_id');


            $table->foreign('jpjob_id')->references('id')->on('bt_trabajos');
            $table->foreign('student_id')->references('id')->on('estudiantes');


            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bt_solicitudes_empleos');
    }
};
