<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bt_empresas', function (Blueprint $table) {
            $table->id();

            $table->string('nombre', 90);
            $table->string('ruc', 45);
            $table->string('direccion', 256);
            $table->string('nrocontacto', 45);
            $table->tinyInteger('estado');
            $table->string('user', 45)->nullable();
            $table->string('password', 256)->nullable();
            $table->text('logo')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bt_empresas');
    }
};
