<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Transfer
 *
 * @property $id
 * @property $tipo
 * @property $fecha
 * @property $documento
 * @property $student_id
 * @property $created_at
 * @property $updated_at
 *
 * @property Student $student
 * @property Externaltransfer[] $internaltransfers
 * @property Internaltransfer[] $externaltransfers
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Transfer extends Model
{
    protected $table = 'traslados';
    
    static $rules = [
		'tipo' => 'required',
		'fecha' => 'required',
		'documento' => 'required',
		'student_id' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['tipo','fecha','documento','student_id'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function student()
    {
        return $this->hasOne('App\Models\Student', 'id', 'student_id');
    }
    
    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function externaltransfers()
    {
        return $this->hasMany('App\Models\Externaltransfer', 'transfer_id', 'id');
    }
    
    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function internaltransfers()
    {
        return $this->hasMany('App\Models\Internaltransfer', 'transfer_id', 'id');
    }
    

}
