<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Tdvoucher
 *
 * @property $id
 * @property $comprobante
 * @property $concepto
 * @property $estado
 * @property $tddocument_id
 * @property $created_at
 * @property $updated_at
 *
 * @property Tddocument $tddocument
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Tdvoucher extends Model
{
  protected $table = 'td_comprobantes';

    static $rules = [
		'comprobante' => 'required',
		'concepto' => 'required',
		'tddocument_id' => 'required',
		// 'ts_pagos_personas_id' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    // protected $fillable = ['comprobante','concepto','estado','tddocument_id','ts_pagos_personas_id'];
    protected $fillable = ['comprobante','concepto','estado','tddocument_id'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function tddocument()
    {
        return $this->hasOne('App\Models\Tddocument', 'id', 'tddocument_id');
    }

    // public function ts_pagos_personas()
    // {
    //     return $this->hasOne('App\Models\ts_pagos_personas', 'id', 'ts_pagos_personas_id');
    // }


}
