<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 */
class TdRequest extends Model
{
    protected $table = 'td_requests';

    static $rules = [
        'student_id' => 'required',
        'td_request_type_id' => 'required',
        'codigo' => 'required',
        'asunto' => 'required',
        'folios' => 'required',
        'estado' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['student_id', 'td_request_type_id', 'codigo', 'asunto', 'folios', 'estado', 'fecha', 'administrator_id', 'rpta_nombre', 'rpta_ruta', 'rtpa_mensaje', 'rpta_fecha'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function td_files()
    {
        return $this->hasMany('App\Models\TdFile', 'td_request_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function student()
    {
        return $this->hasOne('App\Models\Student', 'id', 'student_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function td_request_type()
    {
        return $this->hasOne('App\Models\TdRequestType', 'id', 'td_request_type_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function administrator()
    {
        return $this->hasOne('App\Models\Administrator', 'id', 'administrator_id');
    }

}
