<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Subjectclass
 *
 * @property $id
 * @property $schedule_id
 * @property $nombre
 * @property $dia
 * @property $fecha
 * @property $estado
 * @property $created_at
 * @property $updated_at
 *
 * @property Grade[] $grades
 * @property Schedule $schedule
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */

class Subjectclass extends Model
{
    protected $table = 'clases_asignaturas';

    static $rules = [
        'schedule_id' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['schedule_id', 'nombre', 'dia', 'fecha', 'estado'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function attendances()
    {
        return $this->hasMany('App\Models\Attendance', 'subjectclass_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function schedule()
    {
        return $this->hasOne('App\Models\Schedule', 'id', 'schedule_id');
    }
}
