<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Subject
 *
 * @property $id
 * @property $seccion
 * @property $turno
 * @property $tipo
 * @property $nota_minima
 * @property $silabo
 * @property $instrumentos_evaluacion
 * @property $course_id
 * @property $semester_id
 * @property $teacher_id
 * @property $created_at
 * @property $updated_at
 *
 * @property Course $course
 * @property Schedule[] $schedules
 * @property Semester $semester
 * @property Subjectenrollment[] $subjectenrollments
 * @property Teacher $teacher
 * @property Scheduleingcalendar[] $Scheduleingcalendar
 * @property Repositorymaterials[] $repositorymaterials
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Subject extends Model
{
    protected $table = 'asignaturas';

    static $rules = [
		'course_id' => 'required',
		'semester_id' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['seccion','turno','tipo','nota_minima','silabo','instrumentos_evaluacion','course_id','semester_id','teacher_id'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function course()
    {
        return $this->hasOne('App\Models\Course', 'id', 'course_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function schedules()
    {
        return $this->hasMany('App\Models\Schedule', 'subject_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function semester()
    {
        return $this->hasOne('App\Models\Semester', 'id', 'semester_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function subjectenrollments()
    {
        return $this->hasMany('App\Models\Subjectenrollment', 'subject_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function teacher()
    {
        return $this->hasOne('App\Models\Teacher', 'id', 'teacher_id');
    }

       /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function Scheduleingcalendar()
    {
        return $this->hasMany('App\Models\Scheduleingcalendar', 'subject_id', 'id');
    }

     /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function Repositorymaterials()
    {
        return $this->hasMany('App\Models\Repositorymaterials', 'subject_id', 'id');
    }
}
