<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Repositorymaterials
 *
 * @property $id
 * @property $folder_id
 * @property $nombre
 * @property $created_at
 * @property $updated_at
 *
 * @property Folder[] $folders
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */

class Subfolder extends Model
{
    use HasFactory;
    protected $table = 'subcarpetas';

    static $rules = [
        'folder_id' => 'required',
        'nombre' => 'required'
    ];

    protected $perPage = 20;

    protected $fillable = ['folder_id','nombre'];


    public function folder()
    {
        return $this->hasOne('App\Models\Folder', 'id', 'folder_id');
    }

    public function folderfile()
    {
        return $this->hasMany('App\Models\Folderfile', 'subfolder_id', 'id');
    }
}
