<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Studentgrade
 *
 * @property $id
 * @property $subjectenrollment_id
 * @property $grade_id
 * @property $asistencia
 * @property $nota
 * @property $created_at
 * @property $updated_at
 *
 * @property Grade $grade
 * @property Subjectenrollment $subjectenrollment
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Studentgrade extends Model
{
    protected $table = 'notas_estudiantes';

    static $rules = [
        'subjectenrollment_id' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['subjectenrollment_id', 'grade_id', 'nota', 'fecha'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function grade()
    {
        return $this->hasOne('App\Models\Gradetype', 'id', 'gradetype_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function subjectenrollment()
    {
        return $this->hasOne('App\Models\Subjectenrollment', 'id', 'subjectenrollment_id');
    }
}
