<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Studentdocument
 *
 * @property $id
 * @property $fecha
 * @property $nombre
 * @property $tiempo
 * @property $ruta
 * @property $descripcion
 * @property $estado
 * @property $student_id
 * @property $created_at
 * @property $updated_at
 *
 * @property Student $student
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Studentdocument extends Model
{
  protected $table = 'documentos_estudiantes';

  static $rules = [
    'fecha' => 'required',
    'nombre' => 'required',
    'tiempo' => 'required',
    'ruta' => 'required',
    'descripcion' => 'required',
    'estado' => 'required',
    'student_id' => 'required',
  ];

  protected $perPage = 20;

  /**
   * Attributes that should be mass-assignable.
   *
   * @var array
   */
  protected $fillable = ['fecha', 'nombre', 'tiempo', 'ruta', 'descripcion','estado', 'student_id'];


  /**
   * @return \Illuminate\Database\Eloquent\Relations\HasOne
   */
  public function student()
  {
    return $this->hasOne('App\Models\Student', 'id', 'student_id');
  }
}
