<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Student
 *
 * @property $id
 * @property $anho_ingreso
 * @property $estado
 * @property $user_id
 * @property $plan_id
 * @property $created_at
 * @property $updated_at
 *
 * @property Studentvalidation[] $studentvalidations
 * @property Jpjobapplication[] $jpjobapplications
 * @property Plan $plan
 * @property Semesterenrollment[] $semesterenrollments
 * @property Socioeconomicsheet[] $socioeconomicsheets
 * @property Studentdocument[] $studentdocuments
 * @property Subjectenrollment[] $subjectenrollments
 * @property Tddocument[] $tddocuments
 * @property Transfer[] $transfers
 * @property User $user
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Student extends Model
{
    protected $table = 'estudiantes';

    use HasFactory;

    static $rules = [
        'anho_ingreso' => 'required',
        'estado' => 'required',
        'user_id' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['anho_ingreso', 'estado', 'user_id', 'plan_id'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function studentvalidations()
    {
        return $this->hasMany('App\Models\Studentvalidation', 'student_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function jpjobapplications()
    {
        return $this->hasMany('App\Models\Jpjobapplication', 'student_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function plan()
    {
        return $this->hasOne('App\Models\Plan', 'id', 'plan_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function semesterenrollments()
    {
        return $this->hasMany('App\Models\Semesterenrollment', 'student_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function socioeconomicsheets()
    {
        return $this->hasMany('App\Models\Socioeconomicsheet', 'student_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function studentdocuments()
    {
        return $this->hasMany('App\Models\Studentdocument', 'student_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function subjectenrollments()
    {
        return $this->hasMany('App\Models\Subjectenrollment', 'student_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function tddocuments()
    {
        return $this->hasMany('App\Models\Tddocument', 'student_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function transfers()
    {
        return $this->hasMany('App\Models\Transfer', 'student_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function user()
    {
        return $this->hasOne('App\Models\User', 'id', 'user_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function evaluateprogramming()
    {
        return $this->hasOne('App\Models\Evaluateprogramming', 'id', 'student_id');
    }
}
