<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Semester
 *
 * @property $id
 * @property $anho
 * @property $numero
 * @property $fecinicio
 * @property $fecfin
 * @property $estado
 * @property $created_at
 * @property $updated_at
 *
 * @property Semesterenrollment[] $semesterenrollments
 * @property Semesterperiod[] $semesterperiods
 * @property Subject[] $subjects
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Semester extends Model
{
    protected $table = 'semestres';

    use HasFactory;

    static $rules = [
        'anho' => 'required',
        'numero' => 'required',
        'tipo' => 'required',
        'fecinicio' => 'required',
        'fecfin' => 'required',
        'estado' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['anho', 'numero', 'tipo', 'fecinicio', 'fecfin', 'estado'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function semesterenrollments()
    {
        return $this->hasMany('App\Models\Semesterenrollment', 'semester_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function semesterperiods()
    {
        return $this->hasMany('App\Models\Semesterperiod', 'semester_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function subjects()
    {
        return $this->hasMany('App\Models\Subject', 'semester_id', 'id');
    }
}
