<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Period
 *
 * @property $id
 * @property $numero
 * @property $plan_id
 * @property $created_at
 * @property $updated_at
 *
 * @property Course[] $courses
 * @property Plan $plan
 * @property Semesterperiod[] $semesterperiods
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Period extends Model
{
    protected $table = 'periodos';

    use HasFactory;

    static $rules = [
        'numero' => 'required',
        'plan_id' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['numero', 'plan_id'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function courses()
    {
        return $this->hasMany('App\Models\Course', 'period_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function plan()
    {
        return $this->hasOne('App\Models\Plan', 'id', 'plan_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function semesterperiods()
    {
        return $this->hasMany('App\Models\Semesterperiod', 'period_id', 'id');
    }
}
