<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Logadmission
 *
 * @property $id
 * @property $administrator_id
 * @property $admission_id
 * @property $accion
 * @property $created_at
 * @property $updated_at
 *
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Logadmission extends Model
{
  protected $table = 'log_admisiones';

  static $rules = [
    'administrator_id' => 'required',
    'admission_id' => 'required',
    'accion' => 'required',
  ];

  protected $perPage = 20;

  /**
   * Attributes that should be mass-assignable.
   *
   * @var array
   */
  protected $fillable = ['administrator_id', 'admission_id', 'accion'];
}
