<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Jptag
 *
 * @property $id
 * @property $nombre
 * @property $created_at
 * @property $updated_at
 *
 * @property Jpjobtag[] $jpjobtags
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Jptag extends Model
{
  protected $table = 'bt_etiquetas';

  static $rules = [
    'nombre' => 'required',
  ];

  protected $perPage = 20;

  /**
   * Attributes that should be mass-assignable.
   *
   * @var array
   */
  protected $fillable = ['nombre'];


  /**
   * @return \Illuminate\Database\Eloquent\Relations\HasMany
   */
  public function jpjobtags()
  {
    return $this->hasMany('App\Models\Jpjobtag', 'jptag_id', 'id');
  }
}
