<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;

/**
 * Class Jpcompany
 *
 * @property $id
 * @property $nombre
 * @property $ruc
 * @property $direccion
 * @property $nrocontacto
 * @property $estado
 * @property $user
 * @property $password
 * @property $logo
 * @property $created_at
 * @property $updated_at
 *
 * @property Jpjob[] $jpjobs
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */

class Jpcompany extends Authenticatable
{
  protected $table = 'bt_empresas';

  static $rules = [
    'nombre' => 'required',
    'ruc' => 'required',
    'direccion' => 'required',
    'nrocontacto' => 'required',
    'correo' => 'required',
    'estado' => 'required',
    'user' => 'required',
    'logo' => 'required',
  ];

  protected $perPage = 20;

  /**
   * Attributes that should be mass-assignable.
   *
   * @var array
   */
  protected $fillable = ['nombre', 'ruc', 'direccion', 'nrocontacto', 'correo', 'estado', 'user', 'logo'];

  /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
      'password',
      // 'remember_token',
  ];


  /**
   * The attributes that should be cast.
   *
   * @var array<string, string>
   */
  protected $casts = [
      // 'email_verified_at' => 'datetime',
      'password' => 'hashed',
  ];


  /**
   * @return \Illuminate\Database\Eloquent\Relations\HasMany
   */
  public function jpjobs()
  {
    return $this->hasMany('App\Models\Jpjob', 'jpcompany_id', 'id');
  }
}
