<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Internaltransfer
 *
 * @property $id
 * @property $plan_id1
 * @property $plan_id2
 * @property $transfer_id
 * @property $created_at
 * @property $updated_at
 *
 * @property Plan $plan
 * @property Plan $plan
 * @property Transfer $transfer
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Internaltransfer extends Model
{
    protected $table = 'traslados_externos';

    static $rules = [
        'plan_id1' => 'required',
        'plan_id2' => 'required',
        'transfer_id' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['plan_id1', 'plan_id2', 'transfer_id'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function plan1()
    {
        return $this->hasOne('App\Models\Plan', 'id', 'plan_id1');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function plan2()
    {
        return $this->hasOne('App\Models\Plan', 'id', 'plan_id2');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function transfer()
    {
        return $this->hasOne('App\Models\Transfer', 'id', 'transfer_id');
    }
}
